/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.support.interceptor;

import com.jxdinfo.hussar.platform.core.utils.LocaleMessageUtils;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.interceptor.BaseInterceptor;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.RmiOAuthInfoService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiConnector;
import com.jxdinfo.hussar.support.rmi.core.exceptions.RmiApiRuntimeException;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequest;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultInterceptor
implements BaseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultInterceptor.class);
    @Autowired
    private RmiOAuthInfoService rmiOAuthInfoService;

    public boolean beforeExecute(RmiApiRequest request) {
        String isVerfy = String.valueOf(this.getAttribute(request, "isVerfy"));
        if ("0".equals(isVerfy)) {
            return true;
        }
        RmiConnector apiConnector = (RmiConnector)this.getAttribute(request, "connectorApi");
        HussarException.throwByNull((Object)apiConnector, (Integer)RmiExceptionEnum.CONNECTOR_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.VERFY_INFO_EMPTY.getMessage());
        String tokenKey = (String)this.getAttribute(request, "tokenKey");
        try {
            this.rmiOAuthInfoService.handelCtxToken(apiConnector, request, tokenKey);
        }
        catch (Exception e) {
            HussarException.throwBy((boolean)true, (String)e.getMessage());
        }
        return true;
    }

    public void onError(RmiApiRuntimeException ex, RmiApiRequest request, RmiApiResponse response) {
        LOGGER.debug(LocaleMessageUtils.getMessage((String)"ENGINE_INTERCEPTOR_ERROR"));
        HussarException.throwBy((boolean)true, (String)ex.getMessage());
    }
}

