/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.LocaleMessageUtils;
import com.jxdinfo.hussar.support.engine.plugin.rmi.auth.entity.AuthInterface;
import com.jxdinfo.hussar.support.engine.plugin.rmi.auth.service.AuthInterfaceService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.dao.RmiConnectorMapper;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.dao.RmiInterfaceMapper;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiInterfaceService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiClassifyEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiStatusEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.RmiOAuthInfoTestService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiConnector;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RmiInterfaceServiceImpl
extends HussarServiceImpl<RmiInterfaceMapper, RmiInterface>
implements RmiInterfaceService {
    @Autowired
    private AuthInterfaceService authInterfaceService;
    @Autowired
    private RmiConnectorMapper rmiConnectorMapper;
    @Autowired
    private RmiOAuthInfoTestService rmiOAuthInfoTestService;

    @Override
    public boolean deleteRmiInterface(Long rmiId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)rmiId), (String)LocaleMessageUtils.getMessage((String)"ENGINE_RMI_ID_NOT_EMPTY"));
        RmiInterface rmiInterface = (RmiInterface)this.getById(rmiId);
        if (HussarUtils.isEmpty((Object)rmiInterface)) {
            return Boolean.TRUE;
        }
        HussarException.throwBy((boolean)RmiStatusEnum.IN_USE.getValue().equals(rmiInterface.getRmiStatus()), (String)LocaleMessageUtils.getMessage((String)"ENGINE_ENABLE_INTERFACE_NOT_DEL"));
        return this.removeById(rmiId);
    }

    @Override
    public List<RmiInterface> getAuthInterfacesByConnectorCode(RmiConnector rmiConnector) {
        List<Object> rmiInterfaces = new ArrayList<RmiInterface>();
        String connectorCode = rmiConnector.getConnectorCode();
        Long appId = rmiConnector.getAppId();
        if (HussarUtils.isEmpty((Object)connectorCode)) {
            return rmiInterfaces;
        }
        List<String> classifys = Arrays.asList(RmiClassifyEnum.AUTH.getType(), RmiClassifyEnum.REFRESH.getType(), RmiClassifyEnum.AUTH_CALLBACK.getType());
        rmiInterfaces = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiInterface::getConnectorCode, (Object)connectorCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiInterface::getAppId, (Object)appId)).in(RmiInterface::getRmiClassify, classifys)).orderByAsc(RmiInterface::getRmiClassify)).orderByAsc(HussarBaseEntity::getCreateTime));
        return rmiInterfaces;
    }

    @Override
    public Long saveRmiInterface(RmiInterface rmiInterface) {
        this.checkRmiInterface(rmiInterface);
        this.saveOrUpdate((BaseEntity)rmiInterface);
        return rmiInterface.getRmiId();
    }

    @Override
    public Object saveAuthInterface(RmiInterface rmiInterface) {
        this.checkRmiInterface(rmiInterface);
        Long appId = rmiInterface.getAppId();
        String connectorCode = rmiInterface.getConnectorCode();
        RmiConnector rmiConnector = (RmiConnector)this.rmiConnectorMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiConnector::getConnectorCode, (Object)connectorCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiConnector::getAppId, (Object)appId));
        Object result = this.rmiOAuthInfoTestService.oAuthInfoTest(rmiConnector, rmiInterface, true);
        this.saveOrUpdate((BaseEntity)rmiInterface);
        return result;
    }

    private void checkRmiInterface(RmiInterface rmiInterface) {
        HussarException.throwByNull((Object)rmiInterface, (String)LocaleMessageUtils.getMessage((String)"ENGINE_INVOKE_INTERFACE_NOT_NULL"));
        String status = rmiInterface.getRmiStatus();
        if (RmiStatusEnum.IN_USE.getValue().equals(status)) {
            throw new HussarException(LocaleMessageUtils.getMessage((String)"ENGINE_ENABLE_INTERFACE_NOT_EDIT"));
        }
        this.checkRmiCode(rmiInterface);
        this.checkRmiName(rmiInterface);
    }

    private void checkRmiCode(RmiInterface rmiInterface) {
        long count;
        Long id = rmiInterface.getRmiId();
        String rmiCode = rmiInterface.getRmiCode();
        String connectorCode = rmiInterface.getConnectorCode();
        Long appId = rmiInterface.getAppId();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiInterface::getRmiCode, (Object)rmiCode)).eq(RmiInterface::getConnectorCode, (Object)connectorCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiInterface::getAppId, (Object)appId);
        if (HussarUtils.isNotEmpty((Object)id)) {
            wrapper.ne(RmiInterface::getRmiId, (Object)id);
        }
        HussarException.throwBy(((count = this.count((Wrapper)wrapper)) > 0L ? 1 : 0) != 0, (String)String.format(LocaleMessageUtils.getMessage((String)"ENGINE_INTERFACE_CODE_EXIST"), rmiCode));
    }

    private void checkRmiName(RmiInterface rmiInterface) {
        long count;
        Long id = rmiInterface.getRmiId();
        String rmiName = rmiInterface.getRmiName();
        Long appId = rmiInterface.getAppId();
        String connectorCode = rmiInterface.getConnectorCode();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiInterface::getRmiName, (Object)rmiName)).eq(RmiInterface::getConnectorCode, (Object)connectorCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiInterface::getAppId, (Object)appId);
        if (HussarUtils.isNotEmpty((Object)id)) {
            wrapper.ne(RmiInterface::getRmiId, (Object)id);
        }
        HussarException.throwBy(((count = this.count((Wrapper)wrapper)) > 0L ? 1 : 0) != 0, (String)String.format(LocaleMessageUtils.getMessage((String)"INTERFACE_NAME_EXIST"), rmiName));
    }

    @Override
    public RmiInterface getByConnectorCodeAndRmiCode(String connectorCode, String rmiCode, Long appId) {
        RmiInterface rmiInterface = new RmiInterface();
        if (HussarUtils.isEmpty((Object)connectorCode) || HussarUtils.isEmpty((Object)rmiCode)) {
            return rmiInterface;
        }
        rmiInterface = (RmiInterface)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiInterface::getConnectorCode, (Object)connectorCode)).eq(RmiInterface::getRmiCode, (Object)rmiCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiInterface::getAppId, (Object)appId));
        return rmiInterface;
    }

    @Override
    public boolean addAuthInterfaceByAuthCode(RmiConnector rmiConnector) {
        String connectorCode = rmiConnector.getConnectorCode();
        String authCode = rmiConnector.getAuthCode();
        if (HussarUtils.isEmpty((Object)connectorCode) || HussarUtils.isEmpty((Object)authCode)) {
            return Boolean.FALSE;
        }
        List<AuthInterface> authInterfaces = this.authInterfaceService.getAuthInterfaces(authCode);
        if (HussarUtils.isEmpty(authInterfaces)) {
            return Boolean.FALSE;
        }
        ArrayList interfaces = new ArrayList();
        Long appId = rmiConnector.getAppId();
        authInterfaces.forEach(authInterface -> interfaces.add(this.parseAuthInterfaceToRmi((AuthInterface)((Object)authInterface), connectorCode, appId)));
        this.saveBatch(interfaces);
        return Boolean.TRUE;
    }

    private RmiInterface parseAuthInterfaceToRmi(AuthInterface authInterface, String connectorCode, Long appId) {
        RmiInterface rmiInterface = new RmiInterface();
        rmiInterface.setConnectorCode(connectorCode);
        rmiInterface.setRmiName(authInterface.getAuthRmiName());
        rmiInterface.setRmiCode(this.getAuthRmiCode(connectorCode, authInterface.getAuthRmiCode()));
        rmiInterface.setRmiUri(authInterface.getAuthRmiUri());
        rmiInterface.setRmiClassify(authInterface.getAuthRmiType());
        rmiInterface.setRmiClass(authInterface.getAuthClass());
        rmiInterface.setRmiMethod(authInterface.getAuthMethod());
        rmiInterface.setRmiStatus(RmiStatusEnum.NOT_USE.getValue());
        rmiInterface.setRequestType(authInterface.getRequestType());
        rmiInterface.setContentType(authInterface.getContentType());
        rmiInterface.setIsAuth("1");
        rmiInterface.setRemark(authInterface.getRemark());
        rmiInterface.setAppId(appId);
        rmiInterface.setHttpConfig(authInterface.getHttpConfig());
        return rmiInterface;
    }

    private String getAuthRmiCode(String connectorCode, String authRmiCode) {
        return connectorCode + "_" + authRmiCode;
    }
}

