/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.support.solidorg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.model.GhDataDto;
import com.jxdinfo.hussar.support.engine.api.model.GhDataInOutDto;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.service.impl.AbstractGainDataGhService;
import com.jxdinfo.hussar.support.engine.core.annotations.SolidService;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.plugin.pub.service.PubVarService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiConnectorService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiInterfaceService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.HttpBodyEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.ParamScope;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiStatusEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.params.RmiInvokeParamsDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.params.RmiParamsDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.solidorg.RmiGainDataGhService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiConnector;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;

@SolidService(value="com.jxdinfo.hussar.support.engine.plugin.rmi.support.solidorg.RmiGainDataGhServiceImpl", type=NodeTypeEnum.API, des="api\u5e95\u5c42\u8c03\u7528\u4ee5\u53ca\u62fc\u88c5\u53c2\u6570\u56fa\u5316\u903b\u8f91")
public class RmiGainDataGhServiceImpl
extends AbstractGainDataGhService
implements RmiGainDataGhService {
    @Autowired
    private RmiInterfaceService rmiInterfaceService;
    @Autowired
    private RmiConnectorService rmiConnectorService;
    @Autowired
    private PubVarService pubVarService;

    public GhDataDto getGhDataDto(NodeBusinessVo nodeBusinessVo, Map<String, Object> params) {
        GhDataDto ghDataDto = new GhDataDto();
        RmiInterface rmiInterface = new RmiInterface();
        rmiInterface.setRmiCode(nodeBusinessVo.getDataServiceCode());
        RmiInterface resultRmiInterface = (RmiInterface)this.rmiInterfaceService.getOne((Wrapper)new QueryWrapper((Object)rmiInterface));
        ghDataDto.setClassName(resultRmiInterface.getRmiClass());
        ghDataDto.setMethodName(resultRmiInterface.getRmiMethod());
        return ghDataDto;
    }

    public Object[] getParam(String methodName, List<GhDataInOutDto> inList, Object ... arg) {
        Object[] objects = new Object[1];
        HussarException.throwBy((arg.length < 2 || !(arg[1] instanceof NodeBusinessVo) ? 1 : 0) != 0, (Integer)EngineExceptionEnum.PARAM_FAIL.getExceptionCode(), (String)EngineExceptionEnum.PARAM_FAIL.getMessage());
        NodeBusinessVo nodeBusinessVo = (NodeBusinessVo)arg[1];
        Map params = (Map)arg[0];
        Long connectorId = nodeBusinessVo.getModelId();
        String apiCode = nodeBusinessVo.getDataServiceCode();
        objects[0] = this.handleParams(params, connectorId, apiCode);
        return objects;
    }

    @Override
    public Object handleParams(Map<String, Object> params, Long connectorId, String rmiCode) {
        return this.handleParams(params, connectorId, rmiCode, true);
    }

    @Override
    public Object handleParams(Map<String, Object> params, Long connectorId, String rmiCode, boolean format) {
        RmiConnector apiConnector = (RmiConnector)this.rmiConnectorService.getById(connectorId);
        HussarException.throwByNull((Object)apiConnector, (Integer)RmiExceptionEnum.CONNECTOR_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.CONNECTOR_EMPTY.getMessage());
        HussarException.throwBy((!apiConnector.getConnectorStatus().equals(RmiStatusEnum.IN_USE.getValue()) ? 1 : 0) != 0, (Integer)RmiExceptionEnum.API_CONNECTOR_NOTUSE.getExceptionCode(), (String)RmiExceptionEnum.API_CONNECTOR_NOTUSE.getMessage());
        String connectorCode = apiConnector.getConnectorCode();
        Long appId = apiConnector.getAppId();
        RmiInterface rmiInterface = this.rmiInterfaceService.getByConnectorCodeAndRmiCode(connectorCode, rmiCode, appId);
        HussarException.throwByNull((Object)rmiInterface, (Integer)RmiExceptionEnum.API_INTERFACE_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.API_INTERFACE_EMPTY.getMessage());
        HussarException.throwBy((!rmiInterface.getRmiStatus().equals(RmiStatusEnum.IN_USE.getValue()) ? 1 : 0) != 0, (Integer)RmiExceptionEnum.API_RMI_NOTUSE.getExceptionCode(), (String)RmiExceptionEnum.API_RMI_NOTUSE.getMessage());
        return this.handleRmiParams(rmiInterface, apiConnector, params, format);
    }

    public RmiParamsDto handleRmiParams(RmiInterface rmiInterface, RmiConnector apiConnector, Map<String, Object> params, boolean format) {
        RmiParamsDto rmiParams = new RmiParamsDto();
        rmiParams.setApiConnector(apiConnector);
        rmiParams.setHost(apiConnector.getHostUrl());
        rmiParams.setScheme(apiConnector.getProtocol());
        String rmiUri = rmiInterface.getRmiUri();
        Long connectorId = apiConnector.getConnectorId();
        rmiParams.setPath(this.replaceExpress(rmiUri, connectorId, params));
        rmiParams.setVerfy(rmiInterface.getIsAuth());
        rmiParams.setMethodName(rmiInterface.getRequestType());
        rmiParams.setAuthCode(apiConnector.getAuthCode());
        String httpConfig = rmiInterface.getHttpConfig();
        String contentType = rmiInterface.getContentType();
        rmiParams.setContentType(contentType);
        if (HussarUtils.isNotEmpty((Object)httpConfig)) {
            JSONObject httpObject = JSONObject.parseObject((String)httpConfig);
            Map querys = (Map)httpObject.getObject(ParamScope.QUERY.getScope(), Map.class);
            Map headers = (Map)httpObject.getObject(ParamScope.HEADER.getScope(), Map.class);
            Map bodys = (Map)httpObject.getObject(ParamScope.BODY.getScope(), Map.class);
            rmiParams.setHeaderMap(this.objToMap(apiConnector, headers, params, rmiParams));
            rmiParams.setQueryMap(this.objToMap(apiConnector, querys, params, rmiParams));
            if (HttpBodyEnum.JSON.getType().equals(contentType)) {
                rmiParams.setBodyObj(this.handleJsonBody(apiConnector, bodys, params, rmiParams));
            } else {
                rmiParams.setBodyObj(this.objToMap(apiConnector, bodys, params, rmiParams));
            }
        }
        rmiParams.setOutParamsSchema(rmiInterface.getOutParams());
        rmiParams.setFormat(format);
        return rmiParams;
    }

    private Map<String, Object> objToMap(RmiConnector apiConnector, Map<String, Object> listParams, Map<String, Object> params, RmiParamsDto rmiParams) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Long connectorId = apiConnector.getConnectorId();
        if (HussarUtils.isEmpty(listParams)) {
            return returnMap;
        }
        listParams.keySet().forEach(paramKey -> {
            if (HussarUtils.isNotEmpty((Object)paramKey)) {
                Object paramValue = listParams.get(paramKey);
                String paramString = paramValue.toString();
                if ("${global.connector.auth.accessToken}".equals(paramString)) {
                    rmiParams.setTokenKey((String)paramKey);
                }
                paramValue = this.getValueByExpress(paramString, params, connectorId);
                returnMap.put((String)paramKey, paramValue);
            }
        });
        return returnMap;
    }

    private Object handleJsonBody(RmiConnector rmiConnector, Map<String, Object> bodys, Map<String, Object> params, RmiParamsDto rmiParams) {
        if (HussarUtils.isEmpty(bodys)) {
            return null;
        }
        Object json = bodys.get(HttpBodyEnum.JSON.getType());
        if (HussarUtils.isEmpty((Object)json)) {
            return null;
        }
        String jsonStr = json.toString();
        Long connectorId = rmiConnector.getConnectorId();
        jsonStr = this.replaceExpress(jsonStr, connectorId, params);
        return JSON.parse((String)jsonStr);
    }

    private String replaceExpress(String jsonStr, Long connectorId, Map<String, Object> params) {
        HashMap<String, String> matcherParams = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("\\$\\{(.+?)}");
        Matcher matcher = pattern.matcher(jsonStr);
        while (matcher.find()) {
            String valueItem = matcher.group();
            matcherParams.put(valueItem, JSONObject.toJSONString((Object)this.getValueByExpress(valueItem, params, connectorId)));
        }
        return this.replaceConfigValue(matcherParams, jsonStr);
    }

    private String replaceConfigValue(Map<String, String> matcherParams, String configValue) {
        for (String key : matcherParams.keySet()) {
            String value = matcherParams.get(key);
            configValue = configValue.replace(key, value);
        }
        return configValue;
    }

    public RmiParamsDto handleRmiParamsFromDesign(RmiInvokeParamsDto rmiInvokeParamsDto, RmiConnector apiConnector) {
        RmiParamsDto rmiParams = new RmiParamsDto();
        rmiParams.setApiConnector(apiConnector);
        rmiParams.setHost(apiConnector.getHostUrl());
        rmiParams.setScheme(apiConnector.getProtocol());
        rmiParams.setPath(rmiInvokeParamsDto.getUri());
        rmiParams.setVerfy(apiConnector.getIsAuth());
        rmiParams.setMethodName(rmiInvokeParamsDto.getRequestType());
        rmiParams.setAuthCode(apiConnector.getAuthCode());
        rmiParams.setHeaderMap((Map)this.handleMap(apiConnector, rmiInvokeParamsDto.getHeader(), rmiParams));
        rmiParams.setQueryMap((Map)this.handleMap(apiConnector, rmiInvokeParamsDto.getQuery(), rmiParams));
        rmiParams.setBodyObj(rmiInvokeParamsDto.getBody());
        rmiParams.setContentType(rmiInvokeParamsDto.getContentType());
        return rmiParams;
    }

    private Object handleMap(RmiConnector apiConnector, Object inParams, RmiParamsDto rmiParamsDto) {
        HashMap returnMap = new HashMap();
        if (inParams instanceof Map) {
            Map itemMap = (Map)inParams;
            for (Map.Entry entry : itemMap.entrySet()) {
                if ("${global.connector.auth.accessToken}".equals(entry.getValue())) {
                    rmiParamsDto.setTokenKey((String)entry.getKey());
                }
                Object paramValue = this.pubVarService.getPublicValue(apiConnector.getConnectorId(), String.valueOf(entry.getValue()));
                returnMap.put(entry.getKey(), paramValue);
            }
        } else {
            return inParams;
        }
        return returnMap;
    }

    private Object getValueByExpress(String express, Map<String, Object> params, Long connectorId) {
        Object paramValue;
        if (express.matches("\\$\\{param.(.+?)}")) {
            String key = express.replaceAll("\\$\\{param.(.+?)}", "$1");
            paramValue = params.get(key);
        } else {
            paramValue = this.pubVarService.getPublicValue(connectorId, express);
        }
        return paramValue;
    }
}

