/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.sdk.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.rmi.sdk.dto.RmiRequestDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.sdk.enums.RequestTypeEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.core.RmiApi;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequest;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequestType;
import com.jxdinfo.hussar.support.rmi.plugin.spring.file.SpringMultipartFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

public class RmiUtil {
    public static RmiApiRequest getRequest(RmiRequestDto requestDto) {
        RmiApiRequest request = RmiApi.request();
        String schema = requestDto.getSchema();
        if (HussarUtils.isEmpty((Object)schema)) {
            request.setScheme("http");
        } else {
            request.setScheme(schema);
        }
        String host = requestDto.getHost();
        if (HussarUtils.isEmpty((Object)host)) {
            throw new HussarException("host is not empty");
        }
        request.setHost(host);
        int port = requestDto.getPort();
        if (HussarUtils.isEmpty((Object)port)) {
            throw new HussarException("port is not empty");
        }
        request.setPort(port);
        String uri = requestDto.getUri();
        if (HussarUtils.isEmpty((Object)uri)) {
            throw new HussarException("uri is not empty");
        }
        request.setPath(uri);
        RequestTypeEnum typeEnum = requestDto.getRequestType();
        if (HussarUtils.isEmpty((Object)((Object)typeEnum))) {
            typeEnum = RequestTypeEnum.GET;
        }
        request.setType(RmiApiRequestType.findType((String)typeEnum.getType()));
        String contentType = requestDto.getContentType();
        if (HussarUtils.isNotEmpty((Object)contentType)) {
            request.setContentType(contentType);
            if (HussarUtils.equals((Object)"multipart/form-data", (Object)contentType)) {
                MultiValueMap<String, MultipartFile> multiFileMap = requestDto.getMultiFileMap();
                ArrayList rmiApiMultiparts = new ArrayList();
                for (Map.Entry entry : multiFileMap.entrySet()) {
                    if (!HussarUtils.isNotEmpty(entry.getValue())) continue;
                    ((List)entry.getValue()).forEach(m -> {
                        SpringMultipartFile rmiApiMultipart = new SpringMultipartFile();
                        rmiApiMultipart.setFileName(m.getOriginalFilename());
                        rmiApiMultipart.setName((String)entry.getKey());
                        rmiApiMultipart.setContentType(m.getContentType());
                        rmiApiMultipart.setData(m);
                        rmiApiMultiparts.add(rmiApiMultipart);
                    });
                }
                request.setMultiparts(rmiApiMultiparts);
            }
        }
        if (HussarUtils.isNotEmpty((Object)requestDto.getRetryCount())) {
            request.setMaxRetryCount(requestDto.getRetryCount().intValue());
        }
        if (HussarUtils.isNotEmpty((Object)requestDto.getRetryInterval())) {
            request.setMaxRetryInterval(requestDto.getRetryInterval().longValue());
        }
        request.addHeader(requestDto.getHeader());
        request.addBody(requestDto.getBody());
        request.addQuery(requestDto.getQuery());
        request.setSuccessWhen(requestDto.getSuccessWhen());
        request.setOnSuccess(requestDto.getOnSuccess());
        request.setOnError(requestDto.getOnError());
        return request;
    }
}

