/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.pub.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.pub.dao.PubVarMapper;
import com.jxdinfo.hussar.support.engine.plugin.pub.entity.PubVar;
import com.jxdinfo.hussar.support.engine.plugin.pub.enums.AuthTokenEnum;
import com.jxdinfo.hussar.support.engine.plugin.pub.enums.BuiltInEnum;
import com.jxdinfo.hussar.support.engine.plugin.pub.enums.PubVarTypeEnum;
import com.jxdinfo.hussar.support.engine.plugin.pub.model.AuthTokenInfo;
import com.jxdinfo.hussar.support.engine.plugin.pub.service.PubVarService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class PubVarServiceImpl
extends HussarServiceImpl<PubVarMapper, PubVar>
implements PubVarService {
    private final String CONNECTOR_AUTH_PERFIX = PubVarTypeEnum.CONNECTOR.getExpress() + AuthTokenEnum.AUTH_INFO_KEY.getKey();
    @Autowired
    private CacheManager hussarCacheManager;
    @Autowired(required=false)
    private GetLoginUserService getLoginUserService;

    @Override
    public Object getGlobalValue(String key) {
        if (HussarUtils.isEmpty((Object)this.getLoginUserService)) {
            return null;
        }
        UserDetails userDetails = this.getLoginUserService.getCurrentUserDetail();
        if (HussarUtils.isEmpty((Object)userDetails)) {
            return null;
        }
        Map userMap = BeanUtil.beanToMap((Object)userDetails);
        Object value = userMap.get(key);
        if (HussarUtils.isNotEmpty(value)) {
            return value;
        }
        Map extendUserMap = userDetails.getExtendUserMap();
        if (HussarUtils.isEmpty((Object)extendUserMap)) {
            return null;
        }
        return extendUserMap.get(key);
    }

    @Override
    public Object getConnectorValue(Long connectorId, String key) {
        return this.getValue(connectorId, PubVarTypeEnum.CONNECTOR, key);
    }

    @Override
    public Object getChainValue(Long chainId, String key) {
        return this.getValue(chainId, PubVarTypeEnum.CHAIN, key);
    }

    @Override
    public Object getConnectorAuthValue(Long connectorId, String key) {
        AuthTokenInfo authTokenInfo = this.getAuthTokenInfo(connectorId);
        if (HussarUtils.isEmpty((Object)authTokenInfo) || HussarUtils.isEmpty((Object)key)) {
            return null;
        }
        String AUTH_KEY_MATCH = AuthTokenEnum.AUTH_INFO_KEY.getKey() + ".(.+?)";
        if (!key.matches(AUTH_KEY_MATCH)) {
            key = AuthTokenEnum.AUTH_INFO_KEY.getKey() + "." + key;
        }
        if (AuthTokenEnum.ACCESS_TOKEN.getKey().equals(key)) {
            return authTokenInfo.getAccessToken();
        }
        if (AuthTokenEnum.REFRESH_TOKEN.getKey().equals(key)) {
            return authTokenInfo.getRefreshToken();
        }
        return null;
    }

    @Override
    public Object getPublicValue(Long belongId, String express) {
        if (HussarUtils.isEmpty((Object)express) || !express.matches("\\$\\{(.+?)}")) {
            return express;
        }
        express = express.replaceAll("\\$\\{(.+?)}", "$1");
        int lastDot = express.lastIndexOf(".");
        String cacheName = express.substring(0, lastDot);
        String key = express.substring(lastDot + 1);
        if (PubVarTypeEnum.CONNECTOR.getCacheName().equals(cacheName)) {
            return this.getConnectorValue(belongId, key);
        }
        if (PubVarTypeEnum.CHAIN.getCacheName().equals(cacheName)) {
            return this.getChainValue(belongId, key);
        }
        if (PubVarTypeEnum.GLOBAL.getCacheName().equals(cacheName)) {
            return this.getGlobalValue(key);
        }
        if (this.CONNECTOR_AUTH_PERFIX.equals(cacheName)) {
            return this.getConnectorAuthValue(belongId, key);
        }
        return null;
    }

    @Override
    public Long savePubVar(PubVar pubVar) {
        String cacheName;
        Map<String, Object> varMap;
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)((Object)pubVar)), (String)"\u4fdd\u5b58\u7684\u516c\u5171\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        String type = pubVar.getBelongType();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)type), (String)"\u516c\u5171\u53d8\u91cf\u6240\u5c5e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Long belongId = pubVar.getBelongId();
        PubVarTypeEnum typeEnum = PubVarTypeEnum.getEnum(type);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)((Object)typeEnum)), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u516c\u5171\u53d8\u91cf\u6240\u5c5e\u7c7b\u578b");
        Long id = pubVar.getPubVarId();
        String pubVarKey = pubVar.getPubVarKey();
        String pubVarValue = pubVar.getPubVarValue();
        String pubVarExpress = typeEnum.getExpress() + pubVarKey;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(PubVar::getBelongId, (Object)belongId)).eq(PubVar::getPubVarExpress, (Object)pubVarExpress);
        if (HussarUtils.isNotEmpty((Object)id)) {
            wrapper.ne(PubVar::getPubVarId, (Object)id);
        }
        PubVar dbPubVar = (PubVar)((Object)this.getOne((Wrapper)wrapper));
        HussarException.throwBy((boolean)HussarUtils.isNotEmpty((Object)((Object)dbPubVar)), (String)"\u516c\u5171\u53d8\u91cfkey\u503c\u5df2\u5b58\u5728");
        pubVar.setPubVarExpress(pubVarExpress);
        pubVar.setIsBuiltIn(BuiltInEnum.NORMAL.getVar());
        boolean flag = this.saveOrUpdate((BaseEntity)pubVar);
        if (flag && HussarUtils.isNotEmpty(varMap = this.getPublicValueMap(cacheName = typeEnum.getCacheName(), String.valueOf(belongId)))) {
            varMap.put(pubVarKey, pubVarValue);
            this.setPublicValueMap(cacheName, String.valueOf(belongId), varMap);
        }
        return pubVar.getPubVarId();
    }

    @Override
    public boolean deletePubVar(Long pubVarId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)pubVarId), (String)"\u516c\u5171\u53d8\u91cfid\u4e0d\u80fd\u4e3a\u7a7a");
        PubVar pubVar = (PubVar)((Object)this.getById(pubVarId));
        if (HussarUtils.isEmpty((Object)((Object)pubVar))) {
            return Boolean.FALSE;
        }
        String type = pubVar.getBelongType();
        Long belongId = pubVar.getBelongId();
        PubVarTypeEnum typeEnum = PubVarTypeEnum.getEnum(type);
        if (HussarUtils.isEmpty((Object)((Object)typeEnum))) {
            return this.removeById(pubVarId);
        }
        String cacheName = typeEnum.getCacheName();
        Map<String, Object> varMap = this.getPublicValueMap(cacheName, String.valueOf(belongId));
        if (HussarUtils.isEmpty(varMap)) {
            return this.removeById(pubVarId);
        }
        varMap.remove(pubVar.getPubVarKey());
        this.setPublicValueMap(cacheName, String.valueOf(belongId), varMap);
        return this.removeById(pubVarId);
    }

    @Override
    public AuthTokenInfo getAuthTokenInfo(Long connectorId) {
        Object authInfo;
        String authInfoKey;
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)connectorId), (String)"\u8fde\u63a5\u5668id\u4e0d\u80fd\u4e3a\u7a7a");
        String cacheName = PubVarTypeEnum.CONNECTOR.getCacheName();
        Map<String, Object> varMap = this.getPublicValueMap(cacheName, String.valueOf(connectorId));
        if (HussarUtils.isEmpty(varMap)) {
            varMap = new HashMap<String, Object>();
        }
        if (varMap.containsKey(authInfoKey = AuthTokenEnum.AUTH_INFO_KEY.getKey()) && (authInfo = varMap.get(authInfoKey)) instanceof AuthTokenInfo) {
            return (AuthTokenInfo)authInfo;
        }
        String tokenKey = AuthTokenEnum.ACCESS_TOKEN.getKey();
        String refreshKey = AuthTokenEnum.REFRESH_TOKEN.getKey();
        List authList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PubVar::getBelongId, (Object)connectorId)).eq(PubVar::getBelongType, (Object)PubVarTypeEnum.CONNECTOR.getType())).in(PubVar::getPubVarKey, Arrays.asList(tokenKey, refreshKey)));
        if (HussarUtils.isEmpty((Object)authList)) {
            return null;
        }
        AuthTokenInfo authTokenInfo = new AuthTokenInfo(connectorId);
        authList.forEach(pubVar -> {
            if (tokenKey.equals(pubVar.getPubVarKey())) {
                authTokenInfo.setAccessToken(pubVar.getPubVarValue());
                authTokenInfo.setExpireTime(pubVar.getExpireTime());
            } else {
                authTokenInfo.setRefreshToken(pubVar.getPubVarValue());
                authTokenInfo.setRefreshExpireTime(pubVar.getExpireTime());
            }
        });
        varMap.put(authInfoKey, authTokenInfo);
        this.setPublicValueMap(cacheName, String.valueOf(connectorId), varMap);
        return authTokenInfo;
    }

    @Override
    @DSTransactional
    public void setAuthTokenInfo(AuthTokenInfo authTokenInfo) {
        if (HussarUtils.isEmpty((Object)authTokenInfo)) {
            return;
        }
        Long connectorId = authTokenInfo.getConnectorId();
        if (HussarUtils.isEmpty((Object)connectorId)) {
            return;
        }
        PubVar accessToken = this.getAccessToken(authTokenInfo);
        ((PubVarMapper)this.baseMapper).updateAuthTokenInfo(accessToken);
        PubVar refreshToken = this.getRefreshToken(authTokenInfo);
        ((PubVarMapper)this.baseMapper).updateAuthTokenInfo(refreshToken);
        String cacheName = PubVarTypeEnum.CONNECTOR.getCacheName();
        Map<String, Object> varMap = this.getPublicValueMap(cacheName, String.valueOf(connectorId));
        if (HussarUtils.isNotEmpty(varMap)) {
            varMap.put(AuthTokenEnum.AUTH_INFO_KEY.getKey(), authTokenInfo);
            this.setPublicValueMap(cacheName, String.valueOf(connectorId), varMap);
        }
    }

    @Override
    public boolean initAuthTokenInfo(Long connectorId) {
        if (HussarUtils.isEmpty((Object)connectorId)) {
            return false;
        }
        AuthTokenInfo authTokenInfo = new AuthTokenInfo(connectorId);
        ArrayList<PubVar> pubVarList = new ArrayList<PubVar>();
        pubVarList.add(this.getAccessToken(authTokenInfo));
        pubVarList.add(this.getRefreshToken(authTokenInfo));
        return this.saveBatch(pubVarList);
    }

    @Override
    public Map<String, List<PubVar>> getListByType(PubVar pubVar) {
        List pubVars;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Long appId = pubVar.getAppId();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.and(j -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)j.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(PubVar::getBelongId, (Object)pubVar.getBelongId())).eq(PubVar::getBelongType, (Object)pubVar.getBelongType())).eq(HussarUtils.isNotEmpty((Object)appId), PubVar::getAppId, (Object)appId);
            })).or(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.eq(PubVar::getBelongType, (Object)PubVarTypeEnum.GLOBAL.getType());
            });
        })).orderByAsc(PubVar::getIsBuiltIn)).orderByAsc(HussarBaseEntity::getCreateTime);
        String pubVarName = pubVar.getPubVarName();
        if (HussarUtils.isNotEmpty((Object)pubVarName)) {
            wrapper.like(PubVar::getPubVarName, (Object)pubVarName);
        }
        if (HussarUtils.isEmpty((Object)(pubVars = this.list((Wrapper)wrapper)))) {
            return new HashMap<String, List<PubVar>>();
        }
        return pubVars.stream().collect(Collectors.groupingBy(PubVar::getBelongType));
    }

    @Override
    @DSTransactional
    public boolean resetAuthTokenInfo(Long connectorId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)connectorId), (String)"\u8fde\u63a5\u5668id\u4e0d\u80fd\u4e3a\u7a7a");
        AuthTokenInfo authTokenInfo = new AuthTokenInfo(connectorId);
        PubVar accessToken = this.getAccessToken(authTokenInfo);
        PubVar refreshToken = this.getRefreshToken(authTokenInfo);
        ((PubVarMapper)this.baseMapper).updateAuthTokenInfo(refreshToken);
        ((PubVarMapper)this.baseMapper).updateAuthTokenInfo(accessToken);
        String cacheName = PubVarTypeEnum.CONNECTOR.getCacheName();
        this.hussarCacheManager.getCache(cacheName).evict((Object)String.valueOf(connectorId));
        return Boolean.TRUE;
    }

    private PubVar getAccessToken(AuthTokenInfo authTokenInfo) {
        String express = PubVarTypeEnum.CONNECTOR.getExpress();
        PubVar accessToken = new PubVar();
        String tokenKey = AuthTokenEnum.ACCESS_TOKEN.getKey();
        accessToken.setBelongId(authTokenInfo.getConnectorId());
        accessToken.setBelongType(PubVarTypeEnum.CONNECTOR.getType());
        accessToken.setIsBuiltIn(BuiltInEnum.BUILT_IN.getVar());
        accessToken.setPubVarKey(AuthTokenEnum.ACCESS_TOKEN.getKey());
        accessToken.setPubVarName(AuthTokenEnum.ACCESS_TOKEN.getDec());
        accessToken.setPubVarValue(authTokenInfo.getAccessToken());
        accessToken.setExpireTime(authTokenInfo.getExpireTime());
        accessToken.setPubVarExpress(express + tokenKey);
        return accessToken;
    }

    private PubVar getRefreshToken(AuthTokenInfo authTokenInfo) {
        PubVar refreshToken = new PubVar();
        String express = PubVarTypeEnum.CONNECTOR.getExpress();
        String refreshKey = AuthTokenEnum.REFRESH_TOKEN.getKey();
        refreshToken.setBelongId(authTokenInfo.getConnectorId());
        refreshToken.setBelongType(PubVarTypeEnum.CONNECTOR.getType());
        refreshToken.setIsBuiltIn(BuiltInEnum.BUILT_IN.getVar());
        refreshToken.setPubVarKey(AuthTokenEnum.REFRESH_TOKEN.getKey());
        refreshToken.setPubVarName(AuthTokenEnum.REFRESH_TOKEN.getDec());
        refreshToken.setPubVarValue(authTokenInfo.getRefreshToken());
        refreshToken.setExpireTime(authTokenInfo.getRefreshExpireTime());
        refreshToken.setPubVarExpress(express + refreshKey);
        return refreshToken;
    }

    private Object getValue(Long belongId, PubVarTypeEnum typeEnum, String key) {
        if (HussarUtils.isEmpty((Object)belongId) || HussarUtils.isEmpty((Object)key)) {
            return null;
        }
        Map<String, Object> publicValueMap = this.getPublicValueMap(typeEnum.getCacheName(), String.valueOf(belongId));
        if (HussarUtils.isNotEmpty(publicValueMap) && publicValueMap.containsKey(key)) {
            return publicValueMap.get(key);
        }
        List vars = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PubVar::getBelongId, (Object)belongId)).eq(PubVar::getBelongType, (Object)typeEnum.getType())).eq(PubVar::getIsBuiltIn, (Object)BuiltInEnum.NORMAL.getVar()));
        if (HussarUtils.isEmpty((Object)vars)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        vars.forEach(pubVar -> map.put(pubVar.getPubVarKey(), pubVar.getPubVarValue()));
        this.setPublicValueMap(typeEnum.getCacheName(), String.valueOf(belongId), map);
        if (!map.containsKey(key)) {
            return null;
        }
        return map.get(key);
    }

    private Map<String, Object> getPublicValueMap(String cacheName, String key) {
        Cache.ValueWrapper valueWrapper = this.hussarCacheManager.getCache(cacheName).get((Object)key);
        if (HussarUtils.isEmpty((Object)valueWrapper) || !(valueWrapper.get() instanceof Map)) {
            return null;
        }
        return (Map)valueWrapper.get();
    }

    private void setPublicValueMap(String cacheName, String key, Map<String, Object> map) {
        this.hussarCacheManager.getCache(cacheName).put((Object)key, map);
    }
}

