/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.gateway.handler;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.plugin.node.gateway.AbstractNodeBusinessGatewayHandler;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class TfModelIdGatewayHandler
extends AbstractNodeBusinessGatewayHandler<Boolean> {
    @Override
    public Boolean support(String nodeName, Map<String, Object> params, NodeBusinessVo nodeBusinessVo) {
        String tfModelId = HussarUtils.isEmpty((Object)params.get("tfModelId")) ? this.matchTfModelIdByNodeName(nodeName) : HussarUtils.toStr((Object)params.get("tfModelId"));
        params.putIfAbsent("tfModelId", tfModelId);
        return HussarUtils.isNotEmpty((Object)tfModelId);
    }

    private String matchTfModelIdByNodeName(String nodeName) {
        String newBusinessId = nodeName.substring(nodeName.indexOf(".") + 1);
        String regex = Pattern.quote(".") + "(.*?)" + Pattern.quote(".");
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(newBusinessId);
        if (matcher.find()) {
            if (this.processQueryList.stream().anyMatch(nodeName::endsWith)) {
                return "process_task_info_" + matcher.group(1);
            }
            return matcher.group(1);
        }
        return null;
    }

    public int getOrder() {
        return 0;
    }
}

