/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.gateway.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessPmDto;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.enums.NodeOperationEnum;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.api.service.EngineLoadApiConditionService;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.plugin.node.gateway.AbstractNodeBusinessGatewayHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class RenderDynamicApiGatewayHandler
extends AbstractNodeBusinessGatewayHandler<Boolean> {
    private final EngineLoadApiConditionService loadApiConditionService;

    public RenderDynamicApiGatewayHandler(EngineLoadApiConditionService loadApiConditionService) {
        this.loadApiConditionService = loadApiConditionService;
    }

    @Override
    public Boolean support(String nodeName, Map<String, Object> params, NodeBusinessVo nodeBusinessVo) {
        return true;
    }

    @Override
    public void execute(String nodeName, Map<String, Object> params, NodeBusinessVo nodeBusinessVo) {
        this.handleNodeBusiness(nodeBusinessVo, params);
    }

    private void handleNodeBusiness(NodeBusinessVo nodeBusinessVo, Map<String, Object> params) {
        ModelTableMappingDTO modelMappingDto = (ModelTableMappingDTO)params.get("modelTableMapping");
        JSONObject dto = JSON.parseObject((String)nodeBusinessVo.getJsonParams());
        ArrayList<NodeBusinessPm> pmList = this.loadApiConditionService.loadApiParameters(nodeBusinessVo.getNodeName(), modelMappingDto.getTfModelId());
        if (HussarUtils.isEmpty((Object)pmList)) {
            NodeBusinessPmDto pmDto;
            pmList = new ArrayList<NodeBusinessPm>();
            NodeBusinessPmDto nodeBusinessPmDto = pmDto = HussarUtils.isNotEmpty((Object)dto.get((Object)"pmList")) ? this.getPmListByJson(dto.get((Object)"pmList")).get(0) : null;
            if (HussarUtils.isNotEmpty(pmDto)) {
                this.getPmListByPmTemplate(pmDto, pmList, nodeBusinessVo, modelMappingDto);
            }
        }
        nodeBusinessVo.setModelId(modelMappingDto.getRelatedId());
        nodeBusinessVo.setNodeClass(modelMappingDto.getTableName());
        nodeBusinessVo.setResultTiled(params.containsKey("resultTiled"));
        dto.put("pmList", pmList);
        ArrayList<Object> whereList = new ArrayList<Object>();
        ArrayList<Object> sortList = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty((Object)dto.get((Object)"whereList"))) {
            whereList.addAll(this.getPmListByJson(dto.get((Object)"whereList")));
            whereList.forEach(where -> where.setColumnId(modelMappingDto.getColumnByPurposeFromAllColumn(where.getPurpose()).getColumnId()));
        }
        if (HussarUtils.isNotEmpty((Object)dto.get((Object)"sortVOList"))) {
            sortList.addAll(this.getPmListByJson(dto.get((Object)"sortVOList")));
            sortList.forEach(sort -> sort.setColumnId(modelMappingDto.getColumnByPurposeFromAllColumn(sort.getPurpose()).getColumnId()));
        }
        List whereAndSortList = this.loadApiConditionService.loadApiConditions(nodeBusinessVo.getNodeName(), modelMappingDto.getTfModelId());
        for (NodeBusinessPm pm : whereAndSortList) {
            if (HussarUtils.equals((Object)ParameterType.where, (Object)pm.getParameterType())) {
                whereList.add(pm);
                continue;
            }
            if (!HussarUtils.equals((Object)ParameterType.order, (Object)pm.getParameterType())) continue;
            sortList.add(pm);
        }
        dto.put("whereList", whereList);
        dto.put("sortVOList", sortList);
        nodeBusinessVo.setJsonParams(JSONObject.toJSONString((Object)dto));
    }

    private List<NodeBusinessPmDto> getPmListByJson(Object json) {
        return (List)JSON.parseObject((String)JSON.toJSONString((Object)json), (TypeReference)new TypeReference<List<NodeBusinessPmDto>>(){}, (Feature[])new Feature[0]);
    }

    public int getOrder() {
        return 40000;
    }

    private void getPmListByPmTemplate(NodeBusinessPmDto pmDto, List<NodeBusinessPm> pmList, NodeBusinessVo nodeBusinessVo, ModelTableMappingDTO modelMappingDto) {
        List columnDtos = nodeBusinessVo.getNodeType().contains(NodeTypeEnum.SINGLE.getValue()) ? modelMappingDto.getColumns() : modelMappingDto.getAllColumns();
        if (HussarUtils.equals((Object)PurposeEnum.DEL_FLAG, (Object)pmDto.getPurpose()) && HussarUtils.equals((Object)ParameterType.set, (Object)pmDto.getParameterType())) {
            pmDto.setColumnId(modelMappingDto.getColumnByPurpose(PurposeEnum.DEL_FLAG).getColumnId());
            pmList.add((NodeBusinessPm)pmDto);
        } else if (HussarUtils.equals((Object)ParameterType.fun, (Object)pmDto.getParameterType())) {
            pmList.add((NodeBusinessPm)pmDto);
        } else {
            for (ModelColumnDto columnDto : columnDtos) {
                if (NodeOperationEnum.UPDATE.getValue().equals(nodeBusinessVo.getActionName()) && HussarUtils.isNotEmpty((Object)columnDto.getPrimarys())) continue;
                NodeBusinessPmDto pm = (NodeBusinessPmDto)BeanUtil.copy((Object)pmDto, NodeBusinessPmDto.class);
                pm.setColumnId(columnDto.getColumnId());
                pm.setParameterAlias(columnDto.getColumnAlias());
                pmList.add((NodeBusinessPm)pm);
            }
        }
    }
}

