/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.model.SolidServiceDto;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineIntercepts;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.service.ExecuteSolidService;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.service.GainDataGhService;
import com.jxdinfo.hussar.support.engine.core.annotations.SolidService;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@Service
public class ExecuteSolidServiceImpl
implements ExecuteSolidService {
    private final List<GainDataGhService> gainDataGhService;

    public ExecuteSolidServiceImpl(ObjectProvider<List<GainDataGhService>> gainDataGhServices, ObjectProvider<EngineIntercepts> intercepts) {
        this.gainDataGhService = (List)gainDataGhServices.getIfAvailable();
        if (HussarUtils.isEmpty(this.gainDataGhService)) {
            return;
        }
        EngineIntercepts engineIntercepts = (EngineIntercepts)intercepts.getIfAvailable();
        if (HussarUtils.isEmpty((Object)engineIntercepts)) {
            return;
        }
        for (GainDataGhService service : this.gainDataGhService) {
            service.setHandler(engineIntercepts);
        }
    }

    public Object invokeAndassembleParams(NodeBusinessVo nodeBusinessVo, Map<String, Object> params) {
        String gainDataGhBeanName = nodeBusinessVo.getDataServiceActionName();
        GainDataGhService gainDataGhService = null;
        for (GainDataGhService gainItem : this.gainDataGhService) {
            if (!SpringContextUtil.getTarget((Object)gainItem).getClass().getName().equals(gainDataGhBeanName)) continue;
            gainDataGhService = gainItem;
        }
        HussarException.throwBy((boolean)HussarUtils.isEmpty(gainDataGhService), (Integer)EngineExceptionEnum.CODE_FAIL.getExceptionCode(), (String)EngineExceptionEnum.CODE_FAIL.getMessage());
        return gainDataGhService.startInvoke(nodeBusinessVo, params);
    }

    public List<SolidServiceDto> getAllSolidService() {
        ArrayList<SolidServiceDto> solidServiceList = new ArrayList<SolidServiceDto>();
        for (GainDataGhService itemBean : SpringContextUtil.getBeansByClass(GainDataGhService.class)) {
            Class beanClass = ClassUtils.getUserClass(itemBean.getClass());
            SolidService serviceAnnotation = beanClass.getAnnotation(SolidService.class);
            if (HussarUtils.isNull((Object)serviceAnnotation)) continue;
            SolidServiceDto itemAnnotation = new SolidServiceDto();
            itemAnnotation.setClassName(beanClass.getName());
            itemAnnotation.setBeanName(serviceAnnotation.value());
            itemAnnotation.setType(serviceAnnotation.type().getValue());
            itemAnnotation.setDes(serviceAnnotation.des());
            solidServiceList.add(itemAnnotation);
        }
        return solidServiceList;
    }
}

