/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiNaming;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.choreo.api.service.ApiPmService;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataInvokeService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.engine.plugin.node.exception.NoSuchMethodRuntimeException;
import com.jxdinfo.hussar.support.engine.plugin.node.exception.NoSuchNodeRuntimeException;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.jsonschema.api.service.SchemaService;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class EngineBussnessdataInvokeServiceImpl
implements EngineBussnessdataInvokeService {
    @Autowired
    private NodeBusinessService nodeBusinessService;
    @Autowired
    private ApiNamingService apiNamingService;
    @Autowired
    private ApiPmService apiPmService;
    @Autowired
    private SchemaService schemaService;

    public ApiResponse<Object> invoke(String businessId, Map<String, Object> params) {
        try {
            Object resultObject = this.nodeBusinessService.invoke(this.getNodeName(businessId), params, null);
            return resultObject instanceof ApiResponse ? (ApiResponse)resultObject : ApiResponse.success((Object)resultObject);
        }
        catch (NoSuchNodeRuntimeException e) {
            ApiNaming apiNaming = this.apiNamingService.getApiNaming(businessId);
            if (Optional.ofNullable(apiNaming).map(ApiNaming::getNewVersion).isPresent()) {
                return this.invoke(apiNaming, params);
            }
            throw new NoSuchMethodRuntimeException(StringUtil.format((String)"No such method: [{}]", (Object[])new Object[]{businessId}));
        }
    }

    public ApiResponse<Object> invoke(ApiNaming apiNaming, Map<String, Object> params) {
        Object resultObject = this.nodeBusinessService.invoke(apiNaming.getServiceName(), params, null);
        return resultObject instanceof ApiResponse ? (ApiResponse)resultObject : ApiResponse.success((Object)resultObject);
    }

    private HussarException getHussarException(Throwable cause) {
        if (cause instanceof HussarException) {
            return (HussarException)cause;
        }
        return new HussarException(cause.getMessage(), cause);
    }

    private String getNodeName(String businessId) {
        return businessId.replace(" ", "").replace("/", ".").replace(":", "").replace("-", ".");
    }
}

