/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.constant.ModelTypeRelationHolder;
import com.jxdinfo.hussar.support.choreo.api.dto.ApiNamingDto;
import com.jxdinfo.hussar.support.choreo.api.dto.MsTableDto;
import com.jxdinfo.hussar.support.choreo.api.dto.RmiModelDto;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiNaming;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiPm;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.choreo.api.service.ApiPmService;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.model.DataserviceDto;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.HussarService;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiConnector;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiInterface;
import com.jxdinfo.hussar.support.rmi.api.service.RmiConnectorApiService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EngineBussnessdataConfigServiceImpl
implements EngineBussnessdataConfigService {
    private Map<String, DataserviceDto> dataserviceDtoMap;
    private ConcurrentHashMap<Long, Long> lockMap = new ConcurrentHashMap();
    @Autowired
    private ApiNamingService apiNamingService;
    @Autowired
    private ApiPmService apiPmService;
    @Autowired
    private NodeBusinessService businessService;
    @Autowired
    private DataserviceService dataserviceService;
    @Autowired(required=false)
    private RmiConnectorApiService connectorService;
    @Autowired
    private IEnginePluginModelApp modelRelateService;

    public void saveSingleTableService(SingleTableDto dto, PushBackCtx ctx) {
        this.pushSingleTable(dto, ctx, "engineSingleTable_", NodeTypeEnum.SINGLE);
        ctx.getFirstNodeBusinessDto().setDataServiceActionName(ModelTypeRelationHolder.getInstance().getProviderByType(NodeTypeEnum.SINGLE));
    }

    public void saveMasterSlaveService(MsTableDto dto, PushBackCtx ctx) {
        this.pushMsTable(dto, ctx, "engineMsTable_", NodeTypeEnum.MASTER);
        ctx.getFirstNodeBusinessDto().setDataServiceActionName(ModelTypeRelationHolder.getInstance().getProviderByType(NodeTypeEnum.MASTER));
    }

    public void saveMssService(MsTableDto dto, PushBackCtx ctx) {
        this.pushMsTable(dto, ctx, "engineMssTable_", NodeTypeEnum.MULTI_MASTER);
        ctx.getFirstNodeBusinessDto().setDataServiceActionName(ModelTypeRelationHolder.getInstance().getProviderByType(NodeTypeEnum.MULTI_MASTER));
    }

    public void saveFlowSingleTableService(List<String> flowColumns, SingleTableDto dto, PushBackCtx ctx) {
        this.pushSingleTable(dto, ctx, "singleBpm_", NodeTypeEnum.SINGLEFLOW);
        ctx.getFirstNodeBusinessDto().setDataServiceActionName(ModelTypeRelationHolder.getInstance().getProviderByType(NodeTypeEnum.SINGLEFLOW));
    }

    public void saveFlowMasterSlaveService(List<String> flowColumns, MsTableDto dto, PushBackCtx ctx) {
        this.pushMsTable(dto, ctx, "multiBpm_", NodeTypeEnum.MSFLOW);
        ctx.getFirstNodeBusinessDto().setDataServiceActionName(ModelTypeRelationHolder.getInstance().getProviderByType(NodeTypeEnum.MSFLOW));
    }

    public void saveRmiService(RmiModelDto modelDto, PushBackCtx ctx) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)modelDto), (String)"API\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        ApiNamingDto apiNamingDto = new ApiNamingDto();
        NodeBusiness nodeBusiness = new NodeBusiness();
        ApiPm apiPm = new ApiPm();
        Long connectorId = modelDto.getConnectorId();
        Long appId = modelDto.getAppId();
        Long rmiId = modelDto.getRmiId();
        LambdaQueryChainWrapper connectorLambdaQueryWrapper = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.connectorService.lambdaQuery().eq(RmiConnector::getConnectorId, (Object)connectorId)).eq(HussarUtils.isNotEmpty((Object)appId), RmiConnector::getAppId, (Object)appId);
        RmiConnector rmiConnector = (RmiConnector)connectorLambdaQueryWrapper.one();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)rmiConnector), (String)String.format("API\u8fde\u63a5\u5668\u4e0d\u5b58\u5728,connectorId:%s", connectorId));
        RmiInterface rmiInterface = this.connectorService.getPushInterface(rmiConnector, rmiId);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)rmiInterface), (String)String.format("API\u8fde\u63a5\u5668\u63a5\u53e3\u4e0d\u5b58\u5728,rmiId:%s", rmiId));
        String businessId = modelDto.getBusinessId();
        String inParams = modelDto.getInParams();
        String nodeInParams = rmiInterface.getInParams();
        if (HussarUtils.isEmpty((Object)inParams)) {
            inParams = nodeInParams;
        }
        String dec = modelDto.getMethodDesc();
        String nodeName = businessId.replace(" ", "").replace("/", ".");
        apiNamingDto.setBusinessType(rmiConnector.getProtocol().toUpperCase());
        apiNamingDto.setBusinessId(businessId);
        apiNamingDto.setServiceName(nodeName);
        apiNamingDto.setBusinessName(dec);
        apiPm.setBusinessId(businessId);
        apiPm.setInParams(inParams);
        apiPm.setInMapping(modelDto.getInMapping());
        apiPm.setOutParams(modelDto.getOutParams());
        apiNamingDto.setApiPm(apiPm);
        nodeBusiness.setNodeName(nodeName);
        nodeBusiness.setNodeDec(dec);
        nodeBusiness.setModelId(connectorId);
        nodeBusiness.setDataServiceCode(rmiInterface.getRmiCode());
        nodeBusiness.setDataServiceActionName(ModelTypeRelationHolder.getInstance().getProviderByType(NodeTypeEnum.API));
        nodeBusiness.setInParams(nodeInParams);
        nodeBusiness.setNodeType(NodeTypeEnum.API.getValue());
        ctx.addApiNaming(apiNamingDto);
        ctx.addNodeBusiness(nodeBusiness);
    }

    private void pushSingleTable(SingleTableDto dto, PushBackCtx ctx, String uniqueCodeStart, NodeTypeEnum nodeType) {
        ctx.initApi(dto, nodeType.getValue(), uniqueCodeStart, this.getMapDataServiceDto());
    }

    private void pushMsTable(MsTableDto dto, PushBackCtx ctx, String uniqueCodeStart, NodeTypeEnum nodeType) {
        ctx.initApi((SingleTableDto)dto, nodeType.getValue(), uniqueCodeStart, this.getMapDataServiceDto());
    }

    @DSTransactional
    @HussarTokenDs
    public ApiResponse<Boolean> pushApi(PushBackCtx ctx) {
        List apiNamingDtoList = ctx.getApiNamingList();
        if (HussarUtils.isNotEmpty((Object)apiNamingDtoList)) {
            this.save(ctx.getApiNamingList(), ctx.getBusinessList());
            this.cleanCache();
        }
        return ApiResponse.success((Object)true);
    }

    private void validate(List<NodeBusiness> businessList) {
        if (HussarUtils.isEmpty(businessList)) {
            return;
        }
        List nodeNames = businessList.stream().map(NodeBusiness::getNodeName).distinct().collect(Collectors.toList());
        if (nodeNames.size() != businessList.size()) {
            throw new HussarException(String.format("\u53d1\u5e03\u63a5\u53e3\u540d\u79f0\u51fa\u73b0\u91cd\u590d", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(List<ApiNamingDto> apiNamingDtoList, List<NodeBusiness> businessList) {
        Long lock;
        this.validate(businessList);
        Set<String> businessIds = this.getBusinessIds(apiNamingDtoList);
        Map<String, ApiNaming> apiNamingMap = this.getApiNamingMap(businessIds);
        Map<String, ApiPm> apiPmMap = this.getApiPmMap(businessIds);
        ArrayList<ApiNaming> apiNamingList = new ArrayList<ApiNaming>();
        ArrayList<ApiPm> apiPmList = new ArrayList<ApiPm>();
        ArrayList<Long> delApiPmList = new ArrayList<Long>();
        for (ApiNamingDto dto : apiNamingDtoList) {
            String businessId = dto.getBusinessId();
            ApiNaming apiNaming = (ApiNaming)BeanUtil.copy((Object)dto, ApiNaming.class);
            if (HussarUtils.isEmpty((Object)apiNaming)) continue;
            ApiNaming oldApiNaming = apiNamingMap.get(businessId);
            if (HussarUtils.isNotEmpty((Object)oldApiNaming)) {
                apiNaming.setId(oldApiNaming.getId());
            }
            apiNaming.setTenantId(EngineUtil.getTenantId());
            apiNaming.setNewVersion("1");
            apiNamingList.add(apiNaming);
            ApiPm apiPm = dto.getApiPm();
            ApiPm oldApiPm = apiPmMap.get(businessId);
            if (HussarUtils.isEmpty((Object)apiPm) && HussarUtils.isNotEmpty((Object)oldApiPm)) {
                delApiPmList.add(oldApiPm.getParameterId());
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)apiPm) && HussarUtils.isNotEmpty((Object)oldApiPm)) {
                apiPm.setParameterId(oldApiPm.getParameterId());
            }
            if (!HussarUtils.isNotEmpty((Object)apiPm)) continue;
            apiPmList.add(apiPm);
        }
        Long modelId = businessList.get(0).getModelId();
        if (modelId != null) {
            Long oldLock;
            lock = this.lockMap.get(modelId);
            if (lock == null && (oldLock = this.lockMap.putIfAbsent(modelId, lock = modelId)) != null) {
                lock = oldLock;
            }
        } else {
            lock = EngineUtil.getId();
        }
        Long l = lock;
        synchronized (l) {
            if (HussarUtils.isNotEmpty(apiNamingList)) {
                this.apiNamingService.saveOrUpdateBatch(apiNamingList);
                this.apiPmService.removeByIds(delApiPmList);
                this.apiPmService.saveOrUpdateBatch(apiPmList);
            }
            if (HussarUtils.isNotEmpty(businessList)) {
                this.delOldNode(businessList);
                this.businessService.saveBatch(businessList);
            }
        }
    }

    private Set<String> getBusinessIds(List<ApiNamingDto> apiNamingDtoList) {
        return apiNamingDtoList.stream().map(ApiNaming::getBusinessId).collect(Collectors.toSet());
    }

    private Map<String, ApiNaming> getApiNamingMap(Set<String> businessIds) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)Wrappers.lambdaQuery(ApiNaming.class).in(ApiNaming::getBusinessId, businessIds);
        List apiNamings = this.apiNamingService.list((Wrapper)query);
        return apiNamings.stream().collect(Collectors.toMap(ApiNaming::getBusinessId, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, ApiPm> getApiPmMap(Set<String> businessIds) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)Wrappers.lambdaQuery(ApiPm.class).in(ApiPm::getBusinessId, businessIds);
        List apiPms = this.apiPmService.list((Wrapper)query);
        return apiPms.stream().collect(Collectors.toMap(ApiPm::getBusinessId, Function.identity(), (k1, k2) -> k1));
    }

    private void delOldNode(List<NodeBusiness> nodeList) {
        HashSet<String> nodeNameList = new HashSet<String>();
        if (HussarUtils.isNotEmpty(nodeList)) {
            for (NodeBusiness business : nodeList) {
                nodeNameList.add(business.getNodeName());
            }
            this.businessService.remove((Wrapper)new LambdaQueryWrapper().in(NodeBusiness::getNodeName, nodeNameList));
        }
    }

    private <T extends BaseEntity> void saveBatch(HussarService<T> service, List<T> baseEntities) {
        if (HussarUtils.isEmpty(baseEntities) || service == null) {
            return;
        }
        service.saveBatch(baseEntities, baseEntities.size());
    }

    private <T extends BaseEntity> void deleteBatchIds(HussarService<T> service, List<Long> entityIds) {
        if (HussarUtils.isEmpty(entityIds) || service == null) {
            return;
        }
        service.removeByIds(entityIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DataserviceDto> getMapDataServiceDto() {
        if (this.dataserviceDtoMap == null) {
            EngineBussnessdataConfigServiceImpl engineBussnessdataConfigServiceImpl = this;
            synchronized (engineBussnessdataConfigServiceImpl) {
                if (this.dataserviceDtoMap == null) {
                    this.dataserviceDtoMap = this.dataserviceService.mapDataServiceDto();
                }
            }
        }
        return this.dataserviceDtoMap;
    }

    private void cleanCache() {
    }
}

