/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiNaming;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiPm;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.choreo.api.service.ApiPmService;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataInvokeService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.jsonschema.api.service.SchemaService;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class EngineBussnessdataInvokeServiceImpl
implements EngineBussnessdataInvokeService {
    @Autowired
    private NodeBusinessService nodeBusinessService;
    @Autowired
    private ApiNamingService apiNamingService;
    @Autowired
    private ApiPmService apiPmService;
    @Autowired
    private SchemaService schemaService;

    public ApiResponse<Object> invoke(String businessId, Map<String, Object> params) {
        ApiNaming apiNaming = this.apiNamingService.getApiNaming(businessId);
        if (Optional.ofNullable(apiNaming).map(ApiNaming::getNewVersion).isPresent()) {
            return this.invoke(apiNaming, params);
        }
        return ApiResponse.fail((int)404, (String)"\u8c03\u7528\u65b9\u6cd5\u4e0d\u5b58\u5728");
    }

    public ApiResponse<Object> invoke(ApiNaming apiNaming, Map<String, Object> params) {
        String inMapping;
        String inParams;
        ApiPm apiPm = this.apiPmService.getApiPmByBusinessId(apiNaming.getBusinessId());
        if (HussarUtils.isEmpty((Object)apiPm)) {
            apiPm = new ApiPm();
        }
        if (HussarUtils.isNotEmpty((Object)(inParams = apiPm.getInParams()))) {
            try {
                this.schemaService.validate(inParams, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HussarException(String.format("\u63a5\u53e3\u5165\u53c2\u683c\u5f0f\u5f02\u5e38:%s", e.getMessage()));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(inMapping = apiPm.getInMapping()))) {
            try {
                params = (Map)this.schemaService.generatorData(inMapping, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HussarException(String.format("\u63a5\u53e3\u5165\u53c2\u8f6c\u6362\u5f02\u5e38:%s", e.getMessage()));
            }
        }
        Object resultObject = this.nodeBusinessService.invoke(apiNaming.getServiceName(), params, null);
        String outParams = apiPm.getOutParams();
        if (HussarUtils.isEmpty((Object)outParams)) {
            return resultObject instanceof ApiResponse ? (ApiResponse)resultObject : ApiResponse.success((Object)resultObject);
        }
        try {
            return ApiResponse.success((Object)this.schemaService.generatorData(outParams, resultObject));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException(String.format("\u63a5\u53e3\u51fa\u53c2\u8f6c\u6362\u5f02\u5e38:%s", e.getMessage()));
        }
    }

    private HussarException getHussarException(Throwable cause) {
        if (cause instanceof HussarException) {
            return (HussarException)cause;
        }
        return new HussarException(cause.getMessage(), cause);
    }
}

