/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessDto;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessInoutVo;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.enums.InoutType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessInoutService;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.service.ExecuteSolidService;
import com.jxdinfo.hussar.support.engine.plugin.node.dao.NodeBusinessMapper;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.jsonschema.api.service.SchemaService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeBusinessServiceImpl
extends HussarServiceImpl<NodeBusinessMapper, NodeBusiness>
implements NodeBusinessService {
    @Autowired
    private NodeBusinessInoutService nodeBusinessInoutService;
    @Autowired
    private ExecuteSolidService executeSolidService;
    @Autowired
    private SchemaService schemaService;

    public Object invoke(String nodeName, Map<String, Object> params, Consumer<Object> callBackMethodName) {
        NodeBusinessVo nodeBusinessVo = this.getBusinessVoByNodeName(nodeName);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeBusinessVo), (String)String.format("\u8282\u70b9\u4fe1\u606f\u672a\u627e\u5230,nodeName:%s", nodeName));
        return this.invoke(nodeBusinessVo, params, callBackMethodName);
    }

    public Object invoke(NodeBusinessVo nodeBusinessVo, Map<String, Object> params, Consumer<Object> callBackMethodName) {
        String inParams = nodeBusinessVo.getInParams();
        if (HussarUtils.isNotEmpty((Object)inParams)) {
            try {
                this.schemaService.validate(inParams, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HussarException(String.format("\u8282\u70b9\u53c2\u6570\u6821\u9a8c\u5f02\u5e38:%s", e.getMessage()));
            }
        }
        return this.invokeMethod(nodeBusinessVo, params, callBackMethodName);
    }

    public Map<String, Object> invoke(String nodeName, List<Map<String, Object>> params, Consumer<Object> callBackMethodName) {
        NodeBusinessVo nodeBusinessVo = this.getBusinessVoByNodeName(nodeName);
        Object obj = this.invokeMethod(nodeBusinessVo, params, callBackMethodName);
        NodeBusinessInoutVo nodeBusinessInoutVo = (NodeBusinessInoutVo)nodeBusinessVo.getOuts().get(0);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeBusinessInoutVo), (String)"\u65b9\u6cd5\u51fa\u53c2\u4e3a\u7a7a");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put(nodeBusinessInoutVo.getInoutAlias(), obj);
        return returnMap;
    }

    public List<NodeBusiness> deleteByModelId(Long modelId) {
        List list;
        if (modelId != null && modelId != 0L && HussarUtils.isNotEmpty((Object)(list = this.list((Wrapper)Wrappers.lambdaQuery(NodeBusiness.class).eq(NodeBusiness::getModelId, (Object)modelId))))) {
            this.removeByIds(list.stream().map(NodeBusiness::getNodeId).collect(Collectors.toList()));
            return list;
        }
        return new ArrayList<NodeBusiness>();
    }

    public Map<String, List<String>> getNodeNameByUrl(List<String> urlList) {
        if (HussarUtils.isEmpty(urlList)) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, String> nameUrlMap = new HashMap<String, String>();
        ArrayList<String> newUrlList = new ArrayList<String>();
        for (String s : urlList) {
            String replace = s.replace("/", ".").replace(":", "");
            String postNode = "POST" + replace;
            newUrlList.add(postNode);
            String getNode = "GET" + replace;
            newUrlList.add(getNode);
            nameUrlMap.put(postNode, s);
            nameUrlMap.put(getNode, s);
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (List list : Lists.partition(newUrlList, (int)500)) {
            List resultList = this.list((Wrapper)Wrappers.lambdaQuery(NodeBusiness.class).in(NodeBusiness::getNodeName, (Collection)list)).stream().map(NodeBusiness::getNodeName).collect(Collectors.toList());
            for (String s : resultList) {
                String key = (String)nameUrlMap.get(s);
                if (!HussarUtils.isNotEmpty((Object)key)) continue;
                result.put(key, Collections.singletonList(s));
            }
        }
        return result;
    }

    private Object invokeMethod(NodeBusinessVo nodeBusinessVo, Object params, Consumer<Object> callBackMethodName) {
        return this.executeSolidService.invokeAndassembleParams(nodeBusinessVo, (Map)params);
    }

    @DSTransactional
    public void saveService(NodeBusinessDto nodeBusinessDto) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeBusinessDto), (String)"\u4e1a\u52a1\u670d\u52a1dto\u4e0d\u80fd\u4e3a\u7a7a");
        NodeBusiness nodeBusiness = new NodeBusiness();
        BeanUtil.copy((Object)nodeBusinessDto, (Object)nodeBusiness);
        this.save((BaseEntity)nodeBusiness);
        nodeBusinessDto.setNodeId(nodeBusiness.getNodeId());
        this.nodeBusinessInoutService.saveInouts(nodeBusinessDto);
    }

    @DSTransactional
    public boolean deleteService(Long businessId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)businessId), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        this.nodeBusinessInoutService.deleteInouts(businessId);
        return this.removeById(businessId);
    }

    @DSTransactional
    public void updateService(NodeBusinessDto nodeBusinessDto) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeBusinessDto), (String)"\u4e1a\u52a1\u670d\u52a1dto\u4e0d\u80fd\u4e3a\u7a7a");
        Long businessId = nodeBusinessDto.getNodeId();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)businessId), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        NodeBusiness nodeBusiness = new NodeBusiness();
        BeanUtil.copy((Object)nodeBusinessDto, (Object)nodeBusiness);
        this.updateById((BaseEntity)nodeBusiness);
        this.nodeBusinessInoutService.updateInouts(nodeBusinessDto);
    }

    public NodeBusinessVo getBusinessVo(Long nodeId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeId), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        NodeBusinessVo logicBusinessVo = new NodeBusinessVo();
        NodeBusiness nodeBusiness = (NodeBusiness)this.getById(nodeId);
        BeanUtil.copy((Object)nodeBusiness, (Object)logicBusinessVo);
        if (HussarUtils.isNotEmpty((Object)nodeBusiness) && HussarUtils.isEmpty((Object)nodeBusiness.getJsonParams())) {
            Map map = this.nodeBusinessInoutService.getInoutVoListGroupByType(nodeId);
            logicBusinessVo.setIns((List)map.get(InoutType.IN.getValue()));
            logicBusinessVo.setOuts((List)map.get(InoutType.OUT.getValue()));
        }
        return logicBusinessVo;
    }

    public NodeBusiness getBusinessByNodeName(String nodeName) {
        return (NodeBusiness)this.getOne((Wrapper)Wrappers.lambdaQuery(NodeBusiness.class).eq(NodeBusiness::getNodeName, (Object)nodeName));
    }

    public NodeBusinessVo getBusinessVoByNodeName(String serviceName) {
        return this.getBusinessVoByNodeName(serviceName, null);
    }

    public NodeBusinessVo getBusinessVoByNodeName(String serviceName, Long moudleId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)serviceName), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        NodeBusinessVo logicBusinessVo = new NodeBusinessVo();
        NodeBusiness nodeBusiness = (NodeBusiness)this.getOne((Wrapper)new LambdaQueryWrapper().eq(NodeBusiness::getNodeName, (Object)serviceName));
        BeanUtil.copy((Object)nodeBusiness, (Object)logicBusinessVo);
        if (HussarUtils.isNotEmpty((Object)nodeBusiness) && HussarUtils.isEmpty((Object)nodeBusiness.getJsonParams())) {
            Map map = this.nodeBusinessInoutService.getInoutVoListGroupByType(nodeBusiness.getNodeId());
            logicBusinessVo.setIns((List)map.get(InoutType.IN.getValue()));
            logicBusinessVo.setOuts((List)map.get(InoutType.OUT.getValue()));
        }
        return logicBusinessVo;
    }
}

