/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessDto;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessInoutDto;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessInoutVo;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessInout;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessInoutService;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessPmService;
import com.jxdinfo.hussar.support.engine.plugin.node.dao.NodeBusinessInoutMapper;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeBusinessInoutServiceImpl
extends HussarServiceImpl<NodeBusinessInoutMapper, NodeBusinessInout>
implements NodeBusinessInoutService {
    @Autowired
    private NodeBusinessPmService nodeBusinessPmService;

    @DSTransactional
    public void saveInouts(NodeBusinessDto nodeBusinessDto) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeBusinessDto), (String)"\u4e1a\u52a1\u670d\u52a1dto\u4e0d\u80fd\u4e3a\u7a7a");
        List inoutDtoList = nodeBusinessDto.getInouts();
        if (HussarUtils.isEmpty((Object)inoutDtoList)) {
            return;
        }
        ArrayList<NodeBusinessPm> parameters = new ArrayList<NodeBusinessPm>();
        Long businessId = nodeBusinessDto.getNodeId();
        for (NodeBusinessInoutDto inoutDto : inoutDtoList) {
            NodeBusinessInout inout = new NodeBusinessInout();
            inoutDto.setNodeId(businessId);
            BeanUtil.copy((Object)inoutDto, (Object)inout);
            this.save((BaseEntity)inout);
            inoutDto.setInoutId(inout.getInoutId());
            parameters.addAll(this.getParameters(inoutDto));
        }
        if (HussarUtils.isNotEmpty(parameters)) {
            this.nodeBusinessPmService.saveBatch(parameters);
        }
    }

    @DSTransactional
    public boolean deleteInouts(Long businessId) {
        this.nodeBusinessPmService.remove((Wrapper)new LambdaQueryWrapper().eq(NodeBusinessPm::getNodeId, (Object)businessId));
        return this.remove((Wrapper)new LambdaQueryWrapper().eq(NodeBusinessInout::getNodeId, (Object)businessId));
    }

    @DSTransactional
    public void updateInouts(NodeBusinessDto nodeBusinessDto) {
        Long businessId = nodeBusinessDto.getNodeId();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)businessId), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        this.deleteInouts(businessId);
        this.saveInouts(nodeBusinessDto);
    }

    public Map<String, List<NodeBusinessInoutVo>> getInoutVoListGroupByType(Long businessId) {
        Map<String, List<NodeBusinessInoutVo>> map = new HashMap<String, List<NodeBusinessInoutVo>>();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)businessId), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        List inouts = this.list((Wrapper)new LambdaQueryWrapper().eq(NodeBusinessInout::getNodeId, (Object)businessId));
        if (HussarUtils.isNotEmpty((Object)inouts)) {
            map = this.assembleVoMap(businessId, inouts);
        }
        return map;
    }

    private List<NodeBusinessPm> getParameters(NodeBusinessInoutDto inoutDto) {
        if (HussarUtils.isEmpty((Object)inoutDto)) {
            return new ArrayList<NodeBusinessPm>();
        }
        List pms = inoutDto.getParameters();
        if (HussarUtils.isEmpty((Object)pms)) {
            return new ArrayList<NodeBusinessPm>();
        }
        Long businessId = inoutDto.getNodeId();
        Long inoutId = inoutDto.getInoutId();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)businessId), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)inoutId), (String)"\u51fa\u5165\u53c2id\u4e0d\u80fd\u4e3a\u7a7a");
        pms.forEach(pm -> {
            pm.setNodeId(businessId);
            pm.setInoutId(inoutId);
        });
        return pms;
    }

    private Map<String, List<NodeBusinessInoutVo>> assembleVoMap(Long businessId, List<NodeBusinessInout> inouts) {
        List pms = this.nodeBusinessPmService.list((Wrapper)new LambdaQueryWrapper().eq(NodeBusinessPm::getNodeId, (Object)businessId));
        Map<Long, List<NodeBusinessPm>> pmMap = pms.stream().collect(Collectors.groupingBy(NodeBusinessPm::getInoutId));
        ArrayList<NodeBusinessInoutVo> inoutVos = new ArrayList<NodeBusinessInoutVo>();
        for (NodeBusinessInout inout : inouts) {
            NodeBusinessInoutVo inoutVo = new NodeBusinessInoutVo();
            BeanUtil.copy((Object)inout, (Object)inoutVo);
            List<NodeBusinessPm> pmList = pmMap.get(inout.getInoutId());
            if (HussarUtils.isNotEmpty(pmList)) {
                inoutVo.setParameters(pmList);
            }
            inoutVos.add(inoutVo);
        }
        return inoutVos.stream().collect(Collectors.groupingBy(NodeBusinessInout::getInoutType));
    }
}

