/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.node.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessDto;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessInoutVo;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.enums.InoutType;
import com.jxdinfo.hussar.support.engine.api.model.DataserviceDto;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipDto;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipJoinDto;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessInoutService;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.engine.api.service.RelationshipService;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.plugin.node.dao.NodeBusinessMapper;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeBusinessServiceImpl
extends HussarServiceImpl<NodeBusinessMapper, NodeBusiness>
implements NodeBusinessService {
    @Autowired
    private NodeBusinessInoutService logicBusinessInoutService;
    @Autowired
    private DataserviceService dataserviceService;
    @Autowired
    private HussarMetadataService metadataColumnService;
    @Autowired
    private RelationshipService relationshipService;

    public Object invoke(String nodeName, Map<String, Object> params, Consumer<Object> callBackMethodName) throws Exception {
        NodeBusinessVo nodeBusinessVo = this.getBusinessVoByNodeName(nodeName);
        String ghCode = nodeBusinessVo.getDataServiceCode();
        return this.invokeMethod(ghCode, nodeBusinessVo, params, callBackMethodName);
    }

    public Map<String, Object> invoke(String nodeName, List<Map<String, Object>> params, Consumer<Object> callBackMethodName) throws Exception {
        NodeBusinessVo nodeBusinessVo = this.getBusinessVoByNodeName(nodeName);
        String ghCode = nodeBusinessVo.getDataServiceCode();
        Object obj = this.invokeMethod(ghCode, nodeBusinessVo, params, callBackMethodName);
        NodeBusinessInoutVo nodeBusinessInoutVo = (NodeBusinessInoutVo)nodeBusinessVo.getOuts().get(0);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeBusinessInoutVo), (String)"\u65b9\u6cd5\u51fa\u53c2\u4e3a\u7a7a");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put(nodeBusinessInoutVo.getInoutAlias(), obj);
        return returnMap;
    }

    private Object invokeMethod(String ghCode, NodeBusinessVo nodeBusinessVo, Object params, Consumer<Object> callBackMethodName) throws Exception {
        Method method;
        DataserviceDto dataserviceDto = this.dataserviceService.getDataserviceDto(ghCode);
        String beanName = dataserviceDto.getClassName();
        String methodName = dataserviceDto.getMethodName();
        UnderlyingService ownerBean = (UnderlyingService)SpringContextUtil.getBean((String)beanName);
        Class<?> ownerClass = ownerBean.getClass();
        Object[] invokeParams = ownerBean.getParam(methodName, dataserviceDto.getIns(), new Object[]{params, nodeBusinessVo});
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)ownerBean), (String)"bean\u672a\u627e\u5230");
        try {
            method = ClassUtil.getMethod(ownerClass, (String)methodName, null);
        }
        catch (Exception e) {
            throw new HussarException(String.format("%s.%s\u65b9\u6cd5\u672a\u627e\u5230", ownerClass, ownerBean));
        }
        if (HussarUtils.isNotEmpty(callBackMethodName)) {
            int length = invokeParams.length;
            invokeParams = Arrays.copyOf(invokeParams, length + 1);
            invokeParams[length] = callBackMethodName;
        }
        try {
            return method.invoke((Object)ownerBean, invokeParams);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
    }

    @DSTransactional
    public void saveService(NodeBusinessDto nodeBusinessDto) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeBusinessDto), (String)"\u4e1a\u52a1\u670d\u52a1dto\u4e0d\u80fd\u4e3a\u7a7a");
        NodeBusiness nodeBusiness = new NodeBusiness();
        BeanUtil.copy((Object)nodeBusinessDto, (Object)nodeBusiness);
        this.save((BaseEntity)nodeBusiness);
        nodeBusinessDto.setNodeId(nodeBusiness.getNodeId());
        this.logicBusinessInoutService.saveInouts(nodeBusinessDto);
    }

    @DSTransactional
    public boolean deleteService(Long businessId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)businessId), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        this.logicBusinessInoutService.deleteInouts(businessId);
        return this.removeById(businessId);
    }

    @DSTransactional
    public void updateService(NodeBusinessDto nodeBusinessDto) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeBusinessDto), (String)"\u4e1a\u52a1\u670d\u52a1dto\u4e0d\u80fd\u4e3a\u7a7a");
        Long businessId = nodeBusinessDto.getNodeId();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)businessId), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        NodeBusiness nodeBusiness = new NodeBusiness();
        BeanUtil.copy((Object)nodeBusinessDto, (Object)nodeBusiness);
        this.updateById((BaseEntity)nodeBusiness);
        this.logicBusinessInoutService.updateInouts(nodeBusinessDto);
    }

    public NodeBusinessVo getBusinessVo(Long nodeId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)nodeId), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        NodeBusinessVo logicBusinessVo = new NodeBusinessVo();
        NodeBusiness nodeBusiness = (NodeBusiness)this.getById(nodeId);
        if (HussarUtils.isNotEmpty((Object)nodeBusiness)) {
            BeanUtil.copy((Object)nodeBusiness, (Object)logicBusinessVo);
            Map map = this.logicBusinessInoutService.getInoutVoListGroupByType(nodeId);
            logicBusinessVo.setIns((List)map.get(InoutType.IN.getValue()));
            logicBusinessVo.setOuts((List)map.get(InoutType.OUT.getValue()));
        }
        return logicBusinessVo;
    }

    public NodeBusinessVo getBusinessVoByNodeName(String serviceName) {
        return this.getBusinessVoByNodeName(serviceName, null);
    }

    public NodeBusinessVo getBusinessVoByNodeName(String serviceName, Long moudleId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)serviceName), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        NodeBusinessVo logicBusinessVo = new NodeBusinessVo();
        NodeBusiness nodeBusiness = (NodeBusiness)this.getOne((Wrapper)new LambdaQueryWrapper().eq(NodeBusiness::getNodeName, (Object)serviceName));
        if (HussarUtils.isNotEmpty((Object)nodeBusiness)) {
            BeanUtil.copy((Object)nodeBusiness, (Object)logicBusinessVo);
            Map map = this.logicBusinessInoutService.getInoutVoListGroupByType(nodeBusiness.getNodeId());
            logicBusinessVo.setIns((List)map.get(InoutType.IN.getValue()));
            logicBusinessVo.setOuts((List)map.get(InoutType.OUT.getValue()));
        }
        return logicBusinessVo;
    }

    private void getAllKey(NodeBusinessVo logicBusinessVo, Long moudleId) {
        MetadataColumnDto metadataColumnDto = this.getKeyColumn(logicBusinessVo);
        if (HussarUtils.isNotEmpty((Object)metadataColumnDto)) {
            logicBusinessVo.setPrimaryColumn(metadataColumnDto.getColumnAlias());
        }
        if (HussarUtils.isNotEmpty((Object)moudleId)) {
            List onDtoList;
            List relationshipJoinList;
            RelationshipDto relationshipDto = this.relationshipService.getRelationshipById(moudleId);
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)relationshipDto), (String)"\u67e5\u8be2\u4e0d\u5230\u5f53\u524d\u6a21\u578b\u7684\u5173\u8054\u5173\u7cfb");
            List relationshipJoinDtos = relationshipDto.getJoinDtoList();
            RelationshipJoinDto relationshipJoinDtoitem = null;
            if (HussarUtils.isNotEmpty((Object)relationshipJoinDtos) && HussarUtils.isNotEmpty(relationshipJoinList = relationshipJoinDtos.stream().filter(relationshipJoinDto -> relationshipJoinDto.getRightTableId().equals(logicBusinessVo.getModelId())).collect(Collectors.toList()))) {
                relationshipJoinDtoitem = (RelationshipJoinDto)relationshipJoinList.get(0);
            }
            RelationshipOnDto item = null;
            if (HussarUtils.isNotEmpty(relationshipJoinDtoitem) && HussarUtils.isNotEmpty(onDtoList = relationshipJoinDtoitem.getOnDtoList().stream().filter(relationship -> relationship.getRightColumn().getTableId().equals(logicBusinessVo.getModelId())).collect(Collectors.toList()))) {
                item = (RelationshipOnDto)onDtoList.get(0);
            }
            if (HussarUtils.isNotEmpty(item)) {
                String forkey = item.getRightColumn().getColumnAlias();
                logicBusinessVo.setForeignColumn(forkey);
            }
        }
    }

    private MetadataColumnDto getKeyColumn(NodeBusinessVo logicBusinessVo) {
        List columnDtoList = this.metadataColumnService.listColumnDtoByTableId(logicBusinessVo.getModelId());
        for (MetadataColumnDto columnDto : columnDtoList) {
            if (!HussarUtils.isNotBlank((CharSequence)columnDto.getPrimarys())) continue;
            return columnDto;
        }
        return null;
    }
}

