/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.adaptation.source;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelMapDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.api.enums.ModelSourceEnum;
import com.jxdinfo.hussar.support.engine.plugin.model.application.action.assemble.ModelAssembleAction;
import com.jxdinfo.hussar.support.engine.plugin.model.application.action.source.ModelSourceAction;
import com.jxdinfo.hussar.support.engine.plugin.model.application.factory.ModelSaveFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ModelSharedSourceAction
extends ModelSourceAction {
    public ModelSharedSourceAction() {
        ModelSaveFactory.addSourceAction(ModelSourceEnum.SHARED.getValue(), this);
    }

    @Override
    @DSTransactional
    public void saveModel(ModelInfoDto modelInfoDto) {
        ModelMapDto modelMapDto = new ModelMapDto();
        ModelAssembleAction action = ModelSaveFactory.getActionByType(modelInfoDto.getType());
        List<ModelRelationship> relationshipList = action.getModelRelationshipsFromDto(modelInfoDto);
        List<TableInfoDto> tableInfoDtoList = action.getTableInfoDtoFromRelations(relationshipList);
        List<MetadataParam> paramList = action.getMetadataParamsFromTableInfos(tableInfoDtoList, modelInfoDto, modelMapDto);
        List<ModelColumnsRules> columnsRulesList = action.getColumnRulesFromRelations(relationshipList);
        this.addInfoToMap(columnsRulesList, modelMapDto);
        List<ModelPublishDTO> modelPublishDTOList = action.assembleModelPublishDtos(relationshipList, modelMapDto);
        for (MetadataParam param : paramList) {
            this.hussarMetadataService.insertTableInfo(param);
        }
        this.modelRelateService.save(modelPublishDTOList);
    }

    private void addInfoToMap(List<ModelColumnsRules> columnsRulesList, ModelMapDto modelMapDto) {
        for (ModelColumnsRules columnsRule : columnsRulesList) {
            ArrayList<ModelColumnsRules> list = (ArrayList<ModelColumnsRules>)modelMapDto.getColumnRuleListMap().get(columnsRule.getTfmodelId());
            if (HussarUtils.isEmpty((Object)list)) {
                list = new ArrayList<ModelColumnsRules>();
            }
            list.add(columnsRule);
            modelMapDto.getColumnRuleListMap().put(columnsRule.getTfmodelId(), list);
        }
    }
}

