/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.action.operate;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelMapDto;
import com.jxdinfo.hussar.support.engine.api.enums.ModelDefaultFieldEnum;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.SQLModelService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class ModelOperateAction {
    @Autowired
    protected ModelRelateService modelRelateService;
    @Autowired
    protected HussarDdlService hussarDdlService;
    @Autowired
    protected HussarMetadataService hussarMetadataService;
    @Autowired
    protected SQLModelService sqlModelService;

    public abstract void saveModel(ModelInfoDto var1) throws SQLException, InterruptedException;

    public void saveSQLModel(ModelInfoDto modelInfoDto) {
        this.sqlModelService.publishSQLModel(modelInfoDto);
    }

    protected void addTableAndColumnIdToMap(TableInfoDto tableInfoDto, ModelMapDto modelMapDto) {
        if (HussarUtils.isEmpty((Object)tableInfoDto)) {
            return;
        }
        modelMapDto.getTableIdMap().put(tableInfoDto.getTableName(), tableInfoDto.getTableId());
        if (HussarUtils.isNotEmpty((Object)tableInfoDto.getColumnList())) {
            for (MetadataColumn column : tableInfoDto.getColumnList()) {
                modelMapDto.getColumnIdMap().put(tableInfoDto.getTableName() + column.getColumnName(), column.getColumnId());
            }
        }
    }

    protected List<String> getTableNamesFromDto(ModelInfoDto modelInfoDto) {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(modelInfoDto.getTableName());
        if (HussarUtils.isNotEmpty((Object)modelInfoDto.getChildren())) {
            this.addTableNameFromDto(tableNames, modelInfoDto.getChildren());
        }
        return tableNames;
    }

    protected void addTableNameFromDto(List<String> tableNames, List<ModelInfoDto> modelInfoDtoList) {
        for (ModelInfoDto modelInfoDto : modelInfoDtoList) {
            tableNames.add(modelInfoDto.getTableName());
            if (!HussarUtils.isNotEmpty((Object)modelInfoDto.getChildren())) continue;
            this.addTableNameFromDto(tableNames, modelInfoDto.getChildren());
        }
    }

    protected List<String> getTfModelIdsFromDto(ModelInfoDto modelInfoDto) {
        ArrayList<String> tfModelIds = new ArrayList<String>();
        tfModelIds.add(modelInfoDto.getModelId());
        if (HussarUtils.isNotEmpty((Object)modelInfoDto.getChildren())) {
            this.addTfModelIdFromDto(tfModelIds, modelInfoDto.getChildren());
        }
        return tfModelIds;
    }

    protected void addTfModelIdFromDto(List<String> tfModelIds, List<ModelInfoDto> modelInfoDtoList) {
        for (ModelInfoDto modelInfoDto : modelInfoDtoList) {
            tfModelIds.add(modelInfoDto.getTableName());
            if (!HussarUtils.isNotEmpty((Object)modelInfoDto.getChildren())) continue;
            this.addTfModelIdFromDto(tfModelIds, modelInfoDto.getChildren());
        }
    }

    protected MetadataParam getDdlMetadataParam(MetadataParam metadataParam) {
        MetadataParam newParam = (MetadataParam)BeanUtil.copy((Object)metadataParam, MetadataParam.class);
        if (HussarUtils.isEmpty((Object)newParam)) {
            return null;
        }
        List columnInfoList = newParam.getColumnInfo();
        ArrayList<ColumnInfoDto> newColumnList = new ArrayList<ColumnInfoDto>();
        if (HussarUtils.isNotEmpty((Object)columnInfoList)) {
            for (ColumnInfoDto columnInfo : columnInfoList) {
                if (columnInfo.isSyncToTable()) {
                    if ("primary".equals(columnInfo.getPurpose())) {
                        columnInfo.setPk("1");
                    }
                    newColumnList.add(columnInfo);
                    continue;
                }
                if (!"primary".equals(columnInfo.getPurpose()) || this.isDefaultPrimary(columnInfo.getColumnName())) continue;
                newParam.setHavePk(true);
                columnInfo.setPurpose(null);
                columnInfo.setPrimarys("");
                columnInfo.setOperation("edit");
                columnInfo.setPk("0");
                newColumnList.add(columnInfo);
            }
        }
        newParam.setColumnInfo(newColumnList);
        return newParam;
    }

    private boolean isDefaultPrimary(String columnName) {
        if (ModelDefaultFieldEnum.PRIMARY_KEY.getFieldName().equals(columnName)) {
            return true;
        }
        return ModelDefaultFieldEnum.BPM_PRIMARY_KEY.getFieldName().equals(columnName);
    }
}

