/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.EngineDdlSqlUtil;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.collection.Pair;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.JoinInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelMapDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipJoin;
import com.jxdinfo.hussar.support.engine.api.model.SQLModel;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.engine.plugin.model.assembler.ModelParamAssembler;
import com.jxdinfo.hussar.support.engine.plugin.model.dao.SQLModelMapper;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.SQLModelExtendInfo;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelColumnsService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipJoinService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipOnService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.SQLModelService;
import com.jxdinfo.hussar.support.engine.plugin.model.sqlmodel.builder.BasicSQLBuilder;
import com.jxdinfo.hussar.support.engine.plugin.model.sqlmodel.factory.SQLModelFactory;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLModelServiceImpl
extends HussarServiceImpl<SQLModelMapper, SQLModel>
implements SQLModelService {
    private static final Logger log = LoggerFactory.getLogger(SQLModelServiceImpl.class);
    @Autowired
    private DynamicDatasourceService datasourceService;
    @Autowired
    private ModelRelationshipService modelRelationshipService;
    @Autowired
    private ModelColumnsService modelColumnsService;
    @Autowired
    private MetadataTableService metadataTableService;
    @Autowired
    private MetadataColumnService metadataColumnService;
    @Autowired
    private RelationshipJoinService relationshipJoinService;
    @Autowired
    private RelationshipOnService relationshipOnService;
    @Autowired
    private ModelRelateService modelRelateService;

    @Override
    public void publishSQLModel(ModelInfoDto modelInfoDto) {
        if (HussarUtils.isNotEmpty((Object)modelInfoDto.getCustomSql())) {
            this.saveSQL(modelInfoDto);
            return;
        }
        ModelMapDto modelMapDto = new ModelMapDto();
        ArrayList<ModelInfoDto> allModelInfo = new ArrayList<ModelInfoDto>();
        this.getAllModel(modelInfoDto, allModelInfo);
        this.validateFieldAlisa(allModelInfo);
        this.buildModelMapDto(allModelInfo, modelMapDto);
        this.deleteOldModel(modelInfoDto);
        List<ModelPublishDTO> publishDTOList = ModelParamAssembler.getModelPublishDtosFromDtos(Collections.singletonList(modelInfoDto), modelMapDto);
        this.modelRelateService.save(publishDTOList);
        this.saveSQLModel(modelInfoDto, modelMapDto);
    }

    private void getAllModel(ModelInfoDto modelInfoDto, List<ModelInfoDto> allModelInfo) {
        allModelInfo.add(modelInfoDto);
        if (HussarUtils.isNotEmpty((Object)modelInfoDto.getChildren())) {
            for (ModelInfoDto child : modelInfoDto.getChildren()) {
                JoinInfoDto joinInfo = child.getJoinInfo();
                HussarException.throwBy((joinInfo == null ? 1 : 0) != 0, (String)"\u5b50\u8868\u4e2d\u5173\u8054\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
                joinInfo.setLeftTfModelId(modelInfoDto.getModelId());
                joinInfo.setLeftTableName(modelInfoDto.getTableName());
                joinInfo.setRightTfModelId(child.getModelId());
                joinInfo.setRightTableName(child.getTableName());
                this.getAllModel(child, allModelInfo);
            }
        }
    }

    private void validateFieldAlisa(List<ModelInfoDto> allModelInfo) {
        HashSet<String> fieldAlisaSet = new HashSet<String>();
        HashSet<String> repeatColumnNames = new HashSet<String>();
        for (ModelInfoDto modelInfoDto : allModelInfo) {
            if (!HussarUtils.isNotEmpty((Object)modelInfoDto.getFieldList())) continue;
            for (ModelFieldDto field : modelInfoDto.getFieldList()) {
                if (fieldAlisaSet.contains(field.getFieldAlias())) {
                    repeatColumnNames.add(field.getFieldAlias());
                }
                fieldAlisaSet.add(field.getFieldAlias());
            }
        }
        HussarException.throwBy((!repeatColumnNames.isEmpty() ? 1 : 0) != 0, (String)("\u5b57\u6bb5\u522b\u540d\u4e0d\u53ef\u91cd\u590d\uff1a" + JSON.toJSONString(repeatColumnNames)));
    }

    private void buildModelMapDto(List<ModelInfoDto> allModelInfo, ModelMapDto modelMapDto) {
        HashMap allColumns = new HashMap();
        for (ModelInfoDto modelInfoDto : allModelInfo) {
            List fieldColumn = modelInfoDto.getFieldList().stream().map(ModelFieldDto::getFieldName).collect(Collectors.toList());
            if (!allColumns.containsKey(modelInfoDto.getTableName())) {
                allColumns.put(modelInfoDto.getTableName(), new HashSet());
            }
            ((Set)allColumns.get(modelInfoDto.getTableName())).addAll(fieldColumn);
            JoinInfoDto joinInfo = modelInfoDto.getJoinInfo();
            if (!HussarUtils.isNotEmpty((Object)joinInfo)) continue;
            ((Set)allColumns.get(joinInfo.getLeftTableName())).add(joinInfo.getLeftColumnName());
            ((Set)allColumns.get(joinInfo.getRightTableName())).add(joinInfo.getRightColumnName());
        }
        List allTableIds = this.metadataTableService.list((Wrapper)Wrappers.lambdaQuery(MetadataTable.class).in(MetadataTable::getTableName, allColumns.keySet())).stream().map(MetadataTable::getTableId).collect(Collectors.toList());
        HussarException.throwBy((boolean)HussarUtils.isEmpty(allTableIds), (String)"\u6784\u9020SQL\u6a21\u578b\u6307\u5b9a\u7684\u8868\u4e0d\u5b58\u5728");
        List metadataColumnList = this.metadataColumnService.list((Wrapper)Wrappers.lambdaQuery(MetadataColumn.class).in(MetadataColumn::getTableId, allTableIds));
        Map<String, Map<Long, Map<String, Long>>> map = metadataColumnList.stream().collect(Collectors.groupingBy(MetadataColumn::getTableName, Collectors.groupingBy(MetadataColumn::getTableId, Collectors.toMap(MetadataColumn::getColumnName, MetadataColumn::getColumnId))));
        for (String tableName : allColumns.keySet()) {
            HussarException.throwBy((!map.containsKey(tableName) ? 1 : 0) != 0, (String)String.format("\u5143\u6570\u636e\u4e2d\u4e0d\u5b58\u5728 %s \u8868", tableName));
            Map<Long, Map<String, Long>> tableId2Column = map.get(tableName);
            for (Long tableId : tableId2Column.keySet()) {
                boolean flag = false;
                Map<String, Long> columnName2Id = tableId2Column.get(tableId);
                HashSet allNoExistColumn = new HashSet();
                if (columnName2Id.keySet().containsAll((Collection)allColumns.get(tableName))) {
                    flag = true;
                    modelMapDto.getTableIdMap().put(tableName, tableId);
                    for (String columnName : (Set)allColumns.get(tableName)) {
                        modelMapDto.getColumnIdMap().put(tableName + columnName, columnName2Id.get(columnName));
                    }
                } else {
                    HashSet noExistColumn = new HashSet((Collection)allColumns.get(tableName));
                    noExistColumn.removeAll(columnName2Id.keySet());
                    allNoExistColumn.addAll(noExistColumn);
                    log.warn("[{}]\u8868\u5143\u6570\u636emetadata_table id {} \u4e0d\u5b58\u5728 {} \u5217", new Object[]{tableName, tableId, JSON.toJSONString(noExistColumn)});
                }
                if (flag) continue;
                throw new HussarException(String.format("\u5143\u6570\u636e\u4e2d %s \u8868\u4e0d\u5b58\u5728 %s \u5217", tableName, JSON.toJSONString(allNoExistColumn)));
            }
        }
        for (ModelInfoDto modelInfoDto : allModelInfo) {
            JoinInfoDto joinInfo = modelInfoDto.getJoinInfo();
            if (!HussarUtils.isNotEmpty((Object)joinInfo)) continue;
            Long leftColumnId = (Long)modelMapDto.getColumnIdMap().get(joinInfo.getLeftTableName() + joinInfo.getLeftColumnName());
            Long rightColumnId = (Long)modelMapDto.getColumnIdMap().get(joinInfo.getRightTableName() + joinInfo.getRightColumnName());
            modelMapDto.getOnsMap().put(modelInfoDto.getModelId(), Pair.of((Object)leftColumnId, (Object)rightColumnId));
        }
        String mastTableName = allModelInfo.get(0).getTableName();
        int count = 0;
        for (ModelInfoDto modelInfoDto : allModelInfo) {
            modelMapDto.getTableAliasMap().put(modelInfoDto.getModelId(), mastTableName + "_o" + ++count);
        }
    }

    private void deleteOldModel(ModelInfoDto modelInfoDto) {
        ModelRelationship parent = (ModelRelationship)this.modelRelationshipService.getOne((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).eq(ModelRelationship::getTfmodelId, (Object)modelInfoDto.getModelId()));
        if (HussarUtils.isEmpty((Object)parent)) {
            return;
        }
        List relationIds = this.modelRelationshipService.list((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).like(ModelRelationship::getParentPath, (Object)parent.getRelatedId())).stream().map(ModelRelationship::getRelatedId).collect(Collectors.toList());
        relationIds.add(parent.getRelatedId());
        this.modelRelationshipService.remove((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).in(ModelRelationship::getRelatedId, relationIds));
        this.modelColumnsService.remove((Wrapper)Wrappers.lambdaQuery(ModelColumns.class).in(ModelColumns::getRelatedId, relationIds));
        List list = this.relationshipJoinService.list((Wrapper)Wrappers.lambdaQuery(RelationshipJoin.class).select(new SFunction[]{RelationshipJoin::getId}).in(RelationshipJoin::getModelId, relationIds));
        List<Long> joinId = list.stream().map(RelationshipJoin::getId).collect(Collectors.toList());
        this.relationshipJoinService.removeByIds(joinId);
        if (!joinId.isEmpty()) {
            this.relationshipOnService.removeByJoinIds(joinId);
        }
    }

    private void saveSQLModel(ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        BasicSQLBuilder sqlBuilder = SQLModelFactory.getSQLBuilder(this.getDbTypeName());
        String sqlStatement = sqlBuilder.buildSQLModelStatement(modelInfoDto, modelMapDto);
        SQLModel sqlModel = (SQLModel)this.getOne((Wrapper)Wrappers.lambdaQuery(SQLModel.class).eq(SQLModel::getTfModelId, (Object)modelInfoDto.getModelId()));
        if (sqlModel == null) {
            sqlModel = new SQLModel();
            sqlModel.setTfModelId(modelInfoDto.getModelId());
            sqlModel.setModelId((Long)modelMapDto.getModelRelationIdMap().get(modelInfoDto.getModelId()));
        }
        sqlModel.setSQLStatement(sqlStatement);
        SQLModelExtendInfo sqlModelExtendInfo = new SQLModelExtendInfo();
        sqlModelExtendInfo.setTableAliasMap(modelMapDto.getTableAliasMap());
        sqlModel.setJsonParam(JSON.toJSONString((Object)sqlModelExtendInfo));
        this.saveOrUpdate((BaseEntity)sqlModel);
    }

    private void saveSQL(ModelInfoDto modelInfoDto) {
        SQLModel sqlModel = (SQLModel)this.getOne((Wrapper)Wrappers.lambdaQuery(SQLModel.class).eq(SQLModel::getTfModelId, (Object)modelInfoDto.getModelId()));
        if (sqlModel == null) {
            sqlModel = new SQLModel();
            sqlModel.setTfModelId(modelInfoDto.getModelId());
        }
        String textSql = EngineDdlSqlUtil.getDynamicSqlSource((String)modelInfoDto.getCustomSql(), new HashMap(), (String)"param").getSql();
        this.checkSql(textSql);
        String customSql = modelInfoDto.getCustomSql().trim();
        if (customSql.endsWith(";")) {
            customSql = customSql.substring(0, customSql.length() - 1);
        }
        String sqlStatement = String.format("SELECT * FROM (%s) t", customSql);
        sqlModel.setSQLStatement(sqlStatement);
        SQLModelExtendInfo sqlModelExtendInfo = new SQLModelExtendInfo();
        sqlModelExtendInfo.setPollName(modelInfoDto.getPollName());
        sqlModelExtendInfo.setFieldList(modelInfoDto.getFieldList());
        sqlModel.setJsonParam(JSON.toJSONString((Object)sqlModelExtendInfo));
        this.saveOrUpdate((BaseEntity)sqlModel);
    }

    private String getDbTypeName() {
        return this.datasourceService.getCurrentDatasource().getDbType().getDb();
    }

    @Override
    public SQLModel getModelByTfId(String tfModelId) {
        return (SQLModel)this.getOne((Wrapper)Wrappers.lambdaQuery(SQLModel.class).eq(SQLModel::getTfModelId, (Object)tfModelId));
    }

    private void checkSql(String textSql) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)EngineDdlSqlUtil.getGenericTokenParser(content -> "?").parse(textSql));
            if (statement instanceof Select) {
                return;
            }
        }
        catch (JSQLParserException e) {
            throw new HussarException((Throwable)e);
        }
        throw new HussarException("SQL\u5f02\u5e38\u6216\u975e\u67e5\u8be2SQL\uff01");
    }
}

