/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.assembler.ModelTableAssembler;
import com.jxdinfo.hussar.support.engine.plugin.model.dao.ModelRelationshipMapper;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.ModelInfo;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.ModelStructure;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.TableRelation;
import com.jxdinfo.hussar.support.engine.plugin.model.exception.PluginModelValidateException;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelColumnsRulesService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelColumnsService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelRelationshipServiceImpl
extends HussarServiceImpl<ModelRelationshipMapper, ModelRelationship>
implements ModelRelationshipService {
    private static final Logger logger = LoggerFactory.getLogger(ModelRelationshipServiceImpl.class);
    @Autowired
    private ModelColumnsService modelColumnsService;
    @Autowired
    private ModelColumnsRulesService rulesService;

    @Override
    public ModelStructure getModelStructure(long rootId) {
        HashMap<String, List<ModelRelationship>> relationshipMap = new HashMap<String, List<ModelRelationship>>();
        List masterRelationships = this.list((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).eq(ModelRelationship::getRelatedId, (Object)rootId));
        if (HussarUtils.isEmpty((Object)masterRelationships)) {
            return null;
        }
        relationshipMap.put("master", masterRelationships);
        List msRelationships = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ModelRelationship.class).like(ModelRelationship::getParentPath, (Object)rootId)).or()).eq(ModelRelationship::getRelatedId, (Object)rootId));
        relationshipMap.put("ms", msRelationships);
        List<Long> relatedIds = msRelationships.stream().map(ModelRelationship::getRelatedId).collect(Collectors.toList());
        List<ModelColumns> modelColumns = this.modelColumnsService.getModelColumns(relatedIds);
        return ModelTableAssembler.toModelStructure(relationshipMap, modelColumns);
    }

    @Override
    public ModelRelationship getModelRelationship(String tfModelId) {
        return (ModelRelationship)this.getOne((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).eq(ModelRelationship::getTfmodelId, (Object)tfModelId));
    }

    @Override
    public List<ModelRelationship> getModelRelationships(List<String> tfModelIds) {
        if (HussarUtils.isEmpty(tfModelIds)) {
            return new ArrayList<ModelRelationship>();
        }
        return this.list((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).in(ModelRelationship::getTfmodelId, tfModelIds));
    }

    @Override
    @DSTransactional
    public List<ModelRelationship> batchSaveModels(List<ModelPublishDTO> modelPublish) {
        if (HussarUtils.isEmpty(modelPublish)) {
            return new ArrayList<ModelRelationship>();
        }
        Optional<ModelPublishDTO> root = modelPublish.stream().filter(x -> "0".equals(x.getParentPath())).findFirst();
        PluginModelValidateException.throwBy(!root.isPresent(), "\u6ca1\u6709\u627e\u5230\u4e3b\u6a21\u578b");
        List<ModelRelationship> oldModels = this.getModelsByTfmodelId(root.get().getTfmodelId());
        this.updateNewModels(modelPublish, oldModels);
        Map<Long, ModelColumns> oldModelColumnsMap = this.deleteOldModels(oldModels);
        List<Long> oldRelateIds = oldModels.stream().map(ModelRelationship::getRelatedId).collect(Collectors.toList());
        this.saveBatch(new ArrayList<ModelPublishDTO>(modelPublish));
        ArrayList updateModelColumnIds = new ArrayList();
        ArrayList updateModelColumns = new ArrayList();
        ArrayList saveModelColumns = new ArrayList();
        Map tfModel2NewModel = modelPublish.stream().collect(Collectors.toMap(ModelRelationship::getTfmodelId, Function.identity(), (k1, k2) -> k1));
        modelPublish.forEach(x -> {
            if (tfModel2NewModel.containsKey(x.getTfmodelId())) {
                x.getModelColumns().forEach(column -> {
                    column.setRelatedId(((ModelRelationship)tfModel2NewModel.get(x.getTfmodelId())).getRelatedId());
                    Long modelColumnId = EngineUtil.getId();
                    if (oldModelColumnsMap.containsKey(column.getColumnId())) {
                        modelColumnId = ((ModelColumns)oldModelColumnsMap.get(column.getColumnId())).getModelColumnId();
                        column.setModelColumnId(modelColumnId);
                        updateModelColumnIds.add(modelColumnId);
                        updateModelColumns.add(column);
                    } else {
                        column.setModelColumnId(modelColumnId);
                        saveModelColumns.add(column);
                    }
                });
            } else {
                logger.error("\u6ca1\u627e\u5230\u6a21\u578b\uff0c\u5929\u65a7\u6a21\u578bid\uff1a{}", (Object)x.getTfmodelId());
            }
        });
        ArrayList<Long> deleteModelColumnIds = new ArrayList<Long>();
        for (ModelColumns entry : oldModelColumnsMap.values()) {
            if (updateModelColumnIds.contains(entry.getModelColumnId())) continue;
            deleteModelColumnIds.add(entry.getModelColumnId());
        }
        if (HussarUtils.isNotEmpty(deleteModelColumnIds)) {
            this.modelColumnsService.removeByIds(deleteModelColumnIds);
        }
        if (HussarUtils.isNotEmpty(updateModelColumns)) {
            this.modelColumnsService.updateBatchById(updateModelColumns);
        }
        if (HussarUtils.isNotEmpty(saveModelColumns)) {
            this.modelColumnsService.saveBatch(saveModelColumns);
        }
        ArrayList rules = new ArrayList();
        ArrayList<Long> deleteRuleIds = new ArrayList<Long>();
        ArrayList updateRuleIds = new ArrayList();
        ArrayList updateRules = new ArrayList();
        ArrayList saveRules = new ArrayList();
        List<ModelColumnsRules> modelColumnsRules = this.rulesService.getRulesByRelatedIdList(oldRelateIds);
        Map rulesMap = modelColumnsRules.stream().collect(Collectors.toMap(m -> m.getRuleType() + m.getColumnAlias(), Function.identity()));
        for (ModelPublishDTO model : modelPublish) {
            if (!HussarUtils.isNotEmpty((Object)model.getModelColumnsRules())) continue;
            Map<String, ModelColumns> alias2Column = model.getModelColumns().stream().collect(Collectors.toMap(ModelColumns::getColumnAlias, x -> x, (k1, k2) -> k1));
            ModelRelationship newModel = (ModelRelationship)tfModel2NewModel.get(model.getTfmodelId());
            model.getModelColumnsRules().forEach(x -> {
                boolean exit;
                Long ruleId = EngineUtil.getId();
                if (rulesMap.containsKey(x.getRuleType() + x.getColumnAlias())) {
                    ruleId = ((ModelColumnsRules)rulesMap.get(x.getRuleType() + x.getColumnAlias())).getRuleId();
                    x.setRuleId(ruleId);
                    updateRuleIds.add(ruleId);
                    updateRules.add(x);
                } else {
                    x.setRuleId(ruleId);
                    saveRules.add(x);
                }
                if (x.getRelatedId() == null) {
                    x.setRelatedId(newModel.getRelatedId());
                }
                if (HussarUtils.isBlank((CharSequence)x.getTfmodelId())) {
                    x.setTfmodelId(newModel.getTfmodelId());
                }
                if (HussarUtils.isNotBlank((CharSequence)x.getColumnAlias()) && (exit = alias2Column.containsKey(x.getColumnAlias()))) {
                    x.setModelColumnId(((ModelColumns)alias2Column.get(x.getColumnAlias())).getModelColumnId());
                    x.setColumnName(((ModelColumns)alias2Column.get(x.getColumnAlias())).getColumnName());
                }
            });
        }
        for (ModelColumnsRules rule : rulesMap.values()) {
            if (updateRuleIds.contains(rule.getRuleId())) continue;
            deleteRuleIds.add(rule.getRuleId());
        }
        if (HussarUtils.isNotEmpty(deleteRuleIds)) {
            this.rulesService.removeByIds(deleteRuleIds);
        }
        if (HussarUtils.isNotEmpty(updateRules)) {
            this.rulesService.updateBatchById(updateRules);
        }
        if (HussarUtils.isNotEmpty(saveRules)) {
            this.rulesService.saveBatch(saveRules);
        }
        return oldModels;
    }

    private Map<Long, ModelColumns> deleteOldModels(List<ModelRelationship> oldModels) {
        if (HussarUtils.isEmpty(oldModels)) {
            return new HashMap<Long, ModelColumns>();
        }
        List<Long> ids = oldModels.stream().map(ModelRelationship::getRelatedId).filter(Objects::nonNull).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(ids)) {
            this.removeByIds(ids);
            return this.modelColumnsService.getModelColumns(ids).stream().collect(Collectors.toMap(ModelColumns::getColumnId, Function.identity(), (k1, k2) -> k1));
        }
        return new HashMap<Long, ModelColumns>();
    }

    private void updateNewModels(List<ModelPublishDTO> newModels, List<ModelRelationship> oldModels) {
        if (HussarUtils.isEmpty(newModels) || HussarUtils.isEmpty(oldModels)) {
            return;
        }
        Map tfmodelId2OldModel = oldModels.stream().collect(Collectors.toMap(ModelRelationship::getTfmodelId, Function.identity()));
        newModels.forEach(newModel -> {
            if (tfmodelId2OldModel.containsKey(newModel.getTfmodelId())) {
                Long oldRelatedId = ((ModelRelationship)tfmodelId2OldModel.get(newModel.getTfmodelId())).getRelatedId();
                List<ModelRelationship> children = newModels.stream().filter(x -> x.getParentPath().contains(newModel.getRelatedId().toString())).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(children)) {
                    children.forEach(child -> child.setParentPath(child.getParentPath().replace(newModel.getRelatedId().toString(), oldRelatedId.toString())));
                }
                newModel.setRelatedId(oldRelatedId);
            }
        });
    }

    @Override
    public List<ModelRelationship> getAllRootNodes() {
        return this.list((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).eq(ModelRelationship::getParentPath, (Object)"0"));
    }

    @Override
    public Integer getRefCountsByTableRelation(TableRelation tableRelation) {
        List<Long> tableIds = tableRelation.getTableIds();
        List list = this.list((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).in(ModelRelationship::getTableId, tableIds));
        Map<Boolean, List<ModelRelationship>> tableIdGroup = list.stream().collect(Collectors.groupingBy(x -> x.getTableId().equals(tableRelation.getLeftTableId())));
        if (HussarUtils.isEmpty(tableIdGroup.get(true)) || HussarUtils.isEmpty(tableIdGroup.get(false))) {
            return 0;
        }
        List leftRelatedIds = tableIdGroup.get(true).stream().map(ModelRelationship::getRelatedId).collect(Collectors.toList());
        Integer count = 0;
        for (ModelRelationship right : tableIdGroup.get(false)) {
            if (!leftRelatedIds.contains(right.getParentId()) || tableRelation.getRelation() == null || !tableRelation.getRelation().equals((Object)right.getRelation())) continue;
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        return count;
    }

    @Override
    public List<Long> getExistTableIds(List<Long> tableIds) {
        if (HussarUtils.isEmpty(tableIds)) {
            return new ArrayList<Long>();
        }
        List models = this.list((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).in(ModelRelationship::getTableId, tableIds));
        if (HussarUtils.isNotEmpty((Object)models)) {
            return models.stream().map(ModelRelationship::getTableId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    @Override
    public Long getModelId(String tfModelId) {
        List list = this.list((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).eq(ModelRelationship::getTfmodelId, (Object)tfModelId));
        if (list.size() == 0) {
            throw new HussarException("\u6ca1\u6709\u5728\u6a21\u578b\u5173\u7cfb\u8868\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u5929\u65a7\u6a21\u578b");
        }
        return ((ModelRelationship)list.get(0)).getRelatedId();
    }

    @Override
    public List<ModelRelationship> deleteRelations(String tfModelId) {
        List<ModelRelationship> deletes = this.getModelsByTfmodelId(tfModelId);
        if (HussarUtils.isNotEmpty(deletes)) {
            this.removeByIds(deletes.stream().map(ModelRelationship::getRelatedId).collect(Collectors.toList()));
        }
        return deletes;
    }

    @Override
    public List<ModelRelationship> getModelsByTfmodelId(String tfModelId) {
        if (tfModelId == null) {
            return new ArrayList<ModelRelationship>();
        }
        ModelRelationship master = (ModelRelationship)this.getOne((Wrapper)Wrappers.lambdaQuery(ModelRelationship.class).eq(ModelRelationship::getTfmodelId, (Object)tfModelId));
        if (master != null) {
            return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ModelRelationship.class).eq(ModelRelationship::getRelatedId, (Object)master.getRelatedId())).or()).likeRight(ModelRelationship::getParentPath, (Object)("0," + master.getRelatedId())));
        }
        return new ArrayList<ModelRelationship>();
    }

    @Override
    public List<ModelInfo> getModelInfos(Long relatedId) {
        if (relatedId == 0L || relatedId == null) {
            return new ArrayList<ModelInfo>();
        }
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ModelRelationship.class).like(ModelRelationship::getParentPath, (Object)relatedId)).or()).eq(ModelRelationship::getRelatedId, (Object)relatedId));
        if (HussarUtils.isEmpty((Object)list)) {
            return new ArrayList<ModelInfo>();
        }
        List<Long> relatedIds = list.stream().map(ModelRelationship::getRelatedId).collect(Collectors.toList());
        List<ModelColumns> modelColumns = this.modelColumnsService.getModelColumns(relatedIds);
        List modelInfos = BeanUtil.copyToList((Collection)list, ModelInfo.class);
        modelInfos.forEach(x -> x.setModelColumns(modelColumns.stream().filter(y -> x.getRelatedId().equals(y.getRelatedId())).collect(Collectors.toList())));
        return modelInfos;
    }

    @Override
    public void updateModelInfos(List<ModelInfo> modelInfos) {
        if (HussarUtils.isEmpty(modelInfos)) {
            return;
        }
        List modelRelationships = BeanUtil.copyToList(modelInfos, ModelRelationship.class);
        this.updateBatchById(modelRelationships);
        ArrayList modelColumns = new ArrayList();
        modelInfos.forEach(x -> {
            if (HussarUtils.isNotEmpty(x.getModelColumns())) {
                modelColumns.addAll(x.getModelColumns());
            }
        });
        this.modelColumnsService.updateBatchById(modelColumns);
    }
}

