/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.assembler;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.IndexInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.collection.Pair;
import com.jxdinfo.hussar.support.engine.api.dto.JoinInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldRulesDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelIndexDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelMapDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipOn;
import com.jxdinfo.hussar.support.engine.api.enums.ModelDefaultFieldEnum;
import com.jxdinfo.hussar.support.engine.api.enums.ModelOperationTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.List;

public class ModelParamAssembler {
    public static final String PRIMARY = "primary";
    public static final String SPLIT_STR = ",";
    public static final String PROCESS_TASK_INFO = "process_task_info_";
    public static final String TASK = "task_";
    public static final String ROOT_PARENT_ID = "0";
    public static final String RULE_TYPE_TITLE = "3";
    public static final String RULE_TYPE_SUMMARY = "4";

    public static List<MetadataParam> getMetadataParamsFromDto(ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        ArrayList<MetadataParam> paramList = new ArrayList<MetadataParam>();
        ModelParamAssembler.addMetadataParamFromDto(paramList, modelInfoDto, modelMapDto);
        return paramList;
    }

    public static void addMetadataParamFromDto(List<MetadataParam> paramList, ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        if (ModelOperationTypeEnum.isDelete((String)modelInfoDto.getOperationType())) {
            return;
        }
        modelMapDto.getModelInfoDtoMap().put(modelInfoDto.getModelId(), modelInfoDto);
        MetadataParam param = new MetadataParam();
        param.setTfModelId(modelInfoDto.getModelId());
        param.setTableInfo(ModelParamAssembler.getTableInfoFromDto(modelInfoDto, modelMapDto));
        param.setColumnInfo(ModelParamAssembler.getColumnInfosFromDto(modelInfoDto.getFieldList(), modelMapDto, modelInfoDto.getTableName()));
        param.setIndexInfo(ModelParamAssembler.getIndexInfoFromDto(modelInfoDto.getIndexList()));
        param.setDeleteIdxs(ModelParamAssembler.getDelIndexInfoFromDto(modelInfoDto.getIndexList()));
        paramList.add(param);
        if (HussarUtils.isNotEmpty((Object)modelInfoDto.getChildren())) {
            for (ModelInfoDto child : modelInfoDto.getChildren()) {
                ModelParamAssembler.addMetadataParamFromDto(paramList, child, modelMapDto);
            }
        }
    }

    public static TableInfoDto getTableInfoFromDto(ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        TableInfoDto tableInfoDto = new TableInfoDto();
        tableInfoDto.setTableId(ModelParamAssembler.getTableId(modelInfoDto, modelMapDto));
        tableInfoDto.setColumnList(ModelParamAssembler.getMetadataColumnsFromDto(modelInfoDto.getFieldList(), modelMapDto, modelInfoDto.getTableName()));
        tableInfoDto.setDatasourceId(modelInfoDto.getDatasourceId());
        tableInfoDto.setPollName(modelInfoDto.getPollName());
        tableInfoDto.setTableAlias(modelInfoDto.getModelName());
        tableInfoDto.setTableDec(modelInfoDto.getModelDec());
        tableInfoDto.setTableName(modelInfoDto.getTableName());
        return tableInfoDto;
    }

    public static List<ColumnInfoDto> getColumnInfosFromDto(List<ModelFieldDto> fieldDtoList, ModelMapDto modelMapDto, String tableName) {
        ArrayList<ColumnInfoDto> columnInfoDtoList = new ArrayList<ColumnInfoDto>();
        for (ModelFieldDto modelFieldDto : fieldDtoList) {
            if (!ModelOperationTypeEnum.isDelete((String)modelFieldDto.getOperationType())) {
                ColumnInfoDto columnInfoDto = ModelParamAssembler.getColumnInfoFromDto(modelFieldDto, modelMapDto, tableName);
                columnInfoDtoList.add(columnInfoDto);
            }
            modelMapDto.getModelFieldDtoMap().put(tableName + modelFieldDto.getFieldName(), modelFieldDto);
        }
        return columnInfoDtoList;
    }

    public static List<ColumnInfoDto> getDelColumnInfosFromDto(List<ModelFieldDto> fieldDtoList, ModelMapDto modelMapDto, String tableName) {
        ArrayList<ColumnInfoDto> columnInfoDtoList = new ArrayList<ColumnInfoDto>();
        for (ModelFieldDto modelFieldDto : fieldDtoList) {
            if (!ModelOperationTypeEnum.isDelete((String)modelFieldDto.getOperationType())) continue;
            ColumnInfoDto columnInfoDto = ModelParamAssembler.getColumnInfoFromDto(modelFieldDto, modelMapDto, tableName);
            columnInfoDtoList.add(columnInfoDto);
        }
        return columnInfoDtoList;
    }

    public static ColumnInfoDto getColumnInfoFromDto(ModelFieldDto modelFieldDto, ModelMapDto modelMapDto, String tableName) {
        ColumnInfoDto columnInfoDto = new ColumnInfoDto();
        columnInfoDto.setColumnId(ModelParamAssembler.getColumnId(modelFieldDto, modelMapDto, tableName));
        columnInfoDto.setColumnAlias(modelFieldDto.getFieldName());
        columnInfoDto.setColumnName(modelFieldDto.getFieldName());
        columnInfoDto.setColumnComment(modelFieldDto.getFieldComment());
        columnInfoDto.setDataIsEmpty(modelFieldDto.getDataIsEmpty());
        columnInfoDto.setDataLength(modelFieldDto.getDataLength());
        columnInfoDto.setDataType(modelFieldDto.getDataType());
        columnInfoDto.setDefaultValue(modelFieldDto.getDefaultValue());
        columnInfoDto.setJavaType(modelFieldDto.getJavaType());
        columnInfoDto.setJdbcType(modelFieldDto.getJdbcType());
        columnInfoDto.setNeedChangeIsRequired(modelFieldDto.isNeedChangeIsRequired());
        columnInfoDto.setOperation(ModelOperationTypeEnum.getOperationByValue((String)modelFieldDto.getOperationType()));
        columnInfoDto.setSyncToTable(modelFieldDto.isSyncToTable());
        columnInfoDto.setPurpose(modelFieldDto.getPurpose());
        if (PRIMARY.equals(modelFieldDto.getPurpose())) {
            columnInfoDto.setPk("1");
            columnInfoDto.setPrimarys("1");
        } else {
            columnInfoDto.setPk(ROOT_PARENT_ID);
        }
        columnInfoDto.setRequired(modelFieldDto.getRequired());
        return columnInfoDto;
    }

    public static List<MetadataColumn> getMetadataColumnsFromDto(List<ModelFieldDto> fieldDtoList, ModelMapDto modelMapDto, String tableName) {
        ArrayList<MetadataColumn> metadataColumnList = new ArrayList<MetadataColumn>();
        for (ModelFieldDto modelFieldDto : fieldDtoList) {
            MetadataColumn metadataColumn = new MetadataColumn();
            metadataColumn.setColumnId(ModelParamAssembler.getColumnId(modelFieldDto, modelMapDto, tableName));
            metadataColumn.setColumnAlias(modelFieldDto.getFieldName());
            metadataColumn.setColumnName(modelFieldDto.getFieldName());
            metadataColumn.setColumnComment(modelFieldDto.getFieldComment());
            metadataColumn.setDataIsEmpty(modelFieldDto.getDataIsEmpty());
            metadataColumn.setDataLength(modelFieldDto.getDataLength());
            metadataColumn.setDataType(modelFieldDto.getDataType());
            metadataColumn.setDefaultValue(modelFieldDto.getDefaultValue());
            metadataColumn.setJavaType(modelFieldDto.getJavaType());
            metadataColumn.setJdbcType(modelFieldDto.getJdbcType());
            metadataColumn.setPurpose(modelFieldDto.getPurpose());
            if (PRIMARY.equals(modelFieldDto.getPurpose())) {
                metadataColumn.setPrimarys("1");
            }
            metadataColumnList.add(metadataColumn);
        }
        return metadataColumnList;
    }

    public static List<ModelColumns> getModelColumnsFromDto(List<ModelFieldDto> fieldDtoList, String tfModelId, ModelMapDto modelMapDto, String tableName) {
        ArrayList<ModelColumns> modelColumnsList = new ArrayList<ModelColumns>();
        for (ModelFieldDto modelFieldDto : fieldDtoList) {
            if (ModelOperationTypeEnum.isDelete((String)modelFieldDto.getOperationType())) continue;
            ModelColumns modelColumns = new ModelColumns();
            modelColumns.setColumnAlias(HussarUtils.isNotEmpty((Object)modelFieldDto.getFieldAlias()) ? modelFieldDto.getFieldAlias() : modelFieldDto.getFieldName());
            modelColumns.setColumnName(modelFieldDto.getFieldName());
            modelColumns.setTfmodelColumnId(modelFieldDto.getFieldName());
            modelColumns.setColumnId(ModelParamAssembler.getColumnId(modelFieldDto, modelMapDto, tableName));
            modelColumns.setTfmodelId(tfModelId);
            modelColumnsList.add(modelColumns);
        }
        return modelColumnsList;
    }

    public static List<IndexInfoDto> getIndexInfoFromDto(List<ModelIndexDto> modelIndexDtoList) {
        ArrayList<IndexInfoDto> indexInfoDtoList = new ArrayList<IndexInfoDto>();
        if (HussarUtils.isEmpty(modelIndexDtoList)) {
            return indexInfoDtoList;
        }
        for (ModelIndexDto modelIndexDto : modelIndexDtoList) {
            if (ModelOperationTypeEnum.isDelete((String)modelIndexDto.getOperationType())) continue;
            IndexInfoDto indexInfoDto = ModelParamAssembler.getIndexInfoFromDto(modelIndexDto);
            indexInfoDtoList.add(indexInfoDto);
        }
        return indexInfoDtoList;
    }

    public static List<IndexInfoDto> getDelIndexInfoFromDto(List<ModelIndexDto> modelIndexDtoList) {
        ArrayList<IndexInfoDto> indexInfoDtoList = new ArrayList<IndexInfoDto>();
        if (HussarUtils.isEmpty(modelIndexDtoList)) {
            return indexInfoDtoList;
        }
        for (ModelIndexDto modelIndexDto : modelIndexDtoList) {
            if (!ModelOperationTypeEnum.isDelete((String)modelIndexDto.getOperationType())) continue;
            IndexInfoDto indexInfoDto = ModelParamAssembler.getIndexInfoFromDto(modelIndexDto);
            indexInfoDtoList.add(indexInfoDto);
        }
        return indexInfoDtoList;
    }

    public static IndexInfoDto getIndexInfoFromDto(ModelIndexDto modelIndexDto) {
        IndexInfoDto indexInfoDto = new IndexInfoDto();
        indexInfoDto.setIndexName(modelIndexDto.getIndexName());
        indexInfoDto.setIndexColumns(modelIndexDto.getIndexField());
        indexInfoDto.setIndexComment(modelIndexDto.getIndexComment());
        indexInfoDto.setIndexType(modelIndexDto.getIndexType());
        indexInfoDto.setUnique(modelIndexDto.isUnique());
        return indexInfoDto;
    }

    public static List<ModelPublishDTO> getModelPublishDtosFromDtos(List<ModelInfoDto> saveModelList, ModelMapDto modelMapDto) {
        ArrayList<ModelPublishDTO> publishDTOList = new ArrayList<ModelPublishDTO>();
        ModelParamAssembler.addModelsToPublishDto(publishDTOList, saveModelList, ROOT_PARENT_ID, modelMapDto);
        return publishDTOList;
    }

    public static void addModelsToPublishDto(List<ModelPublishDTO> publishDTOList, List<ModelInfoDto> saveModelList, String parentId, ModelMapDto modelMapDto) {
        for (ModelInfoDto modelInfoDto : saveModelList) {
            if (ModelOperationTypeEnum.isDelete((String)modelInfoDto.getOperationType())) continue;
            ModelPublishDTO publishDTO = new ModelPublishDTO();
            publishDTO.setModelColumns(ModelParamAssembler.getModelColumnsFromDto(modelInfoDto.getFieldList(), modelInfoDto.getModelId(), modelMapDto, modelInfoDto.getTableName()));
            publishDTO.setParamName(modelInfoDto.getModelName());
            publishDTO.setParentPath(parentId);
            publishDTO.setRelatedId(ModelParamAssembler.getRelatedId(modelInfoDto.getModelId(), modelMapDto));
            publishDTO.setTableId(ModelParamAssembler.getTableId(modelInfoDto, modelMapDto));
            publishDTO.setTfmodelId(modelInfoDto.getModelId());
            publishDTO.setTfmodelName(modelInfoDto.getModelName());
            publishDTO.setType(modelInfoDto.getType());
            publishDTO.setOns(ModelParamAssembler.getRelationshipOn(modelInfoDto, modelMapDto));
            publishDTO.setModelColumnsRules(ModelParamAssembler.getColumnRulesFromFieldDto(modelInfoDto.getFieldList(), modelInfoDto.getModelId(), modelMapDto));
            publishDTO.setRelation(modelInfoDto.getRelation());
            publishDTOList.add(publishDTO);
            if (!HussarUtils.isNotEmpty((Object)modelInfoDto.getChildren())) continue;
            ModelParamAssembler.addModelsToPublishDto(publishDTOList, modelInfoDto.getChildren(), parentId + SPLIT_STR + publishDTO.getRelatedId(), modelMapDto);
        }
    }

    public static List<ModelColumnsRules> getColumnRulesFromFieldDto(List<ModelFieldDto> modelFieldDtoList, String tfModelId, ModelMapDto modelMapDto) {
        ArrayList<ModelColumnsRules> modelColumnsRulesList = new ArrayList<ModelColumnsRules>();
        for (ModelFieldDto modelFieldDto : modelFieldDtoList) {
            List modelFieldRulesDtoList = modelFieldDto.getFieldRules();
            if (!HussarUtils.isNotEmpty((Object)modelFieldRulesDtoList)) continue;
            for (ModelFieldRulesDto modelFieldRulesDto : modelFieldRulesDtoList) {
                ModelColumnsRules modelColumnsRule = new ModelColumnsRules();
                if (RULE_TYPE_SUMMARY.equals(modelFieldRulesDto.getRuleType())) {
                    modelColumnsRule.setColumnAlias("");
                } else {
                    modelColumnsRule.setColumnAlias(modelFieldDto.getFieldName());
                }
                modelColumnsRule.setRuleContent(modelFieldRulesDto.getRuleContent());
                modelColumnsRule.setRuleType(modelFieldRulesDto.getRuleType());
                modelColumnsRulesList.add(modelColumnsRule);
                if (!RULE_TYPE_TITLE.equals(modelFieldRulesDto.getRuleType()) || ModelOperationTypeEnum.NONE_OPERATE.getValue().equals(modelFieldRulesDto.getOperationType())) continue;
                modelMapDto.getUpdateTitleMap().put(tfModelId, true);
            }
        }
        return modelColumnsRulesList;
    }

    public static Long getTableId(ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        Long tableId = (Long)modelMapDto.getTableIdMap().get(modelInfoDto.getTableName());
        if (HussarUtils.isEmpty((Object)tableId)) {
            tableId = EngineUtil.getId();
            modelMapDto.getTableIdMap().put(modelInfoDto.getTableName(), tableId);
        }
        return tableId;
    }

    public static Long getColumnId(ModelFieldDto modelFieldDto, ModelMapDto modelMapDto, String tableName) {
        String key = tableName + modelFieldDto.getFieldName();
        Long columnId = (Long)modelMapDto.getColumnIdMap().get(key);
        if (HussarUtils.isEmpty((Object)columnId)) {
            columnId = EngineUtil.getId();
            modelMapDto.getColumnIdMap().put(key, columnId);
        }
        return columnId;
    }

    public static Long getRelatedId(String tfModelId, ModelMapDto modelMapDto) {
        Long relatedId = (Long)modelMapDto.getModelRelationIdMap().get(tfModelId);
        if (HussarUtils.isEmpty((Object)relatedId)) {
            relatedId = EngineUtil.getId();
            modelMapDto.getModelRelationIdMap().put(tfModelId, relatedId);
        }
        return relatedId;
    }

    public static void addOnsFromDto(ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        List children = modelInfoDto.getChildren();
        if (HussarUtils.isEmpty((Object)children)) {
            return;
        }
        List fieldDtoList = modelInfoDto.getFieldList();
        for (ModelFieldDto fieldDto : fieldDtoList) {
            if (ModelDefaultFieldEnum.BPM_FOREIGN_KEY.getFieldName().equals(fieldDto.getFieldName()) && (modelInfoDto.getModelName().toLowerCase().startsWith(PROCESS_TASK_INFO) || modelInfoDto.getModelName().toLowerCase().startsWith(TASK))) {
                Long fieldId = (Long)modelMapDto.getColumnIdMap().get(modelInfoDto.getTableName() + fieldDto.getFieldName());
                if (!HussarUtils.isNotEmpty((Object)fieldId)) break;
                for (ModelInfoDto child : children) {
                    ModelParamAssembler.addOnsFromDto(child, modelMapDto, fieldId, null);
                }
            } else {
                if (!ModelDefaultFieldEnum.PRIMARY_KEY.getFieldName().equals(fieldDto.getFieldName())) continue;
                Long fieldId = (Long)modelMapDto.getColumnIdMap().get(modelInfoDto.getTableName() + fieldDto.getFieldName());
                if (!HussarUtils.isNotEmpty((Object)fieldId)) break;
                for (ModelInfoDto child : children) {
                    ModelParamAssembler.addOnsFromDto(child, modelMapDto, null, fieldId);
                }
            }
            break;
        }
    }

    private static void addOnsBySQLModel(ModelInfoDto child, ModelMapDto modelMapDto) {
        JoinInfoDto joinInfo = child.getJoinInfo();
        Long leftColumnId = (Long)modelMapDto.getColumnIdMap().get(joinInfo.getLeftTableName() + joinInfo.getLeftColumnName());
        Long rightColumnId = (Long)modelMapDto.getColumnIdMap().get(joinInfo.getRightTableName() + joinInfo.getRightColumnName());
        modelMapDto.getOnsMap().put(child.getModelId(), Pair.of((Object)leftColumnId, (Object)rightColumnId));
        if (HussarUtils.isNotEmpty((Object)child.getChildren())) {
            for (ModelInfoDto childChild : child.getChildren()) {
                ModelParamAssembler.addOnsBySQLModel(childChild, modelMapDto);
            }
        }
    }

    public static void addOnsFromDto(ModelInfoDto modelInfoDto, ModelMapDto modelMapDto, Long businessId, Long recordId) {
        if (ModelOperationTypeEnum.isDelete((String)modelInfoDto.getOperationType())) {
            return;
        }
        ModelFieldDto keyField = modelInfoDto.getFieldByPurpose(PurposeEnum.PRIMARY);
        Long fieldId = (Long)modelMapDto.getColumnIdMap().get(modelInfoDto.getTableName() + keyField.getFieldName());
        if (HussarUtils.isNotEmpty((Object)businessId)) {
            modelMapDto.getOnsMap().put(modelInfoDto.getModelId(), Pair.of((Object)businessId, (Object)fieldId));
        } else {
            ModelFieldDto foreignField = modelInfoDto.getFieldByPurpose(PurposeEnum.FOREIGN);
            Long foreignFieldId = (Long)modelMapDto.getColumnIdMap().get(modelInfoDto.getTableName() + foreignField.getFieldName());
            if (HussarUtils.isNotEmpty((Object)foreignFieldId) && HussarUtils.isNotEmpty((Object)recordId)) {
                modelMapDto.getOnsMap().put(modelInfoDto.getModelId(), Pair.of((Object)recordId, (Object)foreignFieldId));
            }
        }
        List children = modelInfoDto.getChildren();
        if (HussarUtils.isNotEmpty((Object)fieldId) && HussarUtils.isNotEmpty((Object)children)) {
            for (ModelInfoDto child : children) {
                ModelParamAssembler.addOnsFromDto(child, modelMapDto, null, fieldId);
            }
        }
    }

    public static List<RelationshipOn> getRelationshipOn(ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        ArrayList<RelationshipOn> relationshipOnList = new ArrayList<RelationshipOn>();
        Pair pair = (Pair)modelMapDto.getOnsMap().get(modelInfoDto.getModelId());
        if (HussarUtils.isNotEmpty((Object)pair)) {
            RelationshipOn relationshipOn = new RelationshipOn();
            relationshipOn.setLeftColumnId((Long)pair.getKey());
            relationshipOn.setOperatorType(OperatorType.EQ);
            relationshipOn.setRightColumnId((Long)pair.getValue());
            relationshipOnList.add(relationshipOn);
        }
        return relationshipOnList;
    }
}

