/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.impl;

import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IModelResultMapService;
import com.jxdinfo.hussar.support.engine.plugin.model.util.ModelResultMapUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ModelResultMapServiceImpl
implements IModelResultMapService {
    private static final Logger logger = LoggerFactory.getLogger(ModelResultMapServiceImpl.class);
    @Resource
    public SqlSessionFactory sqlSessionFactory;
    @Resource
    public HussarMetadataService metadataService;

    @Override
    public void createResultMap(ModelTableMappingDTO modelTableMapping) {
        try {
            Boolean havJoin = HussarUtils.isNotEmpty((Object)modelTableMapping.getSlaveTables());
            if (!havJoin.booleanValue()) {
                this.generateSingleTableResultMappings(modelTableMapping, true);
            } else {
                String msResultMapId = String.format("ms.%s", modelTableMapping.getRelatedId());
                List<ResultMapping> resultMappings = this.generateMsTableResultMappings(modelTableMapping, true);
                ResultMap msResultMap = ModelResultMapUtil.getResultMap(msResultMapId, resultMappings, this.getConfiguration());
                this.metadataService.addResultMap(this.getConfiguration(), msResultMap);
            }
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u6a21\u578b\u548c\u8868\u6620\u5c04\u5173\u7cfb\u751f\u6210resultMap\u5931\u8d25, tableId = {}, modelId = {}, \u5f02\u5e38\u4fe1\u606fe: {}", new Object[]{modelTableMapping.getTableId(), modelTableMapping.getRelatedId(), e});
            e.printStackTrace();
        }
    }

    @Override
    public void cleanResultMap(ModelTableMappingDTO modelTableMapping) {
        Boolean havJoin = HussarUtils.isNotEmpty((Object)modelTableMapping.getSlaveTables());
        if (!havJoin.booleanValue()) {
            this.cleanSingleTableResultMap(modelTableMapping);
        } else {
            this.cleanMsTableResultMap(modelTableMapping);
        }
    }

    private List<ResultMapping> generateMsTableResultMappings(ModelTableMappingDTO table, Boolean isMasterTable) throws ClassNotFoundException {
        List<ResultMapping> resultMappings = this.generateSingleTableResultMappings(table, isMasterTable);
        if (HussarUtils.isEmpty((Object)table.getSlaveTables())) {
            return resultMappings;
        }
        block4: for (ModelTableMappingDTO slave : table.getSlaveTables()) {
            ModelRelation relation = slave.getRelation() == null ? ModelRelation.ONE_ONE : slave.getRelation();
            switch (relation) {
                case ONE_ONE: {
                    List<ResultMapping> slaveResultMappings = this.generateMsTableResultMappings(slave, false);
                    resultMappings.addAll(slaveResultMappings);
                    continue block4;
                }
                case ONE_N: {
                    String tableType = HussarUtils.isEmpty((Object)slave.getSlaveTables()) ? "single" : "ms";
                    StringBuilder prefix = new StringBuilder().append(tableType).append(".%s");
                    String salveResultMapId = String.format(prefix.toString(), slave.getRelatedId());
                    HussarException.throwBy((boolean)HussarUtils.isBlank((CharSequence)slave.getParamName()), (String)"\u4e3b\u5b50\u4e00\u5bf9\u591a\u5173\u8054\u67e5\u8be2\uff0c\u5173\u8054\u5217\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                    resultMappings.add(new ResultMapping.Builder(this.getConfiguration(), slave.getParamName(), null, List.class).nestedResultMapId(salveResultMapId).build());
                    this.createResultMap(slave);
                    continue block4;
                }
            }
            throw new HussarException("\u975e\u6cd5\u7684\u4e3b\u5b50\u5173\u7cfb, relation = " + relation.getValue());
        }
        return resultMappings;
    }

    private List<ResultMapping> generateSingleTableResultMappings(ModelTableMappingDTO singleTable, Boolean isMasterTable) throws ClassNotFoundException {
        List<ResultMapping> resultMappings = ModelResultMapUtil.getResultMappings(singleTable, isMasterTable, this.getConfiguration());
        String singleResultMapId = String.format("single.%s", singleTable.getRelatedId());
        ResultMap singleResultMap = ModelResultMapUtil.getResultMap(singleResultMapId, resultMappings, this.getConfiguration());
        this.metadataService.addResultMap(this.getConfiguration(), singleResultMap);
        return resultMappings;
    }

    private Configuration getConfiguration() {
        return this.sqlSessionFactory.getConfiguration();
    }

    private void cleanSingleTableResultMap(ModelTableMappingDTO singleTable) {
        String singleResultMapId = String.format("single.%s", singleTable.getRelatedId());
        this.metadataService.cleanResultMap(singleResultMapId);
    }

    private void cleanMsTableResultMap(ModelTableMappingDTO table) {
        String msResultMapId = String.format("ms.%s", table.getRelatedId());
        this.metadataService.cleanResultMap(msResultMapId);
        if (HussarUtils.isEmpty((Object)table.getSlaveTables())) {
            return;
        }
        block3: for (ModelTableMappingDTO slave : table.getSlaveTables()) {
            ModelRelation relation = slave.getRelation() == null ? ModelRelation.ONE_ONE : slave.getRelation();
            switch (relation) {
                case ONE_ONE: 
                case ONE_N: {
                    this.cleanResultMap(slave);
                    continue block3;
                }
            }
            throw new HussarException("\u975e\u6cd5\u7684\u4e3b\u5b50\u5173\u7cfb, relation = " + relation.getValue());
        }
    }
}

