/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipJoin;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipOn;
import com.jxdinfo.hussar.support.engine.api.enums.JoinTypeEnum;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipJoinDto;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.dao.RelationshipJoinMapper;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.TableRelation;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipJoinService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.RelationshipOnService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RelationshipJoinServiceImpl
extends HussarServiceImpl<RelationshipJoinMapper, RelationshipJoin>
implements RelationshipJoinService {
    @Autowired
    private MetadataTableService metadataTableService;
    @Autowired
    private RelationshipOnService relationshipOnService;

    @Override
    public List<RelationshipJoinDto> getRelationJoins(List<TableRelation> tableRelations) {
        boolean saveNewJoin = false;
        if (HussarUtils.isEmpty(tableRelations)) {
            return new ArrayList<RelationshipJoinDto>();
        }
        List slaveModelIds = tableRelations.stream().map(TableRelation::getRightModelId).collect(Collectors.toList());
        List joinList = this.list((Wrapper)Wrappers.lambdaQuery(RelationshipJoin.class).in(RelationshipJoin::getModelId, slaveModelIds));
        if (joinList.isEmpty()) {
            List<RelationshipJoin> relationJoins = this.getRelationJoins(tableRelations, true);
            block0: for (TableRelation tableRelation : tableRelations) {
                for (RelationshipJoin relationJoin : relationJoins) {
                    if (!HussarUtils.equals((Object)tableRelation.getLeftTableId(), (Object)relationJoin.getLeftTableId()) || !HussarUtils.equals((Object)tableRelation.getRightTableId(), (Object)relationJoin.getRightTableId()) || !HussarUtils.equals((Object)tableRelation.getRelation(), (Object)relationJoin.getRelation())) continue;
                    relationJoin.setModelId(tableRelation.getRightModelId());
                    joinList.add(relationJoin);
                    continue block0;
                }
            }
            if (HussarUtils.isEmpty((Object)joinList)) {
                return new ArrayList<RelationshipJoinDto>();
            }
            saveNewJoin = true;
        }
        HashSet tableIds = new HashSet();
        joinList.forEach(item -> {
            tableIds.add(item.getLeftTableId());
            tableIds.add(item.getRightTableId());
        });
        List metadataTables = this.metadataTableService.listByIds(tableIds);
        Map<Long, MetadataTable> tableId2Table = metadataTables.stream().collect(Collectors.toMap(MetadataTable::getTableId, x -> x));
        List<Long> joinIds = joinList.stream().map(RelationshipJoin::getId).collect(Collectors.toList());
        List<RelationshipOnDto> relationShipOnDtos = this.relationshipOnService.getRelationShipOnDto(joinIds);
        Map<Long, List<RelationshipOnDto>> joinId2OnList = relationShipOnDtos.stream().collect(Collectors.groupingBy(RelationshipOn::getJoinId));
        List results = BeanUtil.copyToList((Collection)joinList, RelationshipJoinDto.class);
        results.forEach(re -> {
            re.setLeftTable((MetadataTable)tableId2Table.get(re.getLeftTableId()));
            re.setRightTable((MetadataTable)tableId2Table.get(re.getRightTableId()));
            re.setOnDtoList((List)joinId2OnList.get(re.getId()));
        });
        if (saveNewJoin && !results.isEmpty()) {
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            for (RelationshipJoin join : joinList) {
                Long joinId = EngineUtil.getId();
                idMap.put(join.getId(), joinId);
                join.setId(joinId);
            }
            for (RelationshipOnDto onDto : relationShipOnDtos) {
                onDto.setId(EngineUtil.getId());
                onDto.setJoinId((Long)idMap.get(onDto.getJoinId()));
            }
            this.saveModelJoin(joinList, new ArrayList<RelationshipOnDto>(relationShipOnDtos), new ArrayList<Long>());
        }
        return results;
    }

    @Override
    public List<RelationshipJoin> getRelationJoins(List<TableRelation> tableRelations, boolean hasRelationCondition) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(RelationshipJoin.class).orderByAsc(HussarBaseEntity::getCreateTime);
        Iterator<TableRelation> iterator = tableRelations.iterator();
        while (iterator.hasNext()) {
            TableRelation tableRelation = iterator.next();
            wrapper.eq(RelationshipJoin::getLeftTableId, (Object)tableRelation.getLeftTableId());
            if (hasRelationCondition) {
                wrapper.eq(RelationshipJoin::getRelation, (Object)tableRelation.getRelation());
            }
            wrapper.or(iterator.hasNext());
        }
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void modelPublishSave(List<ModelPublishDTO> publish, List<Long> oldModelIds) {
        ArrayList<RelationshipJoin> joins = new ArrayList<RelationshipJoin>();
        ArrayList<RelationshipOn> ons = new ArrayList<RelationshipOn>();
        this.list2Relation(publish, joins, ons);
        this.saveModelJoin(joins, ons, oldModelIds);
    }

    private void saveModelJoin(List<RelationshipJoin> joinList, List<RelationshipOn> onList, List<Long> oldModelIds) {
        if (!oldModelIds.isEmpty()) {
            List list = this.list((Wrapper)Wrappers.lambdaQuery(RelationshipJoin.class).select(new SFunction[]{RelationshipJoin::getId}).in(RelationshipJoin::getModelId, oldModelIds));
            List<Long> joinId = list.stream().map(RelationshipJoin::getId).collect(Collectors.toList());
            this.removeByIds(joinId);
            if (!joinId.isEmpty()) {
                this.relationshipOnService.removeByJoinIds(joinId);
            }
        }
        this.saveBatch(joinList);
        this.relationshipOnService.saveBatch(onList);
    }

    @Override
    public void drop(List<TableRelation> dropTableRelations, ToIntFunction<TableRelation> countRef) {
        if (HussarUtils.isEmpty(dropTableRelations)) {
            return;
        }
        dropTableRelations.forEach(tableRelation -> {
            int ref = countRef.applyAsInt((TableRelation)tableRelation);
            if (ref == 0) {
                List list;
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelationshipJoin.class).eq(RelationshipJoin::getLeftTableId, (Object)tableRelation.getLeftTableId())).eq(RelationshipJoin::getRightTableId, (Object)tableRelation.getRightTableId());
                if (tableRelation.getRelation() != null) {
                    wrapper.eq(RelationshipJoin::getRelation, (Object)tableRelation.getRelation());
                }
                if (HussarUtils.isNotEmpty((Object)(list = this.list((Wrapper)wrapper)))) {
                    List<Long> ids = list.stream().map(RelationshipJoin::getId).collect(Collectors.toList());
                    this.removeByIds(ids);
                    this.relationshipOnService.removeByJoinIds(ids);
                }
            }
        });
    }

    @Override
    public boolean onEqual(List<RelationshipOn> exits, List<RelationshipOn> news) {
        if (exits.size() != news.size()) {
            return false;
        }
        for (RelationshipOn newItem : news) {
            Optional<RelationshipOn> theExit = exits.stream().filter(exit -> exit.getLeftColumnId().equals(newItem.getLeftColumnId()) && exit.getRightColumnId().equals(newItem.getRightColumnId()) && exit.getOperatorType().equals((Object)newItem.getOperatorType())).findFirst();
            if (theExit.isPresent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void deleteByRelatedIds(List<Long> relatedIds) {
        if (HussarUtils.isEmpty(relatedIds)) {
            return;
        }
        this.remove((Wrapper)Wrappers.lambdaQuery(RelationshipJoin.class).in(RelationshipJoin::getModelId, relatedIds));
    }

    private Optional<RelationshipJoin> getOneByJoins(List<RelationshipJoin> exitJoins, RelationshipJoin condition) {
        Optional<RelationshipJoin> first = exitJoins.stream().filter(x -> x.getLeftTableId().equals(condition.getLeftTableId()) && x.getRightTableId().equals(condition.getRightTableId()) && x.getRelation().equals((Object)condition.getRelation())).findFirst();
        if (!first.isPresent()) {
            return exitJoins.stream().filter(x -> x.getLeftTableId().equals(condition.getLeftTableId()) && x.getRightTableId().equals(condition.getRightTableId())).findFirst();
        }
        return first;
    }

    private void list2Relation(List<ModelPublishDTO> publish, List<RelationshipJoin> joins, List<RelationshipOn> ons) {
        Map<Long, ModelPublishDTO> relatedId2Item = publish.stream().collect(Collectors.toMap(ModelRelationship::getRelatedId, x -> x));
        publish.forEach(x -> {
            if ("0".equals(x.getParentPath())) {
                return;
            }
            ModelPublishDTO parent = (ModelPublishDTO)relatedId2Item.get(x.getParentId());
            RelationshipJoin join = new RelationshipJoin();
            join.setId(EngineUtil.getId());
            join.setRelation(x.getRelation());
            join.setModelId(x.getRelatedId());
            join.setLeftTableId(parent.getTableId());
            join.setRightTableId(x.getTableId());
            join.setJoinType(JoinTypeEnum.LEFT_JOIN);
            joins.add(join);
            for (RelationshipOn on : x.getOns()) {
                on.setJoinId(join.getId());
                on.setId(EngineUtil.getId());
            }
            ons.addAll(x.getOns());
        });
    }
}

