/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.hussar.extend.AbstractHussarDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.model.dataTitle.MetaTitleRule;
import com.jxdinfo.hussar.support.engine.core.model.dataTitle.ModelSerialRule;
import com.jxdinfo.hussar.support.engine.plugin.model.dao.SerialNumMapper;
import com.jxdinfo.hussar.support.engine.plugin.model.factory.CustomExpressionFactory;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ICustomExpressionService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelSerialNumService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ModelSerialNumServiceImpl
implements ModelSerialNumService {
    @Value(value="${hussar.engine.meta.serial.max:10000}")
    private Integer maxMetaSerial;
    private static int batchSerialSize = 50;
    @Autowired
    private SerialNumMapper serialNumMapper;
    @Autowired
    public SqlSessionFactory sqlSessionFactory;
    @Autowired(required=false)
    public ISysCodeRuleService sysCodeRuleService;
    private static Logger LOGGER = LoggerFactory.getLogger(ModelSerialNumService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HussarDs(value="#connName")
    public int batchUpdateSerialNum(String connName, List<ModelColumnDto> modelColumns, ModelColumnsRules rule) {
        if (rule == null || HussarUtils.isBlank((CharSequence)rule.getRuleContent())) {
            return 0;
        }
        DynamicDatasourceService datasourceService = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        DbType dbType = Optional.ofNullable(((ModelColumnDto)modelColumns.stream().findFirst().get()).getPollName()).map(arg_0 -> ((DynamicDatasourceService)datasourceService).getDatasourceByPoolName(arg_0)).map(AbstractHussarDataSource::getDbType).orElse(null);
        ICustomExpressionService customExpressionService = CustomExpressionFactory.getCustomExpression(dbType.getDb());
        ModelSerialRule modelSerialRule = (ModelSerialRule)JSON.parseObject((String)rule.getRuleContent(), ModelSerialRule.class);
        String primaryModel = modelColumns.stream().filter(x -> PurposeEnum.PRIMARY.getValue().equals(x.getPurpose())).findFirst().get().getColumnAlias();
        Map<String, String> model2Col = modelColumns.stream().collect(Collectors.toMap(MetadataColumn::getColumnAlias, MetadataColumn::getColumnName));
        String primaryCol = customExpressionService.buildColumnWithSymbol(model2Col.get(primaryModel));
        ArrayList<String> selectItems = new ArrayList<String>();
        for (ModelColumnDto columnDto : modelColumns) {
            selectItems.add(customExpressionService.buildColumnWithSymbol(columnDto.getColumnName()) + " " + customExpressionService.buildColumnWithSymbol(columnDto.getColumnAlias()));
        }
        String serialCol = modelColumns.stream().filter(x -> x.getColumnAlias().equals(rule.getColumnAlias())).findFirst().get().getColumnName();
        serialCol = customExpressionService.buildColumnWithSymbol(serialCol);
        List<EngineResultEntity> data = this.serialNumMapper.queryListWithNullSerial(StringUtil.join(selectItems), modelColumns.get(0).getTableName(), serialCol, this.maxMetaSerial);
        if (HussarUtils.isEmpty(data)) {
            return 0;
        }
        SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
        String statement = SerialNumMapper.class.getName() + ".updateSerial";
        int size = data.size();
        try {
            for (int i = 0; i < size / batchSerialSize + 1; ++i) {
                List<String> codes;
                int end = Math.min((i + 1) * batchSerialSize, size);
                if (HussarUtils.isNotEmpty((Object)modelSerialRule.getParams())) {
                    List<EngineResultEntity> subList = data.subList(i * batchSerialSize, end);
                    ArrayList<Map<String, Object>> dealParams = new ArrayList<Map<String, Object>>();
                    subList.forEach(param -> dealParams.add(MetaTitleRule.getTitleParam((List)modelSerialRule.getParams(), (Map)param, null)));
                    codes = this.getSerials(dealParams, modelSerialRule.getCode());
                } else {
                    codes = this.getSerials(end - i * batchSerialSize, modelSerialRule.getCode());
                }
                for (int j = i * batchSerialSize; j < end; ++j) {
                    sqlSession.update(statement, (Object)new ColumnUpdate(modelColumns.get(0).getTableName(), serialCol, codes.get(j % batchSerialSize), primaryCol, data.get(j).get((Object)primaryModel)));
                }
            }
            sqlSession.flushStatements();
            sqlSession.commit(true);
        }
        catch (Throwable t) {
            LOGGER.error("batchUpdateSerialNum error", t);
            sqlSession.rollback();
            size = 0;
        }
        finally {
            sqlSession.close();
        }
        return size;
    }

    @Override
    public String getSerialNum(Map<String, Object> param, ModelColumnsRules rule) {
        if (rule == null || HussarUtils.isBlank((CharSequence)rule.getRuleContent())) {
            return null;
        }
        ModelSerialRule modelSerialRule = (ModelSerialRule)JSON.parseObject((String)rule.getRuleContent(), ModelSerialRule.class);
        Map serialParam = MetaTitleRule.getTitleParam((List)modelSerialRule.getParams(), param, null);
        return this.getSerialNum((Map<String, Object>)serialParam, modelSerialRule.getCode());
    }

    public String getSerialNum(Map<String, Object> param, String code) {
        if (param != null) {
            for (String k : param.keySet()) {
                param.putIfAbsent(k, "");
            }
        }
        CodePlusDto codePlusDto = new CodePlusDto();
        codePlusDto.setRuleCode(code);
        codePlusDto.setVariableMap(param);
        String currentCode = this.sysCodeRuleService.getCurrentCode(codePlusDto);
        LOGGER.info("*******serialNum: {}", (Object)currentCode);
        return currentCode;
    }

    private List<String> getSerials(List<Map<String, Object>> params, String code) {
        ArrayList codePlusDtoList = new ArrayList();
        params.forEach(x -> {
            for (String k : x.keySet()) {
                x.putIfAbsent(k, "");
            }
            CodePlusDto codePlusDto = new CodePlusDto();
            codePlusDto.setRuleCode(code);
            codePlusDto.setVariableMap(x);
            codePlusDtoList.add(codePlusDto);
        });
        List batchCurrentCodes = this.sysCodeRuleService.getBatchCurrentCodes(codePlusDtoList);
        LOGGER.info("********serialNum: {}", (Object)batchCurrentCodes);
        return batchCurrentCodes;
    }

    private List<String> getSerials(int size, String code) {
        ArrayList<CodePlusDto> codePlusDtoList = new ArrayList<CodePlusDto>();
        for (int i = 0; i < size; ++i) {
            CodePlusDto codePlusDto = new CodePlusDto();
            codePlusDto.setRuleCode(code);
            codePlusDtoList.add(codePlusDto);
        }
        List batchCurrentCodes = this.sysCodeRuleService.getBatchCurrentCodes(codePlusDtoList);
        LOGGER.info("********serialNum: {}", (Object)batchCurrentCodes);
        return batchCurrentCodes;
    }

    public static class ColumnUpdate {
        private String table;
        private String col;
        private String val;
        private String idCol;
        private Object idValue;

        public ColumnUpdate(String table, String serialCol, String val, String idCol, Object idValue) {
            this.table = table;
            this.col = serialCol;
            this.val = val;
            this.idCol = idCol;
            this.idValue = idValue;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getCol() {
            return this.col;
        }

        public void setCol(String col) {
            this.col = col;
        }

        public String getVal() {
            return this.val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getIdCol() {
            return this.idCol;
        }

        public void setIdCol(String idCol) {
            this.idCol = idCol;
        }

        public Object getIdValue() {
            return this.idValue;
        }

        public void setIdValue(Object idValue) {
            this.idValue = idValue;
        }
    }
}

