/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.assembler;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipJoinDto;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.ModelStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ModelTableAssembler {
    private ModelTableAssembler() {
    }

    public static ModelTableMappingDTO toModelTableMappingDTO(Long masterTableId, List<RelationshipJoinDto> relationJoins) {
        List<RelationshipJoinDto> rootJoins = ModelTableAssembler.findJoinsByLeftId(masterTableId, relationJoins, false);
        if (HussarUtils.isNotEmpty(rootJoins)) {
            ModelTableMappingDTO root = ModelTableMappingDTO.create((MetadataTable)(rootJoins.get(0).getLeftTableId().equals(masterTableId) ? rootJoins.get(0).getLeftTable() : rootJoins.get(0).getRightTable()), null);
            root.addSlaveTables(ModelTableAssembler.buildMs(root.getTableId(), relationJoins));
            return root;
        }
        return null;
    }

    public static ModelStructure toModelStructure(Map<String, List<ModelRelationship>> relationshipMap, List<ModelColumns> modelColumns) {
        return ModelTableAssembler.buildMs(relationshipMap.get("master").get(0), relationshipMap.get("ms"), modelColumns);
    }

    private static List<ModelTableMappingDTO> buildMs(long parentTableId, List<RelationshipJoinDto> joinList) {
        List<RelationshipJoinDto> joinsUnder = ModelTableAssembler.findJoinsByLeftId(parentTableId, joinList);
        if (HussarUtils.isEmpty(joinsUnder)) {
            return null;
        }
        ArrayList<ModelTableMappingDTO> results = new ArrayList<ModelTableMappingDTO>();
        joinsUnder.forEach(join -> results.add(ModelTableMappingDTO.create((MetadataTable)(join.getLeftTableId().equals(parentTableId) ? join.getRightTable() : join.getLeftTable()), (RelationshipJoinDto)join)));
        results.forEach(right -> right.addSlaveTables(ModelTableAssembler.buildMs(right.getTableId(), joinList)));
        return results;
    }

    private static List<RelationshipJoinDto> findJoinsByLeftId(Long tableId, List<RelationshipJoinDto> joinList) {
        return ModelTableAssembler.findJoinsByLeftId(tableId, joinList, true);
    }

    private static List<RelationshipJoinDto> findJoinsByLeftId(Long tableId, List<RelationshipJoinDto> joinList, boolean delete) {
        if (HussarUtils.isEmpty(joinList)) {
            return new ArrayList<RelationshipJoinDto>();
        }
        Predicate<RelationshipJoinDto> predicate = x -> x.getLeftTableId().equals(tableId);
        List<RelationshipJoinDto> leftTables = joinList.stream().filter(predicate).collect(Collectors.toList());
        if (delete) {
            joinList.removeIf(predicate);
        }
        return leftTables;
    }

    private static ModelStructure buildMs(ModelRelationship theShip, List<ModelRelationship> relationships, List<ModelColumns> modelColumns) {
        ModelStructure result = ModelStructure.create(theShip);
        result.setColumns(modelColumns.stream().filter(x -> result.getRelatedId().equals(x.getRelatedId())).collect(Collectors.toList()));
        List<ModelRelationship> subJoins = ModelTableAssembler.findRelationsByParentId(result.getRelatedId(), relationships);
        if (HussarUtils.isEmpty(subJoins)) {
            return result;
        }
        subJoins.forEach(join -> result.addChildren(ModelTableAssembler.buildMs(join, relationships, modelColumns)));
        return result;
    }

    private static List<ModelRelationship> findRelationsByParentId(Long parentId, List<ModelRelationship> relationships) {
        if (HussarUtils.isEmpty(relationships)) {
            return new ArrayList<ModelRelationship>();
        }
        Predicate<ModelRelationship> predicate = x -> x.getParentId().equals(parentId);
        List<ModelRelationship> relationsUnder = relationships.stream().filter(predicate).collect(Collectors.toList());
        relationships.removeIf(predicate);
        return relationsUnder;
    }
}

