/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.factory;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.enums.ModelSourceEnum;
import com.jxdinfo.hussar.support.engine.plugin.model.application.action.assemble.ModelAssembleAction;
import com.jxdinfo.hussar.support.engine.plugin.model.application.action.operate.ModelOperateAction;
import com.jxdinfo.hussar.support.engine.plugin.model.application.action.source.ModelSourceAction;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.HashMap;
import java.util.Map;

public class ModelSaveFactory {
    private static final Map<String, ModelSourceAction> sourceMap = new HashMap<String, ModelSourceAction>();
    private static final Map<String, ModelOperateAction> operateMap = new HashMap<String, ModelOperateAction>();
    private static final Map<String, ModelAssembleAction> assembleMap = new HashMap<String, ModelAssembleAction>();

    public static void addSourceAction(String source, ModelSourceAction action) {
        sourceMap.put(source, action);
    }

    public static void addOperateAction(String operate, ModelOperateAction action) {
        operateMap.put(operate, action);
    }

    public static void addAssembleAction(String type, ModelAssembleAction action) {
        assembleMap.put(type, action);
    }

    public static ModelSourceAction getActionBySource(String source) {
        if (HussarUtils.isEmpty((Object)source)) {
            return sourceMap.get(ModelSourceEnum.NORMAL_OR_BPM.getValue());
        }
        ModelSourceAction action = sourceMap.get(source);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)action), (String)"\u672a\u77e5\u7684\u6765\u6e90");
        return action;
    }

    public static ModelOperateAction getActionByOperate(String operate) {
        ModelOperateAction action = operateMap.get(operate);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)action), (String)"\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
        return action;
    }

    public static ModelAssembleAction getActionByType(String type) {
        ModelAssembleAction action = assembleMap.get(type);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)action), (String)"\u672a\u77e5\u7684\u6a21\u578b\u7c7b\u578b");
        return action;
    }
}

