/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.hussar.extend.AbstractHussarDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.model.dataTitle.MetaTitleRule;
import com.jxdinfo.hussar.support.engine.plugin.model.dao.TitleMapper;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.MetaTitleModel;
import com.jxdinfo.hussar.support.engine.plugin.model.factory.CustomExpressionFactory;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ICustomExpressionService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelSerialNumService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelTitleService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.impl.ModelSerialNumServiceImpl;
import com.jxdinfo.hussar.support.engine.plugin.model.util.ModelResultMapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ModelTitleServiceImpl
implements ModelTitleService {
    @Value(value="${hussar.engine.meta.title.max:100000}")
    private Integer maxMetaTitle;
    private static int batchTitleSize = 10000;
    @Autowired
    private TitleMapper titleMapper;
    @Autowired
    public SqlSessionFactory sqlSessionFactory;
    private static Logger LOGGER = LoggerFactory.getLogger(ModelSerialNumService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HussarDs(value="#connName")
    public int updateAllTitle(String connName, ModelTableMappingDTO model, ModelColumnsRules rule) throws InterruptedException {
        if (rule == null) {
            return 0;
        }
        String template = MetaTitleRule.parse((String)rule.getRuleContent(), (String)model.getTfModelId());
        if (HussarUtils.isBlank((CharSequence)template)) {
            return 0;
        }
        DynamicDatasourceService datasourceService = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        DbType dbType = Optional.ofNullable(model.getPollName()).map(arg_0 -> ((DynamicDatasourceService)datasourceService).getDatasourceByPoolName(arg_0)).map(AbstractHussarDataSource::getDbType).orElse(null);
        ICustomExpressionService customExpressionService = CustomExpressionFactory.getCustomExpression(dbType.getDb());
        MetaTitleRule metaTitleRule = (MetaTitleRule)JSON.parseObject((String)rule.getRuleContent(), MetaTitleRule.class);
        List modelColumns = model.getColumns();
        String primaryModel = modelColumns.stream().filter(x -> PurposeEnum.PRIMARY.getValue().equals(x.getPurpose())).findFirst().get().getColumnAlias();
        String formIdColumn = modelColumns.stream().filter(x -> PurposeEnum.FORM_ID.getValue().equals(x.getPurpose())).findFirst().get().getColumnName();
        Map<String, String> model2Col = modelColumns.stream().collect(Collectors.toMap(MetadataColumn::getColumnAlias, MetadataColumn::getColumnName));
        String primaryCol = customExpressionService.buildColumnWithSymbol(model2Col.get(primaryModel));
        String formIdCol = customExpressionService.buildColumnWithSymbol(formIdColumn);
        ArrayList<String> selectItems = new ArrayList<String>();
        for (ModelColumnDto columnDto : modelColumns) {
            String columnName = customExpressionService.buildColumnWithSymbol(columnDto.getColumnName());
            selectItems.add(columnName + " " + customExpressionService.buildColumnWithSymbol(columnDto.getColumnAlias()));
        }
        String titleCol = modelColumns.stream().filter(x -> x.getColumnAlias().equals(rule.getColumnAlias())).findFirst().get().getColumnName();
        titleCol = customExpressionService.buildColumnWithSymbol(titleCol);
        SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
        String statement = TitleMapper.class.getName() + ".updateTitleById";
        int size = 0;
        try {
            List<EngineResultEntity> data = this.titleMapper.queryListByFormId(StringUtil.join(selectItems), ((ModelColumnDto)modelColumns.get(0)).getTableName(), formIdCol, model.getTfModelId());
            if (HussarUtils.isEmpty(data)) {
                int n = 0;
                return n;
            }
            for (int i = 0; i < this.maxMetaTitle / batchTitleSize + 1; ++i) {
                int end = Math.min((i + 1) * batchTitleSize, this.maxMetaTitle);
                List<EngineResultEntity> entities = ModelResultMapUtil.limit(data, i * batchTitleSize, end);
                size += entities.size();
                for (EngineResultEntity item : entities) {
                    sqlSession.update(statement, (Object)new ModelSerialNumServiceImpl.ColumnUpdate(((ModelColumnDto)modelColumns.get(0)).getTableName(), titleCol, MetaTitleRule.titleFormat((String)template, (MetaTitleRule)metaTitleRule, (Map)item, null), primaryCol, item.get((Object)primaryModel)));
                }
                sqlSession.commit(true);
                Thread.sleep(0L);
            }
        }
        finally {
            sqlSession.close();
        }
        return size;
    }

    private boolean bothEqual(Optional<ModelColumnsRules> newTitleOp, Optional<ModelColumnsRules> oldTitleOp) {
        if (newTitleOp.isPresent() && oldTitleOp.isPresent()) {
            return HussarUtils.equals((Object)newTitleOp.get().getRuleContent(), (Object)oldTitleOp.get().getRuleContent());
        }
        return !newTitleOp.isPresent() && !oldTitleOp.isPresent();
    }

    private static String rule2ConcatWsSql(String rule, List<ModelColumns> newColumns) {
        String concat = ModelTitleServiceImpl.rule2ConcatSql(rule, newColumns);
        if (HussarUtils.isBlank((CharSequence)concat)) {
            return concat;
        }
        return "'', " + concat;
    }

    private static String rule2ConcatSql(String rule, List<ModelColumns> newColumns) {
        if (HussarUtils.isBlank((CharSequence)rule)) {
            return null;
        }
        List names = newColumns.stream().map(ModelColumns::getColumnName).collect(Collectors.toList());
        ArrayList<Integer> ins = new ArrayList<Integer>();
        for (String colName : names) {
            int in = rule.indexOf("${" + colName + "}");
            if (in == -1) continue;
            for (int i = in; i < in + colName.length() + 3; ++i) {
                ins.add(i);
            }
        }
        StringBuilder seg = new StringBuilder();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < rule.length(); ++i) {
            if (ins.contains(i)) {
                if (seg.length() > 0) {
                    seg.append("',");
                    res.append((CharSequence)seg);
                    seg.delete(0, seg.length());
                } else if (rule.charAt(i) == '$' && res.length() > 0) {
                    res.append(",");
                }
                if (rule.charAt(i) == '$' || rule.charAt(i) == '{' || rule.charAt(i) == '}') continue;
                res.append(rule.charAt(i));
                continue;
            }
            if (seg.length() > 0) {
                seg.append(rule.charAt(i));
                continue;
            }
            if (res.length() > 0) {
                seg.append(",'").append(rule.charAt(i));
                continue;
            }
            seg.append("'").append(rule.charAt(i));
        }
        if (seg.length() > 0) {
            res.append((CharSequence)seg).append("'");
        }
        return res.toString();
    }

    private MetaTitleModel getMetaTitleModel(List<ModelColumns> modelColumns, MetadataTable table, List<ModelColumnsRules> oldRules, List<ModelColumnsRules> newRules) {
        if (HussarUtils.isEmpty(oldRules) || HussarUtils.isEmpty(newRules)) {
            return null;
        }
        Optional<ModelColumnsRules> newTitleOp = newRules.stream().filter(x -> "3".equals(x.getRuleType())).findFirst();
        Optional<ModelColumnsRules> oldTitleOp = oldRules.stream().filter(x -> "3".equals(x.getRuleType())).findFirst();
        if (!newTitleOp.isPresent() || this.bothEqual(newTitleOp, oldTitleOp)) {
            return null;
        }
        Long titleColumnId = newTitleOp.get().getModelColumnId();
        Optional<ModelColumns> titleColumnOpt = modelColumns.stream().filter(x -> x.getModelColumnId().equals(titleColumnId)).findFirst();
        if (!titleColumnOpt.isPresent()) {
            return null;
        }
        MetaTitleModel model = new MetaTitleModel();
        model.setTable(table.getTableName());
        model.setTitleKey(titleColumnOpt.get().getColumnName());
        model.setTitleRule(MetaTitleRule.parse((String)newTitleOp.get().getRuleContent(), (String)titleColumnOpt.get().getTfmodelId()));
        return model;
    }
}

