/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.adaptation.source;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.enums.ModelOperationTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.ModelSourceEnum;
import com.jxdinfo.hussar.support.engine.plugin.model.application.action.source.ModelSourceAction;
import com.jxdinfo.hussar.support.engine.plugin.model.application.factory.ModelSaveFactory;
import java.sql.SQLException;
import org.springframework.stereotype.Component;

@Component
public class ModelNormalSourceAction
extends ModelSourceAction {
    public ModelNormalSourceAction() {
        ModelSaveFactory.addSourceAction(ModelSourceEnum.NORMAL_OR_BPM.getValue(), this);
    }

    @Override
    public void saveModel(ModelInfoDto modelInfoDto) throws SQLException, InterruptedException {
        String operate = this.isAddOperateFromDto(modelInfoDto) ? ModelOperationTypeEnum.ADD.getValue() : ModelOperationTypeEnum.EDIT.getValue();
        ModelSaveFactory.getActionByOperate(operate).saveModel(modelInfoDto);
    }

    private boolean isAddOperateFromDto(ModelInfoDto modelInfoDto) {
        boolean addFlag = ModelOperationTypeEnum.ADD.getValue().equals(modelInfoDto.getOperationType());
        if (HussarUtils.isNotEmpty((Object)modelInfoDto.getChildren()) && addFlag) {
            for (ModelInfoDto child : modelInfoDto.getChildren()) {
                addFlag = this.isAddOperateFromDto(child);
                if (addFlag) continue;
                return addFlag;
            }
        }
        return addFlag;
    }
}

