/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.adaptation.operate;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelMapDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.enums.ModelDefaultFieldEnum;
import com.jxdinfo.hussar.support.engine.api.enums.ModelOperationTypeEnum;
import com.jxdinfo.hussar.support.engine.plugin.model.application.action.operate.ModelOperateAction;
import com.jxdinfo.hussar.support.engine.plugin.model.application.factory.ModelSaveFactory;
import com.jxdinfo.hussar.support.engine.plugin.model.assembler.ModelParamAssembler;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ModelEditAction
extends ModelOperateAction {
    public ModelEditAction() {
        ModelSaveFactory.addOperateAction(ModelOperationTypeEnum.EDIT.getValue(), this);
    }

    @Override
    @DSTransactional
    public void saveModel(ModelInfoDto modelInfoDto) throws SQLException, InterruptedException {
        ModelMapDto modelMapDto = new ModelMapDto();
        List tableInfoDtoList = this.hussarMetadataService.getTableInfosByNames(this.getTableNamesFromDto(modelInfoDto));
        Map<Object, Object> tableInfoDtoMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)tableInfoDtoList)) {
            tableInfoDtoList.forEach(t -> this.addTableAndColumnIdToMap((TableInfoDto)t, modelMapDto));
            tableInfoDtoMap = tableInfoDtoList.stream().collect(Collectors.toMap(MetadataTable::getTableName, Function.identity(), (t1, t2) -> t1));
        }
        List<MetadataParam> paramList = ModelParamAssembler.getMetadataParamsFromDto(modelInfoDto, modelMapDto);
        ModelParamAssembler.addOnsFromDto(modelInfoDto, modelMapDto);
        for (MetadataParam param : paramList) {
            MetadataParam ddlParam;
            TableInfoDto tableInfoDto = (TableInfoDto)tableInfoDtoMap.get(param.getTableInfo().getTableName());
            ModelInfoDto currentModelInfoDto = (ModelInfoDto)modelMapDto.getModelInfoDtoMap().get(param.getTfModelId());
            if (HussarUtils.isEmpty((Object)currentModelInfoDto)) continue;
            if (ModelOperationTypeEnum.ADD.getValue().equals(currentModelInfoDto.getOperationType())) {
                if (currentModelInfoDto.isSyncToTable()) {
                    ddlParam = this.getDdlMetadataParam(param);
                    this.hussarDdlService.createTable(ddlParam);
                }
                this.cancelPurpose(param);
                this.hussarMetadataService.insertTableInfo(param);
            } else if (HussarUtils.isNotEmpty((Object)tableInfoDto)) {
                if (currentModelInfoDto.isSyncToTable()) {
                    ddlParam = this.getDdlMetadataParam(param);
                    this.hussarDdlService.editTable(ddlParam, this.getColumnInfoDtoFromMetadata(tableInfoDto.getColumnList()), tableInfoDto.getTableName());
                }
                this.cancelPurpose(param);
                this.hussarMetadataService.updateTableInfo(param);
            } else {
                if (currentModelInfoDto.isSyncToTable()) {
                    ddlParam = this.getDdlMetadataParam(param);
                    this.hussarDdlService.editTable(ddlParam, this.getOldColumnInfoDtoFromParamColumns(param.getColumnInfo()), param.getTableInfo().getTableName());
                }
                this.cancelPurpose(param);
                this.hussarMetadataService.insertTableInfo(param);
            }
            this.hussarDdlService.updateIndex(param);
        }
        this.setRelateIdsToDto(paramList, modelMapDto);
        List<ModelPublishDTO> publishDTOList = ModelParamAssembler.getModelPublishDtosFromDtos(Collections.singletonList(modelInfoDto), modelMapDto);
        if (HussarUtils.isNotEmpty(publishDTOList)) {
            this.modelRelateService.save(publishDTOList);
            for (ModelPublishDTO publishDTO : publishDTOList) {
                Boolean titleFlag = (Boolean)modelMapDto.getUpdateTitleMap().get(publishDTO.getTfmodelId());
                if (!HussarUtils.isNotEmpty((Object)titleFlag) || !titleFlag.booleanValue()) continue;
                this.modelRelateService.batchUpdateTitle(publishDTO.getTfmodelId());
            }
        }
    }

    private List<ColumnInfoDto> getColumnInfoDtoFromMetadata(List<MetadataColumn> metadataColumnList) {
        ArrayList<ColumnInfoDto> columnInfoDtoList = new ArrayList<ColumnInfoDto>();
        for (MetadataColumn metadataColumn : metadataColumnList) {
            ColumnInfoDto columnInfoDto = (ColumnInfoDto)BeanUtil.copy((Object)metadataColumn, ColumnInfoDto.class);
            if (!HussarUtils.isNotEmpty((Object)columnInfoDto)) continue;
            if ("primary".equals(columnInfoDto.getPurpose())) {
                columnInfoDto.setPk("1");
            }
            columnInfoDtoList.add(columnInfoDto);
        }
        return columnInfoDtoList;
    }

    private List<ColumnInfoDto> getOldColumnInfoDtoFromParamColumns(List<ColumnInfoDto> columnInfoList) {
        ArrayList<ColumnInfoDto> existColumnList = new ArrayList<ColumnInfoDto>();
        if (HussarUtils.isEmpty(columnInfoList)) {
            return existColumnList;
        }
        for (ColumnInfoDto columnInfo : columnInfoList) {
            if (columnInfo.isSyncToTable()) continue;
            if ("primary".equals(columnInfo.getPurpose())) {
                columnInfo.setPk("1");
            }
            existColumnList.add(columnInfo);
        }
        return existColumnList;
    }

    private void cancelPurpose(MetadataParam param) {
        if (HussarUtils.isEmpty((Object)param.getColumnInfo())) {
            return;
        }
        for (ColumnInfoDto columnInfo : param.getColumnInfo()) {
            if (columnInfo.isSyncToTable() || !"primary".equals(columnInfo.getPurpose()) || this.isDefaultPrimary(columnInfo.getColumnName())) continue;
            columnInfo.setPurpose(null);
            columnInfo.setPrimarys("");
        }
    }

    private boolean isDefaultPrimary(String columnName) {
        if (ModelDefaultFieldEnum.PRIMARY_KEY.getFieldName().equals(columnName)) {
            return true;
        }
        return ModelDefaultFieldEnum.BPM_PRIMARY_KEY.getFieldName().equals(columnName);
    }

    private void setRelateIdsToDto(List<MetadataParam> paramList, ModelMapDto modelMapDto) {
        if (HussarUtils.isEmpty(paramList)) {
            return;
        }
        List tfModelIds = paramList.stream().map(MetadataParam::getTfModelId).collect(Collectors.toList());
        List relationshipDtoList = this.modelRelateService.getModelsByTfModelIds(tfModelIds);
        relationshipDtoList.forEach(r -> modelMapDto.getModelRelationIdMap().put(r.getTfmodelId(), r.getRelatedId()));
    }
}

