/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.model.application.adaptation.assemble;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelMapDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipOn;
import com.jxdinfo.hussar.support.engine.api.enums.ModelDefaultFieldEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.plugin.model.application.action.assemble.ModelAssembleAction;
import com.jxdinfo.hussar.support.engine.plugin.model.application.factory.ModelSaveFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ModelTaskMsAssembleAction
extends ModelAssembleAction {
    private static final String TABLE_TYPE_TASK = "0";
    private static final String TABLE_TYPE_MASTER = "1";
    private static final String TABLE_TYPE_SLAVE = "2";

    public ModelTaskMsAssembleAction() {
        ModelSaveFactory.addAssembleAction(NodeTypeEnum.MSFLOW.getValue(), this);
    }

    @Override
    public List<ModelRelationship> getModelRelationshipsFromDto(ModelInfoDto modelInfoDto) {
        ArrayList<ModelRelationship> relationshipList = new ArrayList<ModelRelationship>();
        ModelRelationship relationship = (ModelRelationship)this.modelRelationshipService.getOne((Wrapper)new LambdaQueryWrapper().eq(ModelRelationship::getTfmodelId, (Object)modelInfoDto.getSourceModelId()));
        relationshipList.add(relationship);
        if (HussarUtils.isEmpty((Object)relationship)) {
            return new ArrayList<ModelRelationship>();
        }
        List<Long> parentIds = super.getParentIdsFromParentPath(relationship);
        if (HussarUtils.isNotEmpty(parentIds)) {
            relationshipList.addAll(this.modelRelationshipService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ModelRelationship::getRelatedId, parentIds)).or()).like(ModelRelationship::getParentPath, (Object)relationship.getRelatedId())));
        }
        return relationshipList;
    }

    @Override
    public void addRelationshipOn(List<ModelPublishDTO> publishDTOList) {
        boolean isTask;
        boolean isMaster;
        List columnList;
        Long businessId = null;
        Iterator recordId = null;
        for (ModelPublishDTO publishDTO : publishDTOList) {
            columnList = publishDTO.getModelColumns();
            isMaster = true;
            isTask = false;
            Object currentRecordId = null;
            for (ModelColumns column : columnList) {
                if (ModelDefaultFieldEnum.CHILD_FOREIGN_KEY.getFieldName().equals(column.getColumnName())) {
                    isMaster = false;
                    break;
                }
                if (ModelDefaultFieldEnum.PRIMARY_KEY.getFieldName().equals(column.getColumnName())) {
                    currentRecordId = column.getColumnId();
                    continue;
                }
                if (!ModelDefaultFieldEnum.BPM_FOREIGN_KEY.getFieldName().equals(column.getColumnName())) continue;
                isTask = true;
                businessId = column.getColumnId();
                break;
            }
            if (!isMaster || isTask) continue;
            recordId = currentRecordId;
        }
        for (ModelPublishDTO publishDTO : publishDTOList) {
            columnList = publishDTO.getModelColumns();
            isMaster = true;
            isTask = false;
            for (ModelColumns column : columnList) {
                if (ModelDefaultFieldEnum.CHILD_FOREIGN_KEY.getFieldName().equals(column.getColumnName()) && recordId != null) {
                    isMaster = false;
                    RelationshipOn relationshipOn = new RelationshipOn();
                    relationshipOn.setLeftColumnId(recordId);
                    relationshipOn.setOperatorType(OperatorType.EQ);
                    relationshipOn.setRightColumnId(column.getColumnId());
                    publishDTO.setOns(Collections.singletonList(relationshipOn));
                    break;
                }
                if (!ModelDefaultFieldEnum.BPM_FOREIGN_KEY.getFieldName().equals(column.getColumnName())) continue;
                isTask = true;
            }
            if (!isMaster || isTask || businessId == null) continue;
            RelationshipOn relationshipOn = new RelationshipOn();
            relationshipOn.setLeftColumnId(businessId);
            relationshipOn.setOperatorType(OperatorType.EQ);
            relationshipOn.setRightColumnId(recordId);
            publishDTO.setOns(Collections.singletonList(relationshipOn));
        }
    }

    @Override
    public void addTfModelIdToParam(List<MetadataParam> paramList, ModelInfoDto modelInfoDto, ModelMapDto modelMapDto) {
        String tfModelId = modelInfoDto.getModelId();
        for (MetadataParam param : paramList) {
            List columnList = param.getColumnInfo();
            String tableType = TABLE_TYPE_MASTER;
            for (ColumnInfoDto column : columnList) {
                if (ModelDefaultFieldEnum.CHILD_FOREIGN_KEY.getFieldName().equals(column.getColumnName())) {
                    tableType = TABLE_TYPE_SLAVE;
                    break;
                }
                if (!ModelDefaultFieldEnum.BPM_FOREIGN_KEY.getFieldName().equals(column.getColumnName())) continue;
                tableType = TABLE_TYPE_TASK;
                break;
            }
            switch (tableType) {
                case "0": {
                    param.setTfModelId("process_task_info_" + tfModelId);
                    modelMapDto.getTableNameModelIdMap().put(param.getTableInfo().getTableName(), param.getTfModelId());
                    break;
                }
                case "1": {
                    param.setTfModelId(tfModelId);
                    modelMapDto.getTableNameModelIdMap().put(param.getTableInfo().getTableName(), param.getTfModelId());
                    if (!HussarUtils.isNotEmpty((Object)modelInfoDto.getModelDec())) break;
                    param.getTableInfo().setTableDec(modelInfoDto.getModelDec());
                    break;
                }
                case "2": {
                    param.setTfModelId(param.getTableInfo().getTableName().toLowerCase() + tfModelId);
                    modelMapDto.getTableNameModelIdMap().put(param.getTableInfo().getTableName(), param.getTfModelId());
                    break;
                }
            }
        }
    }
}

