/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.file.model;

import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.file.model.FileEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.env.Environment;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class UploadFileDto
implements FileEntity {
    private MultipartFile multipartFile;
    private List<MultipartFile> multipartFileList;
    private Map<String, String[]> otherParams = new HashMap<String, String[]>();

    public MultipartFile getMultipartFile() {
        return this.multipartFile;
    }

    public void setMultipartFile(MultipartFile multipartFile) {
        this.multipartFile = multipartFile;
    }

    public List<MultipartFile> getMultipartFileList() {
        return this.multipartFileList;
    }

    public void setMultipartFileList(List<MultipartFile> multipartFileList) {
        this.multipartFileList = multipartFileList;
    }

    public Map<String, String[]> getOtherParams() {
        return this.otherParams;
    }

    public void setOtherParams(Map<String, String[]> otherParams) {
        this.otherParams = otherParams;
    }

    @Override
    public UploadFileDto build(Object ... arg) {
        Map objectMap = (Map)arg[0];
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)objectMap.get("multipartRequest");
        try {
            multipartRequest.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HussarException((Throwable)e);
        }
        this.multipartFile = multipartRequest.getFile("file");
        this.multipartFileList = multipartRequest.getFiles("files");
        Enumeration parameterNames = multipartRequest.getParameterNames();
        if (parameterNames.hasMoreElements()) {
            this.otherParams = multipartRequest.getParameterMap();
        }
        this.checkFileSize();
        return this;
    }

    private void checkFileSize() {
        String maxFileSize = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.servlet.multipart.max-file-size");
        assert (maxFileSize != null);
        long maxSize = HussarUtils.toLong((Object)maxFileSize.substring(0, maxFileSize.length() - 2)) * 1024L * 1024L;
        AssertUtil.isTrue((HussarUtils.isNotEmpty((Object)this.multipartFile) && maxSize > this.multipartFile.getSize() ? 1 : 0) != 0, (String)String.format("\u5355\u6587\u4ef6\u4e0a\u4f20\u5927\u5c0f\u8d85\u8fc7%s", maxFileSize));
        if (HussarUtils.isNotEmpty(this.multipartFileList)) {
            AssertUtil.isFalse((boolean)this.multipartFileList.stream().anyMatch(file -> file.getSize() > maxSize), (String)String.format("\u5355\u6587\u4ef6\u4e0a\u4f20\u5927\u5c0f\u8d85\u8fc7%s", maxFileSize));
        }
    }
}

