/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.OrderByType;
import com.jxdinfo.hussar.support.engine.core.model.EngineQueryConditionDto;
import com.jxdinfo.hussar.support.engine.core.service.PlatformApi;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.select.ColumnExpression;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.select.CustomExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.GroupEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OrderByEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.SetEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.factory.CustomExpressionFactory;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ICustomExpressionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class DmlSqlUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(DmlSqlUtil.class);

    private DmlSqlUtil() {
    }

    public static String getWhereSql(@Nullable List<WhereEntity> whereEntityList) {
        return DmlSqlUtil.getWhereSql(whereEntityList, false);
    }

    public static String getWhereSql(@Nullable List<WhereEntity> whereEntityList, boolean tableAlias) {
        if (HussarUtils.isEmpty(whereEntityList)) {
            return "";
        }
        StringBuilder where = new StringBuilder();
        DmlSqlUtil.renderWhere(where, whereEntityList, tableAlias);
        return where.toString();
    }

    private static void renderWhere(StringBuilder sql, List<WhereEntity> whereEntityList, boolean tableAlias) {
        int typeLength;
        int length;
        MatchTypeEnum end = null;
        for (WhereEntity whereEntity : whereEntityList) {
            MatchTypeEnum matchType = whereEntity.getMatchType();
            if (HussarUtils.isNotEmpty(whereEntity.getChildren())) {
                StringBuilder childSql = new StringBuilder();
                DmlSqlUtil.renderWhere(childSql, whereEntity.getChildren(), tableAlias);
                if (childSql.length() == 0) continue;
                sql.append("(").append((CharSequence)childSql).append(")");
                if (matchType == null) continue;
                sql.append(matchType);
                end = matchType;
                continue;
            }
            if (whereEntity.isNoll() || whereEntity.getOperatorType() == null) continue;
            sql.append(" ");
            boolean notConvertTextToVarchar = whereEntity.notConvertTextToVarchar();
            boolean hasTableAlias = false;
            if (tableAlias && !whereEntity.getSetSql().startsWith("(") && whereEntity.getOperatorType() != OperatorType.BOOLEAN_FALSE) {
                if (notConvertTextToVarchar) {
                    sql.append(whereEntity.getColumnEntity().getTableAlias()).append(".");
                }
                hasTableAlias = true;
            }
            String setSql = whereEntity.getSetSql();
            if (!notConvertTextToVarchar && hasTableAlias) {
                setSql = setSql.replaceFirst(whereEntity.getColumnEntity().getColNameEnableEscape(), whereEntity.getColumnEntity().getTableAliasAndColName());
            }
            sql.append(setSql);
            sql.append(" ");
            if (matchType == null) continue;
            sql.append(matchType);
            end = matchType;
        }
        if (end != null && (length = sql.length()) > (typeLength = end.getValue().length()) && end.getValue().equals(sql.substring(length - typeLength, length))) {
            sql.delete(length - typeLength, length);
        }
    }

    public static void addDelFlagWhere(ColumnEntity selectColumn, Map<String, Object> param, List<WhereEntity> whereEntityList) {
        Long parentId = EngineUtil.getId();
        ArrayList<WhereEntity> delWheres = new ArrayList<WhereEntity>();
        WhereEntity parentWhere = new WhereEntity();
        parentWhere.setMatchType(MatchTypeEnum.AND);
        parentWhere.setId(parentId);
        delWheres.add(parentWhere);
        WhereEntity delFlagWhere = new WhereEntity();
        delFlagWhere.setId(EngineUtil.getId());
        delFlagWhere.setColumnEntity(selectColumn);
        delFlagWhere.setOperatorType(OperatorType.NE);
        delFlagWhere.setMatchType(MatchTypeEnum.OR);
        String colAlias = selectColumn.getColAlias();
        delFlagWhere.setParamColumnAlias(colAlias);
        delFlagWhere.setParentId(parentId);
        param.put(colAlias, "1");
        delWheres.add(delFlagWhere);
        WhereEntity isNullWhere = new WhereEntity();
        isNullWhere.setId(EngineUtil.getId());
        isNullWhere.setColumnEntity(selectColumn);
        isNullWhere.setOperatorType(OperatorType.IS_NULL);
        isNullWhere.setMatchType(MatchTypeEnum.AND);
        isNullWhere.setParentId(parentId);
        isNullWhere.setParamColumnAlias(colAlias);
        delWheres.add(isNullWhere);
        whereEntityList.addAll(0, delWheres);
    }

    public static String totalsQuery(Map<String, String> map, ModelTableMappingDTO model) {
        boolean isMs = HussarUtils.isNotEmpty((Object)model.getSlaveTables());
        StringBuilder columnSqlBuilder = new StringBuilder();
        HashMap<String, ColumnEntity> columnEntityMap = new HashMap<String, ColumnEntity>();
        DmlEntityUtil.getModelColumnEntityMap(model, columnEntityMap, 2, null);
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ColumnEntity columnEntity = (ColumnEntity)columnEntityMap.get(entry.getKey());
            if (HussarUtils.isEmpty((Object)columnEntity)) continue;
            columnSqlBuilder.append("SUM").append("(");
            columnSqlBuilder.append(isMs ? columnEntity.getTableAliasAndColName() : columnEntity.getColNameEnableEscape());
            columnSqlBuilder.append(")").append(" ").append(entry.getValue());
            if (i != map.size() - 1) {
                columnSqlBuilder.append(",");
            }
            ++i;
        }
        return columnSqlBuilder.toString();
    }

    public static void globalOrder(Map<String, Object> param, List<OrderByEntity> orderByEntityList, ModelTableMappingDTO model) {
        List orderItems;
        if (HussarUtils.isEmpty(param) || HussarUtils.isEmpty((Object)param.get("orders"))) {
            return;
        }
        Object orders = param.get("orders");
        try {
            orderItems = (List)JSON.parseObject((String)JSON.toJSONString((Object)orders), (TypeReference)new TypeReference<List<OrderItem>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception ignore) {
            return;
        }
        Map<String, OrderByEntity> allOrderMap = DmlSqlUtil.getOrderMapByList(DmlEntityUtil.getColumnOrder(model));
        ArrayList<OrderByEntity> newOrderList = new ArrayList<OrderByEntity>();
        for (OrderItem item : orderItems) {
            String colName;
            OrderByEntity value = allOrderMap.get(item.getColumn().toUpperCase());
            if (HussarUtils.isNotEmpty((Object)value)) {
                value.setOrderType(item.isAsc() ? OrderByType.ASC : OrderByType.DESC);
                ColumnEntity columnEntity = value.getColumnEntity();
                if (columnEntity.getColAlias().contains(".")) {
                    columnEntity.setColAlias(columnEntity.getColAlias().substring(columnEntity.getColAlias().indexOf(".") + 1));
                }
                newOrderList.add(value);
                continue;
            }
            if (!item.getColumn().endsWith("_agg") || !HussarUtils.isNotEmpty((Object)(value = allOrderMap.get((colName = item.getColumn().substring(0, item.getColumn().indexOf("_agg"))).toUpperCase())))) continue;
            value.setOrderType(item.isAsc() ? OrderByType.ASC : OrderByType.DESC);
            value.getColumnEntity().setColName(item.getColumn());
            newOrderList.add(value);
        }
        if (HussarUtils.isNotEmpty(newOrderList)) {
            orderByEntityList.addAll(0, newOrderList);
        }
    }

    public static void globalQuery(Map<String, Object> param, List<WhereEntity> whereEntityList, ModelTableMappingDTO model) {
        WhereEntity parentWhere;
        Object superQueryObj = param.get("superQueryConditionDto");
        if (superQueryObj == null) {
            return;
        }
        List conditions = null;
        try {
            conditions = JsonUtil.readList((String)JSON.toJSONString((Object)superQueryObj), EngineQueryConditionDto.class);
        }
        catch (Exception e) {
            LOGGER.error("\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return;
        }
        List<WhereEntity> conditionWhere = DmlEntityUtil.getConditionWhere(conditions, model, param, "WH");
        if (HussarUtils.isNotEmpty(conditionWhere)) {
            Long parentId = EngineUtil.getId();
            conditionWhere.forEach(x -> {
                x.initVal(param);
                if (HussarUtils.equals((Object)MatchTypeEnum.OR, (Object)x.getMatchType()) && x.getParentId() == null) {
                    x.setParentId(parentId);
                }
            });
            parentWhere = new WhereEntity();
            parentWhere.setId(parentId);
            parentWhere.setMatchType(MatchTypeEnum.AND);
            conditionWhere.add(parentWhere);
        }
        if (HussarUtils.isNotEmpty(whereEntityList)) {
            Long newParentId = EngineUtil.getId();
            parentWhere = new WhereEntity();
            parentWhere.setId(newParentId);
            parentWhere.setMatchType(MatchTypeEnum.AND);
            whereEntityList.forEach(w -> {
                if (w.getParentId() == null) {
                    w.setParentId(newParentId);
                }
            });
            whereEntityList.add(parentWhere);
        }
        whereEntityList.addAll(conditionWhere);
    }

    private static Map<String, OrderByEntity> getOrderMapByList(List<OrderByEntity> orderByEntityList) {
        return orderByEntityList.stream().collect(Collectors.toMap(o -> o.getColumnEntity().getColAlias().toUpperCase(), Function.identity(), (k1, k2) -> k1));
    }

    public static Class<?> getColumnClass(ColumnEntity columnEntity) {
        Class<?> name = null;
        try {
            name = Class.forName(columnEntity.getColJavaType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return name;
    }

    public static String concatLike(Object str, OperatorType type) {
        switch (type) {
            case NOT_LEFT_LIKE: 
            case LEFT_LIKE: {
                return str + "%";
            }
            case NOT_RIGHT_LIKE: 
            case RIGHT_LIKE: {
                return "%" + str;
            }
        }
        return "%" + str + "%";
    }

    public static void globalGroupAgg(Map<String, Object> param, List<ColumnExpression> selectColumnsList, List<GroupEntity> groupEntityList, List<WhereEntity> havingEntityList, ModelTableMappingDTO model, List<OrderByEntity> orderByEntityList) {
        if (HussarUtils.isEmpty(param) || HussarUtils.isEmpty((Object)param.get("groupAggregation"))) {
            return;
        }
        Map groupAggregation = (Map)param.get("groupAggregation");
        Object agg = groupAggregation.get("agg");
        DmlSqlUtil.addGlobalColumn(selectColumnsList, model, agg);
        HashMap<String, String> columnMap = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty(selectColumnsList)) {
            for (ColumnExpression columnExpression : selectColumnsList) {
                CustomExpressionEntity customExpression = (CustomExpressionEntity)columnExpression;
                columnMap.put(customExpression.getColAlias(), customExpression.getColAlias());
            }
        }
        Object group = groupAggregation.get("group");
        DmlSqlUtil.addGlobalGroup(groupEntityList, model, group, selectColumnsList);
        Object having = groupAggregation.get("having");
        DmlSqlUtil.addGlobalHaving(param, havingEntityList, model, having);
        DmlSqlUtil.globalOrder(groupAggregation, orderByEntityList, model);
        if (HussarUtils.isNotEmpty(orderByEntityList)) {
            for (OrderByEntity orderByEntity : orderByEntityList) {
                ColumnEntity columnEntity = orderByEntity.getColumnEntity();
                if (!HussarUtils.isNotEmpty(columnMap.get(columnEntity.getColName()))) continue;
                columnEntity.setColName((String)columnMap.get(columnEntity.getColName()));
            }
        }
    }

    private static void addGlobalColumn(List<ColumnExpression> selectColumnsList, ModelTableMappingDTO model, Object agg) {
        Map aggMap = null;
        try {
            aggMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)agg), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u9ad8\u7ea7\u67e5\u8be2\u805a\u5408\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        if (HussarUtils.isNotEmpty(aggMap)) {
            selectColumnsList.clear();
            DmlEntityUtil.getColumnAgg(model, selectColumnsList, aggMap);
        }
    }

    private static void addGlobalGroup(List<GroupEntity> groupEntityList, ModelTableMappingDTO model, Object group, List<ColumnExpression> selectColumnsList) {
        ArrayList<String> groupList = new ArrayList();
        try {
            groupList = (List)JSON.parseObject((String)JSON.toJSONString((Object)group), (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u9ad8\u7ea7\u67e5\u8be2\u5206\u7ec4\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        if (groupList != null) {
            groupEntityList.clear();
            DmlEntityUtil.getColumnGroup(model, groupEntityList, groupList, selectColumnsList);
        }
    }

    private static void addGlobalHaving(Map<String, Object> param, List<WhereEntity> havingEntityList, ModelTableMappingDTO model, Object having) {
        List conditions = null;
        try {
            conditions = JsonUtil.readList((String)JSON.toJSONString((Object)having), EngineQueryConditionDto.class);
        }
        catch (Exception e) {
            LOGGER.error("\u9ad8\u7ea7\u67e5\u8be2having\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        if (conditions != null) {
            List<WhereEntity> conditionWhere = DmlEntityUtil.getConditionWhere(conditions, model, param, "HV");
            havingEntityList.clear();
            havingEntityList.addAll(conditionWhere);
        }
    }

    public static void globalUpdate(Map<String, Object> param, List<SetEntity> setEntityList, ModelTableMappingDTO model) {
        Map ruleCus = (Map)param.get("$RULE_CUS");
        if (HussarUtils.isEmpty((Object)ruleCus)) {
            return;
        }
        for (Map.Entry entry : ruleCus.entrySet()) {
            String field = (String)entry.getKey();
            Map rule = (Map)entry.getValue();
            if (HussarUtils.isEmpty((Object)rule)) continue;
            String type = HussarUtils.toStr(rule.get("type"));
            String value = HussarUtils.toStr(rule.get("value"));
            for (SetEntity setEntity : setEntityList) {
                if (!setEntity.getColumnEntity().getColName().equals(field)) continue;
                setEntity.setExpressionEntity(DmlSqlUtil.buildCustomExpressionEntity(setEntity.getColumnEntity(), model, type, value));
            }
        }
    }

    private static CustomExpressionEntity buildCustomExpressionEntity(ColumnEntity columnEntity, ModelTableMappingDTO model, String type, String value) {
        DbType dbType = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName()).getDbType();
        ICustomExpressionService customExpressionService = CustomExpressionFactory.getCustomExpression((String)dbType.getDb());
        if (HussarUtils.isEmpty((Object)customExpressionService)) {
            return null;
        }
        String expression = customExpressionService.buildAddAndSubExpression(type, columnEntity.getColumnId(), value);
        if (HussarUtils.isEmpty((Object)expression)) {
            return null;
        }
        CustomExpressionEntity expressionEntity = new CustomExpressionEntity(expression, null);
        Map<String, ColumnEntity> columnEntityMap = Stream.of(columnEntity).collect(Collectors.toMap(m -> HussarUtils.toStr((Object)m.getColumnId()), Function.identity()));
        expressionEntity.setColumns(columnEntityMap);
        return expressionEntity;
    }

    public static String securityLevelSql(ModelTableMappingDTO modelTableMappingDTO, Map<String, Object> param) {
        if (modelTableMappingDTO == null || param.containsKey("noSecurityLevelWhere")) {
            return "";
        }
        PlatformApi platformApi = (PlatformApi)SpringContextUtil.getBean(PlatformApi.class);
        List securityFilter = platformApi.getDataSecurityFilter(modelTableMappingDTO.getTfModelId());
        if (securityFilter == null || securityFilter.isEmpty()) {
            return "";
        }
        List<WhereEntity> conditionWhere = DmlEntityUtil.getConditionWhere(securityFilter, modelTableMappingDTO, param, "SC");
        conditionWhere.forEach(x -> x.initVal(param));
        return DmlSqlUtil.getWhereSql(DmlEntityUtil.getWhereTree(conditionWhere), false);
    }
}

