/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.dml;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;

public class DeleteEntity
implements DmlEntity {
    private List<WhereEntity> whereEntityList;
    private ModelTableMappingDTO relationship;
    private Map<String, Object> param;
    private String whereSql;

    @Override
    public DeleteEntity builder() {
        this.whereEntityList = new ArrayList<WhereEntity>();
        return this;
    }

    @Override
    public DeleteEntity init(Map<String, Object> param) {
        this.param = param;
        for (WhereEntity whereEntity : this.whereEntityList) {
            whereEntity.initVal(param);
        }
        this.initSql();
        HussarException.throwBy((boolean)HussarUtils.isBlank((CharSequence)this.whereSql), (Integer)EngineExceptionEnum.WHERE_FAIL.getExceptionCode(), (String)EngineExceptionEnum.WHERE_FAIL.getMessage());
        return this;
    }

    private void initSql() {
        this.isNotEmptyWhere();
        this.whereSql = DmlSqlUtil.getWhereSql(DmlEntityUtil.getWhereTree(this.whereEntityList));
    }

    public String getTableName() {
        return this.entity().getTableName();
    }

    public String getKeyProperty() {
        return this.entity().getKeyProperty();
    }

    public String getWhereSql() {
        return this.whereSql;
    }

    public String getSqlComment() {
        return "";
    }

    private ColumnEntity entity() {
        this.isNotEmptyWhere();
        return this.whereEntityList.get(0).getColumnEntity();
    }

    private void isNotEmptyWhere() {
        HussarException.throwBy((boolean)HussarUtils.isEmpty(this.whereEntityList), (Integer)EngineExceptionEnum.WHERE_FAIL.getExceptionCode(), (String)EngineExceptionEnum.WHERE_FAIL.getMessage());
    }

    public ModelTableMappingDTO getRelationship() {
        return this.relationship;
    }

    public void setRelationship(ModelTableMappingDTO relationship) {
        this.relationship = relationship;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public List<WhereEntity> getWhereEntityList() {
        return this.whereEntityList;
    }

    public void setWhereEntityList(List<WhereEntity> whereEntityList) {
        this.whereEntityList = whereEntityList;
    }

    @Override
    public String getSql() {
        SQL sql = (SQL)new SQL().DELETE_FROM(this.getTableName());
        if (HussarUtils.isNotEmpty((Object)this.whereSql)) {
            sql.WHERE(this.whereSql);
        }
        return sql.toString() + this.getSqlComment();
    }

    @Override
    public String getPoolName() {
        return this.entity().getPoolName();
    }

    public DeleteEntity appendWhere(String conditions, boolean juxtaposed) {
        if (HussarUtils.isEmpty((Object)conditions)) {
            return this;
        }
        if (HussarUtils.isNotEmpty((Object)this.whereSql)) {
            StringBuilder whereSqlBuilder = new StringBuilder();
            if (juxtaposed) {
                whereSqlBuilder.append("(");
            }
            whereSqlBuilder.append(this.whereSql);
            if (juxtaposed) {
                whereSqlBuilder.append(")");
            }
            whereSqlBuilder.append(" AND ").append(conditions);
            this.whereSql = whereSqlBuilder.toString();
        } else {
            this.whereSql = conditions;
        }
        return this;
    }
}

