/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.dynamic.datasource.hussar.extend.AbstractHussarDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessPmDto;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.enums.ConditionType;
import com.jxdinfo.hussar.support.engine.api.enums.JoinTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.OrderByType;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.core.enums.ColumnRuleType;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineQueryConditionDto;
import com.jxdinfo.hussar.support.engine.core.model.dataTitle.MetaTitleRule;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.dto.EngineBackVerifyContent;
import com.jxdinfo.hussar.support.engine.plugin.dml.dto.EngineBackVerifyDto;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ConstantColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ExpressionColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.TableEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectCustomEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.select.ColumnExpression;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.select.CustomExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.GroupEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.JoinEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OnCondition;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OrderByEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.SetEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.ValueEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlParamUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.engine.plugin.model.factory.CustomExpressionFactory;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ICustomExpressionService;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelSerialNumService;
import com.jxdinfo.hussar.support.engine.plugin.model.util.ModelResultMapUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

public class DmlEntityUtil {
    private static IEnginePluginModelApp metadataService;
    private static DynamicDatasourceService datasourceService;
    private static String userDetailDeptName;
    private static String userDetailDeptId;
    private static String userDetailStaffId;
    private static String userDetailPostId;
    private static String userDetailPostName;

    private DmlEntityUtil() {
    }

    public static Object getEntity(String javaType, Map<String, Object> param, NodeBusinessVo businessVo, boolean haveJoin) {
        DmlEntity dmlEntity = DmlEntityUtil.getEntityPm(javaType, businessVo, haveJoin);
        HussarException.throwByNull((Object)dmlEntity, (String)"\u83b7\u53d6\u56fa\u5316\u5b9e\u4f53\u5f02\u5e38");
        return dmlEntity.init(param);
    }

    public static DmlEntity getEntityPm(String javaType, NodeBusinessVo businessVo, boolean haveJoin) {
        if (haveJoin) {
            return DmlEntityUtil.getRelationEntityPm(javaType, businessVo);
        }
        return DmlEntityUtil.getSingleTableEntity(javaType, businessVo);
    }

    private static void builderEntity(Map<Long, ModelColumnDto> columnMap, Map<Long, TableEntity> tableEntityMap, List<NodeBusinessPmDto> pmList, List<ColumnEntity> columnEntityList, List<WhereEntity> whereEntityList, List<OrderByEntity> orderEntityList, List<SetEntity> setEntityList, List<ValueEntity> valueEntityList) {
        HussarException.throwByNull(pmList, (String)"\u53c2\u6570\u5f02\u5e38");
        for (NodeBusinessPmDto pm : pmList) {
            CustomExpressionEntity expressionEntity;
            boolean check = DmlEntityUtil.getParentWhere(whereEntityList, pm.getColumnId(), ParameterType.where.equals((Object)pm.getParameterType()), pm.getParameterId(), pm.getParentId(), pm.getMatchType());
            ModelColumnDto columnDto = columnMap.get(pm.getColumnId());
            if (columnDto == null || check) continue;
            TableEntity tableEntity = tableEntityMap.get(columnDto.getTableId());
            if (tableEntity == null) {
                tableEntity = DmlEntityUtil.getTableEntity(columnDto.getPollName(), columnDto.getTableName());
                tableEntityMap.put(columnDto.getTableId(), tableEntity);
            }
            if (columnEntityList != null && ParameterType.column.equals((Object)pm.getParameterType())) {
                ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)columnDto, tableEntity);
                entity.setColAlias(pm.getParameterAlias());
                columnEntityList.add(entity);
            }
            if (setEntityList != null && ParameterType.set.equals((Object)pm.getParameterType())) {
                SetEntity setEntity = DmlEntityUtil.getSetEntity(pm, (MetadataColumnDto)columnDto, tableEntity);
                if (pm.getExpression() != null && (expressionEntity = DmlEntityUtil.getCustomExpressionEntity(columnMap, tableEntityMap, pm)) != null) {
                    setEntity.setExpressionEntity(expressionEntity);
                }
                setEntityList.add(setEntity);
            }
            if (valueEntityList != null && ParameterType.values.equals((Object)pm.getParameterType())) {
                ValueEntity valueEntity = DmlEntityUtil.getValueEntity(pm, (MetadataColumnDto)columnDto, tableEntity);
                if (pm.getExpression() != null && (expressionEntity = DmlEntityUtil.getCustomExpressionEntity(columnMap, tableEntityMap, pm)) != null) {
                    valueEntity.setExpressionEntity(expressionEntity);
                }
                valueEntityList.add(valueEntity);
            }
            if (whereEntityList != null && ParameterType.where.equals((Object)pm.getParameterType())) {
                WhereEntity whereEntity = DmlEntityUtil.getWhereEntity(pm, (MetadataColumnDto)columnDto, tableEntity);
                if (pm.getExpression() != null && (expressionEntity = DmlEntityUtil.getCustomExpressionEntity(columnMap, tableEntityMap, pm)) != null) {
                    whereEntity.setExpressionEntity(expressionEntity);
                }
                whereEntityList.add(whereEntity);
            }
            if (orderEntityList == null || !ParameterType.order.equals((Object)pm.getParameterType())) continue;
            orderEntityList.add(DmlEntityUtil.getOrderEntity(pm, (MetadataColumnDto)columnDto, tableEntity));
        }
        if (HussarUtils.isNotEmpty(whereEntityList)) {
            Long newParentId = EngineUtil.getId();
            WhereEntity parentWhere = new WhereEntity();
            parentWhere.setId(newParentId);
            parentWhere.setMatchType(MatchTypeEnum.AND);
            whereEntityList.forEach(w -> {
                if (HussarUtils.equals((Object)MatchTypeEnum.OR, (Object)w.getMatchType()) && w.getParentId() == null) {
                    w.setParentId(newParentId);
                }
            });
            whereEntityList.add(parentWhere);
        }
    }

    public static TableEntity getTableEntity(String pollName, String tableName) {
        DbType dbType = DmlEntityUtil.getDbType(pollName);
        return new TableEntity(dbType, tableName);
    }

    public static WhereEntity newWhereEntity(Long parentId, MatchTypeEnum matchType, OperatorType operatorType, ColumnEntity columnEntity, String paramAlias, ConditionType conditionType, String defaultValue) {
        WhereEntity entity = new WhereEntity();
        entity.setId(EngineUtil.getId());
        entity.setColumnEntity(columnEntity);
        entity.setOperatorType(operatorType == null ? OperatorType.EQ : operatorType);
        entity.setMatchType(matchType == null ? MatchTypeEnum.AND : matchType);
        entity.setParamColumnAlias(paramAlias == null ? columnEntity.getColAlias() : paramAlias);
        entity.setParentId(parentId);
        entity.setConditionType(conditionType);
        entity.setDefaultValue(defaultValue);
        return entity;
    }

    public static DeleteEntity getWhereByOn(List<WhereEntity> masterWhere, List<RelationshipOnDto> onDtoList) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DeleteEntity deleteEntity = new DeleteEntity().builder();
        ArrayList<WhereEntity> whereEntityList = new ArrayList<WhereEntity>();
        deleteEntity.setWhereEntityList(whereEntityList);
        WhereEntity whereEntity = masterWhere.get(0);
        String paramColumnAlias = whereEntity.getParamColumnAlias();
        MetadataColumnDto columnDto = onDtoList.get(0).getRightColumn();
        TableEntity tableEntity = DmlEntityUtil.getTableEntity(columnDto.getPollName(), columnDto.getTableName());
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        WhereEntity slaveWhere = DmlEntityUtil.newWhereEntity(null, null, whereEntity.getOperatorType(), columnEntity, paramColumnAlias, null, null);
        whereEntityList.add(slaveWhere);
        param.put(whereEntity.getParamColumnAlias(), whereEntity.getVal());
        deleteEntity.setWhereEntityList(whereEntityList);
        return deleteEntity.init(param);
    }

    public static DmlEntity getSingleTableEntity(String javaType, NodeBusinessVo businessVo, ModelTableMappingDTO modelTable) {
        List<NodeBusinessPmDto> pmList = DmlEntityUtil.getPm(businessVo);
        Map<Long, ModelColumnDto> columnMap = DmlEntityUtil.getColumnMap(modelTable.getColumns());
        if (SelectEntity.class.getName().equals(javaType)) {
            SelectEntity selectEntity = DmlEntityUtil.getSelectEntity(columnMap, pmList);
            selectEntity.setModel(modelTable);
            selectEntity.setResultMapId(String.format("single.%s", businessVo.getModelId()));
            return selectEntity;
        }
        if (InsertEntity.class.getName().equals(javaType)) {
            InsertEntity insertEntity = DmlEntityUtil.getInsertEntity(columnMap, pmList);
            insertEntity.setModel(modelTable);
            return insertEntity;
        }
        if (UpdateEntity.class.getName().equals(javaType)) {
            UpdateEntity updateEntity = DmlEntityUtil.getUpdateEntity(columnMap, pmList);
            updateEntity.setModel(modelTable);
            return updateEntity;
        }
        if (DeleteEntity.class.getName().equals(javaType)) {
            return DmlEntityUtil.getDeleteEntity(columnMap, pmList);
        }
        if (SelectExpressionEntity.class.getName().equals(javaType)) {
            SelectExpressionEntity selectEntity = DmlEntityUtil.getSelectExpressionEntity(columnMap, pmList, modelTable);
            selectEntity.setModel(modelTable);
            selectEntity.setResultMapId(String.format("single.%s", businessVo.getModelId()));
            return selectEntity;
        }
        if (SelectCustomEntity.class.getName().equals(javaType)) {
            SelectCustomEntity selectEntity = DmlEntityUtil.getSelectCustomEntity(columnMap, pmList, businessVo, modelTable);
            selectEntity.setModel(modelTable);
            selectEntity.setResultMapId(String.format("single.%s", businessVo.getModelId()));
            return selectEntity;
        }
        return null;
    }

    private static SelectExpressionEntity getSelectExpressionEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPmDto> pmList, ModelTableMappingDTO modelTable) {
        String customSql;
        SelectExpressionEntity entity = new SelectExpressionEntity().builder();
        HashMap<Long, TableEntity> tableEntityMap = new HashMap<Long, TableEntity>();
        DmlEntityUtil.builderEntity(columnMap, tableEntityMap, pmList, null, entity.getWhereEntityList(), entity.getOrderByEntityList(), null, null);
        DmlEntityUtil.builderExpressionEntity(columnMap, tableEntityMap, pmList, entity.getSelectColumnsList(), entity.getGroupEntityList(), entity.getHavingEntityList());
        ArrayList rules = new ArrayList();
        modelTable.getRuleByRuleType(rules, ColumnRuleType.CUSTOM_SQL);
        if (!rules.isEmpty() && HussarUtils.isNotEmpty((Object)(customSql = Optional.ofNullable(rules.get(0)).map(ModelColumnsRules::getRuleContent).map(JsonUtil::toMap).map(m -> m.getOrDefault("customSql", "")).map(String::valueOf).orElse("")))) {
            entity.setCustomSql(customSql);
        }
        return entity;
    }

    private static SelectCustomEntity getSelectCustomEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPmDto> pmList, NodeBusinessVo businessVo, ModelTableMappingDTO modelTable) {
        SelectCustomEntity entity = (SelectCustomEntity)new SelectCustomEntity().builder();
        HashMap<Long, TableEntity> tableEntityMap = new HashMap<Long, TableEntity>();
        DmlEntityUtil.builderEntity(columnMap, tableEntityMap, pmList, entity.getSelectColumnsList(), entity.getWhereEntityList(), entity.getOrderByEntityList(), null, null);
        ArrayList rules = new ArrayList();
        modelTable.getRuleByRuleType(rules, ColumnRuleType.CUSTOM_SQL);
        String customSql = rules.isEmpty() ? "" : Optional.ofNullable(rules.get(0)).map(ModelColumnsRules::getRuleContent).map(JsonUtil::toMap).map(m -> m.get("customSql")).map(String::valueOf).orElse("");
        entity.setCustomSql(customSql);
        return entity;
    }

    private static void builderExpressionEntity(Map<Long, ModelColumnDto> columnMap, HashMap<Long, TableEntity> tableEntityMap, List<NodeBusinessPmDto> pmList, List<ColumnExpression> selectColumnsList, List<GroupEntity> groupEntityList, List<WhereEntity> havingEntityList) {
        if (HussarUtils.isEmpty(pmList)) {
            return;
        }
        for (NodeBusinessPmDto pm : pmList) {
            CustomExpressionEntity expressionEntity;
            if (selectColumnsList != null && ParameterType.cons.equals((Object)pm.getParameterType())) {
                ConstantColumnEntity entity = new ConstantColumnEntity(pm.getValueType(), pm.getConstValue());
                selectColumnsList.add(entity);
            }
            if (selectColumnsList != null && ParameterType.fun.equals((Object)pm.getParameterType())) {
                ArrayList<ColumnExpression> parameters = new ArrayList<ColumnExpression>();
                ExpressionColumnEntity entity = new ExpressionColumnEntity(pm.getFunctionName(), parameters, Boolean.TRUE.equals(pm.getDistinct()), pm.getParameterAlias(), pm.getFunctionJavaType());
                DmlEntityUtil.builderExpressionEntity(columnMap, tableEntityMap, pm.getParameters(), parameters, null, null);
                if (pm.getParameters().size() == parameters.size()) {
                    selectColumnsList.add(entity);
                }
            }
            if (selectColumnsList != null && ParameterType.express.equals((Object)pm.getParameterType()) && (expressionEntity = DmlEntityUtil.getCustomExpressionEntity(columnMap, tableEntityMap, pm)) != null) {
                selectColumnsList.add(expressionEntity);
            }
            boolean check = DmlEntityUtil.getParentWhere(havingEntityList, pm.getColumnId(), ParameterType.having.equals((Object)pm.getParameterType()), pm.getParameterId(), pm.getParentId(), pm.getMatchType());
            ModelColumnDto columnDto = columnMap.get(pm.getColumnId());
            if (columnDto == null || check) continue;
            TableEntity tableEntity = tableEntityMap.get(columnDto.getTableId());
            if (tableEntity == null) {
                tableEntity = DmlEntityUtil.getTableEntity(columnDto.getPollName(), columnDto.getTableName());
                tableEntityMap.put(columnDto.getTableId(), tableEntity);
            }
            if (selectColumnsList != null && ParameterType.column.equals((Object)pm.getParameterType())) {
                ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)columnDto, tableEntity);
                entity.setColAlias(pm.getParameterAlias());
                selectColumnsList.add(entity);
            }
            if (groupEntityList != null && ParameterType.group.equals((Object)pm.getParameterType())) {
                groupEntityList.add(DmlEntityUtil.getGroupEntity((MetadataColumnDto)columnDto, tableEntity));
            }
            if (havingEntityList == null || !ParameterType.having.equals((Object)pm.getParameterType())) continue;
            havingEntityList.add(DmlEntityUtil.getWhereEntity(pm, (MetadataColumnDto)columnDto, tableEntity));
        }
    }

    private static CustomExpressionEntity getCustomExpressionEntity(Map<Long, ModelColumnDto> columnMap, Map<Long, TableEntity> tableEntityMap, NodeBusinessPmDto pm) {
        CustomExpressionEntity expressionEntity = new CustomExpressionEntity(pm.getExpression(), pm.getFunctionJavaType());
        List<String> columnId = expressionEntity.getColumnKeys();
        expressionEntity.setColAlias(pm.getParameterAlias());
        HashMap<String, ColumnEntity> columnEntityMap = new HashMap<String, ColumnEntity>();
        boolean discard = false;
        if (!columnId.isEmpty()) {
            for (String id : columnId) {
                Long longId = Long.parseLong(id);
                if (columnMap.containsKey(longId)) {
                    ColumnEntity entity = DmlEntityUtil.getColumnEntity(columnMap, tableEntityMap, longId, pm.getParameterAlias());
                    columnEntityMap.put(id, entity);
                    continue;
                }
                discard = true;
                break;
            }
        }
        if (!discard) {
            expressionEntity.setColumns(columnEntityMap);
            return expressionEntity;
        }
        return null;
    }

    private static boolean getParentWhere(List<WhereEntity> havingEntityList, Long columnId, boolean parameterType, Long parameterId, Long parentId, MatchTypeEnum matchType) {
        boolean check = false;
        if (HussarUtils.isEmpty((Object)columnId) && parameterType) {
            WhereEntity whereEntity = new WhereEntity();
            whereEntity.setId(parameterId);
            whereEntity.setParentId(parentId);
            whereEntity.setMatchType(matchType);
            havingEntityList.add(whereEntity);
            check = true;
        }
        return check;
    }

    private static ColumnEntity getColumnEntity(Map<Long, ModelColumnDto> columnMap, Map<Long, TableEntity> tableEntityMap, Long columnId, String parameterAlias) {
        ModelColumnDto columnDto = columnMap.get(columnId);
        TableEntity tableEntity = tableEntityMap.get(columnDto.getTableId());
        if (tableEntity == null) {
            tableEntity = DmlEntityUtil.getTableEntity(columnDto.getPollName(), columnDto.getTableName());
            tableEntityMap.put(columnDto.getTableId(), tableEntity);
        }
        ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)columnDto, tableEntity);
        entity.setColAlias(parameterAlias);
        return entity;
    }

    private static DmlEntity getSingleTableEntity(String javaType, NodeBusinessVo businessVo) {
        return DmlEntityUtil.getSingleTableEntity(javaType, businessVo, DmlEntityUtil.getModelTable(businessVo));
    }

    private static DeleteEntity getDeleteEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPmDto> pmList) {
        DeleteEntity entity = new DeleteEntity().builder();
        DmlEntityUtil.builderEntity(columnMap, new HashMap<Long, TableEntity>(), pmList, null, entity.getWhereEntityList(), null, null, null);
        return entity;
    }

    private static UpdateEntity getUpdateEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPmDto> pmList) {
        UpdateEntity entity = new UpdateEntity().builder();
        DmlEntityUtil.builderEntity(columnMap, new HashMap<Long, TableEntity>(), pmList, null, entity.getWhereEntityList(), null, entity.getSetEntityList(), null);
        return entity;
    }

    private static SelectEntity getSelectEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPmDto> pmList) {
        SelectEntity entity = new SelectEntity().builder();
        DmlEntityUtil.builderEntity(columnMap, new HashMap<Long, TableEntity>(), pmList, entity.getSelectColumnsList(), entity.getWhereEntityList(), entity.getOrderByEntityList(), null, null);
        return entity;
    }

    private static InsertEntity getInsertEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPmDto> pmList) {
        InsertEntity entity = new InsertEntity().builder();
        DmlEntityUtil.builderEntity(columnMap, new HashMap<Long, TableEntity>(), pmList, null, null, null, null, entity.getValueEntityList());
        return entity;
    }

    private static ValueEntity getValueEntity(NodeBusinessPmDto pm, MetadataColumnDto columnDto, TableEntity tableEntity) {
        ValueEntity valueEntity = new ValueEntity();
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        valueEntity.setColumnEntity(columnEntity);
        valueEntity.setParamColumnAlias(pm.getParameterAlias());
        return valueEntity;
    }

    private static SetEntity getSetEntity(NodeBusinessPmDto pm, MetadataColumnDto columnDto, TableEntity tableEntity) {
        SetEntity setEntity = new SetEntity();
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        setEntity.setColumnEntity(columnEntity);
        setEntity.setOperatorType(pm.getOperatorType());
        setEntity.setParamColumnAlias(pm.getParameterAlias());
        return setEntity;
    }

    private static WhereEntity getWhereEntity(NodeBusinessPmDto pm, MetadataColumnDto columnDto, TableEntity tableEntity) {
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        return DmlEntityUtil.newWhereEntity(pm.getParentId(), pm.getMatchType(), pm.getOperatorType(), columnEntity, pm.getParameterAlias(), pm.getConditionType(), pm.getDefaultValue());
    }

    private static OrderByEntity getOrderEntity(NodeBusinessPmDto pm, MetadataColumnDto columnDto, TableEntity tableEntity) {
        OrderByEntity orderByEntity = new OrderByEntity();
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        orderByEntity.setColumnEntity(columnEntity);
        orderByEntity.setOrderType(pm.getOrderType());
        return orderByEntity;
    }

    private static GroupEntity getGroupEntity(MetadataColumnDto columnDto, TableEntity tableEntity) {
        GroupEntity groupEntity = new GroupEntity();
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        groupEntity.setColumnEntity(columnEntity);
        return groupEntity;
    }

    public static ColumnEntity getColumnEntity(MetadataColumnDto columnDto, TableEntity tableEntity) {
        if (HussarUtils.isNotBlank((CharSequence)columnDto.getPrimarys())) {
            tableEntity.setKeyProperty(columnDto.getColumnAlias());
        }
        ColumnEntity columnEntity = new ColumnEntity(columnDto.getTableId(), columnDto.getColumnId(), columnDto.getColumnName(), columnDto.getColumnAlias(), columnDto.getJavaType(), columnDto.getJdbcType(), tableEntity.getDbType() != null, tableEntity, columnDto.getPurpose(), columnDto.getPollName());
        columnEntity.setDataType(columnDto.getDataType());
        return columnEntity;
    }

    private static ModelTableMappingDTO getModelTable(NodeBusinessVo node) {
        if (metadataService == null) {
            metadataService = (IEnginePluginModelApp)SpringContextUtil.getBean(IEnginePluginModelApp.class);
        }
        return metadataService.getModelTableMapping(node.getModelId());
    }

    private static Map<Long, ModelColumnDto> getColumnMap(List<ModelColumnDto> columns) {
        return columns.stream().collect(Collectors.toMap(MetadataColumn::getColumnId, Function.identity(), (k1, k2) -> k1));
    }

    private static List<NodeBusinessPmDto> getPm(NodeBusinessVo businessVo) {
        ArrayList<NodeBusinessPmDto> list = new ArrayList<NodeBusinessPmDto>();
        if (HussarUtils.isNotEmpty((Object)businessVo.getJsonParams())) {
            JSONObject dto = JSON.parseObject((String)businessVo.getJsonParams());
            if (HussarUtils.isNotEmpty((Object)dto.get((Object)"pmList"))) {
                list.addAll(DmlEntityUtil.getPmListByJson(dto.get((Object)"pmList")));
            }
            if (HussarUtils.isNotEmpty((Object)dto.get((Object)"whereList"))) {
                list.addAll(DmlEntityUtil.getPmListByJson(dto.get((Object)"whereList")));
            }
            if (HussarUtils.isNotEmpty((Object)dto.get((Object)"sortVOList"))) {
                list.addAll(DmlEntityUtil.getPmListByJson(dto.get((Object)"sortVOList")));
            }
            return list;
        }
        return list;
    }

    private static List<NodeBusinessPmDto> getPmListByJson(Object json) {
        return (List)JSON.parseObject((String)JSON.toJSONString((Object)json), (TypeReference)new TypeReference<List<NodeBusinessPmDto>>(){}, (Feature[])new Feature[0]);
    }

    private static DmlEntity getRelationEntityPm(String javaType, NodeBusinessVo businessVo) {
        List<NodeBusinessPmDto> pmList = DmlEntityUtil.getPm(businessVo);
        Long modelId = businessVo.getModelId();
        ModelTableMappingDTO modelTable = DmlEntityUtil.getModelTable(businessVo);
        if (businessVo.isResultTiled() && !businessVo.getNodeType().contains("flow")) {
            DmlEntityUtil.reduceRedundantSlave(modelTable);
        }
        HashMap<Long, TableEntity> tableEntityMap = new HashMap<Long, TableEntity>();
        HashMap<Long, ModelColumnDto> columnMap = new HashMap<Long, ModelColumnDto>(DmlEntityUtil.getColumnMap(modelTable.getColumns()));
        if (HussarUtils.equals((Object)SelectEntity.class.getName(), (Object)javaType)) {
            TableEntity tableEntity = DmlEntityUtil.getTableEntity(modelTable.getPollName(), modelTable.getTableName());
            tableEntityMap.put(modelTable.getTableId(), tableEntity);
            List<JoinEntity> joinEntityList = DmlEntityUtil.getJoinEntity(modelTable, columnMap, tableEntityMap);
            SelectEntity entity = DmlEntityUtil.getSelectEntity(columnMap, pmList);
            entity.setModel(modelTable);
            entity.setJoinEntityList(joinEntityList);
            if (businessVo.isResultTiled()) {
                Map<Long, String> columnParameterMap = pmList.stream().collect(Collectors.toMap(NodeBusinessPm::getColumnId, NodeBusinessPm::getParameterAlias));
                Configuration configuration = ((SqlSessionFactory)SpringContextUtil.getBean(SqlSessionFactory.class)).getConfiguration();
                try {
                    List resultMappings = ModelResultMapUtil.getResultMappingsWithProperty((ModelTableMappingDTO)modelTable, (Boolean)false, (Configuration)configuration, columnParameterMap, (Boolean)true);
                    ResultMap resultMap = ModelResultMapUtil.getResultMap((String)String.format("ms_rev.%s", modelTable.getRelatedId()), (List)resultMappings, (Configuration)configuration);
                    entity.setResultMap(resultMap);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                entity.setResultMapId(String.format("ms.%s", modelId));
            }
            return entity;
        }
        if (HussarUtils.equals((Object)DeleteEntity.class.getName(), (Object)javaType)) {
            DeleteEntity entity = DmlEntityUtil.getDeleteEntity(columnMap, pmList);
            entity.setRelationship(modelTable);
            return entity;
        }
        if (HussarUtils.equals((Object)UpdateEntity.class.getName(), (Object)javaType)) {
            UpdateEntity entity = DmlEntityUtil.getUpdateEntity(columnMap, pmList);
            entity.setModel(modelTable);
            return entity;
        }
        if (HussarUtils.equals((Object)SelectExpressionEntity.class.getName(), (Object)javaType)) {
            TableEntity tableEntity = DmlEntityUtil.getTableEntity(modelTable.getPollName(), modelTable.getTableName());
            tableEntityMap.put(modelTable.getTableId(), tableEntity);
            List<JoinEntity> joinEntityList = DmlEntityUtil.getJoinEntity(modelTable, columnMap, tableEntityMap);
            SelectExpressionEntity entity = DmlEntityUtil.getSelectExpressionEntity(columnMap, pmList, modelTable);
            entity.setModel(modelTable);
            entity.setJoinEntityList(joinEntityList);
            entity.setResultMapId(String.format("ms.%s", modelId));
            return entity;
        }
        return null;
    }

    private static List<JoinEntity> getJoinEntity(ModelTableMappingDTO relationship, Map<Long, ModelColumnDto> columnMap, Map<Long, TableEntity> tableEntityMap) {
        ArrayList<JoinEntity> joinEntityList = new ArrayList<JoinEntity>();
        DbType dbType = null;
        for (ModelTableMappingDTO joinDto : relationship.getSlaveTables()) {
            if (dbType == null) {
                dbType = DmlEntityUtil.getDbType(joinDto.getPollName());
            }
            tableEntityMap.putIfAbsent(joinDto.getTableId(), new TableEntity(dbType, joinDto.getTableName()));
            JoinEntity joinEntity = new JoinEntity();
            joinEntity.setOneToN(HussarUtils.equals((Object)joinDto.getRelation(), (Object)ModelRelation.ONE_N) || HussarUtils.equals((Object)joinDto.getRelation(), (Object)ModelRelation.N_N));
            ArrayList<OnCondition> onConditions = new ArrayList<OnCondition>();
            columnMap.putAll(DmlEntityUtil.getColumnMap(joinDto.getColumns()));
            for (RelationshipOnDto onDto : joinDto.getColumnOns()) {
                OnCondition onCondition = new OnCondition();
                onCondition.setOperatorType(onDto.getOperatorType());
                onCondition.setLeftColumn(DmlEntityUtil.getColumnEntity(onDto.getLeftColumn(), tableEntityMap.get(relationship.getTableId())));
                onCondition.setRightColumn(DmlEntityUtil.getColumnEntity(onDto.getRightColumn(), tableEntityMap.get(joinDto.getTableId())));
                onConditions.add(onCondition);
            }
            joinEntity.setJoinType(JoinTypeEnum.valueOf((String)joinDto.getJoinType()));
            joinEntity.setOnConditionList(onConditions);
            joinEntityList.add(joinEntity);
            if (!HussarUtils.isNotEmpty((Object)joinDto.getSlaveTables())) continue;
            joinEntityList.addAll(DmlEntityUtil.getJoinEntity(joinDto, columnMap, tableEntityMap));
        }
        return joinEntityList;
    }

    private static DbType getDbType(String pollName) {
        if (datasourceService == null) {
            datasourceService = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        }
        return Optional.ofNullable(pollName).map(arg_0 -> ((DynamicDatasourceService)datasourceService).getDatasourceByPoolName(arg_0)).map(AbstractHussarDataSource::getDbType).orElse(null);
    }

    public static List<WhereEntity> getWhereTree(List<WhereEntity> whereEntities) {
        if (HussarUtils.isEmpty(whereEntities)) {
            return new ArrayList<WhereEntity>();
        }
        if (whereEntities.size() == 1) {
            return whereEntities;
        }
        HashMap<Long, WhereEntity> whereMap = new HashMap<Long, WhereEntity>(whereEntities.size());
        ArrayList<WhereEntity> result = new ArrayList<WhereEntity>();
        boolean isTree = false;
        for (WhereEntity whereEntity : whereEntities) {
            if (HussarUtils.isNotEmpty((Object)whereEntity.getId())) {
                whereMap.put(whereEntity.getId(), whereEntity);
            }
            Long pId = whereEntity.getParentId();
            whereEntity.setChildren(new ArrayList<WhereEntity>());
            if (HussarUtils.isNotEmpty((Object)pId)) {
                isTree = true;
                continue;
            }
            result.add(whereEntity);
        }
        if (isTree) {
            for (WhereEntity entity : whereEntities) {
                if (!HussarUtils.isNotEmpty((Object)entity.getParentId())) continue;
                ((WhereEntity)whereMap.get(entity.getParentId())).getChildren().add(entity);
            }
        }
        return result;
    }

    public static void value(Map<String, Object> param, String propertyName, String purposeStr, String purposeRule, ParameterType parameterType, List<ModelColumnDto> columns, UserDetails userDetails) {
        PurposeEnum purpose = PurposeEnum.getByValue((String)purposeStr);
        if (param != null && propertyName != null && purpose != null) {
            boolean insert = parameterType.equals((Object)ParameterType.values);
            boolean update = parameterType.equals((Object)ParameterType.set);
            if (PurposeEnum.DEL_FLAG.equals((Object)purpose)) {
                param.put(propertyName, "0");
                return;
            }
            if (insert) {
                Optional<UserDetails> userDetailsOpt = Optional.ofNullable(userDetails);
                DmlEntityUtil.beforeClear(param, propertyName, purposeStr);
                switch (purpose) {
                    case PRIMARY: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, EngineUtil.getId());
                        break;
                    }
                    case CREATE_TIME: 
                    case UPDATE_TIME: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, LocalDateTime.now());
                        break;
                    }
                    case CREATE_USER: 
                    case UPDATE_USER: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, userDetailsOpt.map(UserDetails::getUserId).orElse(null));
                        break;
                    }
                    case CREATE_USER_NAME: 
                    case UPDATE_USER_NAME: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, userDetailsOpt.map(UserDetails::getUserName).orElse(null));
                        break;
                    }
                    case DATA_HOLDER: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, userDetailsOpt.map(UserDetails::getUserId).orElse(null));
                        break;
                    }
                    case DATA_ORGAN: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, userDetailsOpt.map(x -> x.getExtendUserMap().get(userDetailDeptId)).orElse(null));
                        break;
                    }
                    case DATA_ORGAN_NAME: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, userDetailsOpt.map(x -> x.getExtendUserMap().get(userDetailDeptName)).orElse(null));
                        break;
                    }
                    case POST: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, userDetailsOpt.map(x -> x.getExtendUserMap().get(userDetailPostId)).orElse(null));
                        break;
                    }
                    case POST_NAME: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, userDetailsOpt.map(x -> x.getExtendUserMap().get(userDetailPostName)).orElse(null));
                        break;
                    }
                    case STAFF: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, userDetailsOpt.map(x -> x.getExtendUserMap().get(userDetailStaffId)).orElse(null));
                        break;
                    }
                }
            }
            if (update) {
                DmlEntityUtil.beforeUpdateClear(param, propertyName, purposeStr);
                switch (purpose) {
                    case UPDATE_TIME: {
                        param.put(propertyName, LocalDateTime.now());
                        break;
                    }
                    case UPDATE_USER: {
                        param.put(propertyName, Optional.ofNullable(userDetails).map(UserDetails::getUserId).orElse(null));
                        break;
                    }
                    case UPDATE_USER_NAME: {
                        param.put(propertyName, Optional.ofNullable(userDetails).map(UserDetails::getUserName).orElse(null));
                        break;
                    }
                }
            }
        }
    }

    public static boolean additionalValue(Map<String, Object> param, String propertyName, List<ModelColumnsRules> titleRules, List<ModelColumnsRules> serialRules, String tfModelId, List<String> columnAliasList) {
        return DmlEntityUtil.titleValue(param, propertyName, titleRules, tfModelId, columnAliasList) | DmlEntityUtil.serialNumValue(param, propertyName, serialRules);
    }

    public static boolean titleValue(Map<String, Object> param, String propertyName, List<ModelColumnsRules> rules, String tfModelId, List<String> columnAliasList) {
        if (rules == null || HussarUtils.isEmpty(rules) || HussarUtils.isBlank((CharSequence)propertyName) || rules.stream().noneMatch(x -> propertyName.equals(x.getColumnAlias()))) {
            return false;
        }
        Optional<ModelColumnsRules> ruleOpt = rules.stream().filter(x -> propertyName.equals(x.getColumnAlias())).findFirst();
        String value = MetaTitleRule.parseAndFormat((String)ruleOpt.get().getRuleContent(), (String)tfModelId, param, columnAliasList);
        param.put(propertyName, value);
        if (HussarUtils.isEmpty((Object)value)) {
            param.remove(propertyName);
        }
        return true;
    }

    public static boolean serialNumValue(Map<String, Object> param, String propertyName, List<ModelColumnsRules> rules) {
        if (rules == null || HussarUtils.isEmpty(rules) || HussarUtils.isBlank((CharSequence)propertyName) || rules.stream().noneMatch(x -> propertyName.equals(x.getColumnAlias()))) {
            return false;
        }
        Optional<ModelColumnsRules> ruleOpt = rules.stream().filter(x -> propertyName.equals(x.getColumnAlias())).findFirst();
        ModelSerialNumService bean = (ModelSerialNumService)SpringContextUtil.getBean(ModelSerialNumService.class);
        param.put(propertyName, bean.getSerialNum(param, ruleOpt.get()));
        return true;
    }

    private static void beforeClear(Map<String, Object> param, String propertyName, String purposeStr) {
        PurposeEnum purpose = PurposeEnum.getByValue((String)purposeStr);
        if (param != null && propertyName != null && purpose != null) {
            switch (purpose) {
                case CREATE_TIME: 
                case UPDATE_TIME: 
                case DATA_HOLDER: 
                case DATA_ORGAN: {
                    if (!HussarUtils.isNotEmpty((Object)param.get(propertyName))) break;
                    param.remove(propertyName);
                    break;
                }
            }
        }
    }

    private static void beforeUpdateClear(Map<String, Object> param, String propertyName, String purposeStr) {
        PurposeEnum purpose = PurposeEnum.getByValue((String)purposeStr);
        if (param != null && propertyName != null && purpose != null) {
            switch (purpose) {
                case UPDATE_TIME: 
                case UPDATE_USER: 
                case UPDATE_USER_NAME: {
                    if (!HussarUtils.isNotEmpty((Object)param.get(propertyName))) break;
                    param.remove(propertyName);
                    break;
                }
            }
        }
    }

    public static UpdateEntity getFlagRemoveByDel(ModelTableMappingDTO model, ModelColumnDto column, DeleteEntity deleteEntity) {
        UpdateEntity updateEntity = new UpdateEntity();
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)column, DmlEntityUtil.getTableEntity(column.getPollName(), column.getTableName()));
        SetEntity setEntity = new SetEntity();
        setEntity.setColumnEntity(columnEntity);
        setEntity.setOperatorType(OperatorType.EQ);
        setEntity.setParamColumnAlias(column.getColumnAlias());
        updateEntity.setModel(model);
        updateEntity.setSetEntityList(new ArrayList<SetEntity>(Collections.singletonList(setEntity)));
        updateEntity.setWhereEntityList(deleteEntity.getWhereEntityList());
        updateEntity.init((Map)deleteEntity.getParam());
        return updateEntity;
    }

    public static List<WhereEntity> getConditionWhere(List<EngineQueryConditionDto> conditions, ModelTableMappingDTO model, Map<String, Object> param, String pre) {
        if (HussarUtils.isEmpty(conditions) || HussarUtils.isEmpty((Object)model)) {
            return new ArrayList<WhereEntity>();
        }
        AtomicInteger paramNameSeq = new AtomicInteger(0);
        HashMap<String, ColumnEntity> columnEntityMap = new HashMap<String, ColumnEntity>();
        DmlEntityUtil.getModelColumnEntityMap(model, columnEntityMap, 1, true, null);
        return DmlEntityUtil.getConditionChildWhere(conditions, null, columnEntityMap, param, paramNameSeq, pre);
    }

    private static String getPurposeColumnName(String purpose) {
        return String.format("PURPOSE_%s", purpose);
    }

    public static void getModelColumnEntityMap(ModelTableMappingDTO model, Map<String, ColumnEntity> columnEntityMap, int type, boolean masterTablePurpose, String prefix) {
        TableEntity tableEntity = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName());
        for (ModelColumnDto column : model.getColumns()) {
            ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)column, tableEntity);
            String key = type == 1 ? entity.getColAlias() : entity.getColName();
            columnEntityMap.put(prefix == null ? key : prefix + key, entity);
            if (!masterTablePurpose || !HussarUtils.isNotEmpty((Object)column.getPurpose())) continue;
            columnEntityMap.put(DmlEntityUtil.getPurposeColumnName(column.getPurpose()), entity);
        }
        if (HussarUtils.isNotEmpty((Object)model.getSlaveTables())) {
            for (ModelTableMappingDTO slaveTable : model.getSlaveTables()) {
                if (ModelRelation.ONE_ONE.equals((Object)slaveTable.getRelation())) {
                    DmlEntityUtil.getModelColumnEntityMap(slaveTable, columnEntityMap, type, false, null);
                    continue;
                }
                DmlEntityUtil.getModelColumnEntityMap(slaveTable, columnEntityMap, type, false, slaveTable.getParamName() + ".");
            }
        }
    }

    public static void getModelColumnEntityMap(ModelTableMappingDTO model, Map<String, ColumnEntity> columnEntityMap, int type, String prefix) {
        DmlEntityUtil.getModelColumnEntityMap(model, columnEntityMap, type, false, prefix);
    }

    public static List<WhereEntity> getConditionChildWhere(List<EngineQueryConditionDto> conditions, Long parentId, Map<String, ColumnEntity> columnEntityMap, Map<String, Object> param, AtomicInteger paramNameSeq, String pre) {
        if (paramNameSeq == null) {
            paramNameSeq = new AtomicInteger(0);
        }
        ArrayList<WhereEntity> whereEntityList = new ArrayList<WhereEntity>();
        for (EngineQueryConditionDto condition : conditions) {
            if (HussarUtils.isNotEmpty((Object)condition.getChildren())) {
                Long newParentId = EngineUtil.getId();
                WhereEntity parentWhere = new WhereEntity();
                parentWhere.setId(newParentId);
                parentWhere.setParentId(parentId);
                parentWhere.setMatchType(MatchTypeEnum.getByValue((String)condition.getMatch()));
                whereEntityList.add(parentWhere);
                whereEntityList.addAll(DmlEntityUtil.getConditionChildWhere(condition.getChildren(), newParentId, columnEntityMap, param, paramNameSeq, pre));
                continue;
            }
            ColumnEntity columnEntity = Optional.ofNullable(condition.getField()).map(columnEntityMap::get).orElse(Optional.ofNullable(condition.getPurposeEnum()).map(v -> DmlEntityUtil.getPurposeColumnName(v.getValue())).map(columnEntityMap::get).orElse(null));
            if (HussarUtils.isEmpty((Object)columnEntity) || HussarUtils.isEmpty((Object)condition.getRule())) continue;
            String genParamName = Optional.ofNullable(pre).orElse("") + "MPGENVAL" + paramNameSeq.incrementAndGet();
            OperatorType operatorType = OperatorType.getByValue((String)condition.getRule());
            MatchTypeEnum matchType = MatchTypeEnum.getByValue((String)condition.getMatch());
            WhereEntity whereEntity = DmlEntityUtil.newWhereEntity(parentId, matchType, operatorType, columnEntity, genParamName, null, null);
            whereEntityList.add(whereEntity);
            Object val = OperatorType.DATE_ENUM == operatorType || OperatorType.USER_ENUM == operatorType ? DmlParamUtil.getDefaultValue((String)condition.getVal(), operatorType) : condition.getVal();
            param.put(genParamName, val);
        }
        return whereEntityList;
    }

    public static List<OrderByEntity> getColumnOrder(ModelTableMappingDTO model) {
        ArrayList<OrderByEntity> orderByEntityList = new ArrayList<OrderByEntity>();
        DmlEntityUtil.getSlaveModelOrder(model, orderByEntityList, null);
        return orderByEntityList;
    }

    public static void getColumnGroup(ModelTableMappingDTO model, List<GroupEntity> newGroupList, List<String> groupList, List<ColumnExpression> selectColumnsList) {
        ArrayList<GroupEntity> groupEntityList = new ArrayList<GroupEntity>();
        DmlEntityUtil.getSlaveModelGroup(model, groupEntityList);
        Map allGroupMap = groupEntityList.stream().collect(Collectors.toMap(o -> o.getColumnEntity().getColAlias().toUpperCase(), Function.identity(), (k1, k2) -> k1));
        DbType dbType = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName()).getDbType();
        ICustomExpressionService customExpressionService = CustomExpressionFactory.getCustomExpression((String)dbType.getDb());
        for (String item : groupList) {
            GroupEntity value = (GroupEntity)allGroupMap.get(item.toUpperCase());
            if (HussarUtils.isNotEmpty((Object)value)) {
                newGroupList.add(value);
            }
            HashMap<String, ColumnEntity> columnMap = new HashMap<String, ColumnEntity>();
            CustomExpressionEntity expressionEntity = new CustomExpressionEntity(item, null);
            expressionEntity.setColAlias(customExpressionService.buildColumnWithSymbol(item));
            ColumnEntity columnEntity = value.getColumnEntity();
            if (!HussarUtils.isNotEmpty((Object)columnEntity)) continue;
            columnMap.put(item, columnEntity);
            expressionEntity.setColumns(columnMap);
            selectColumnsList.add(expressionEntity);
        }
    }

    private static void getSlaveModelOrder(ModelTableMappingDTO model, List<OrderByEntity> orderByEntityList, String prefix) {
        TableEntity tableEntity = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName());
        for (ModelColumnDto column : model.getColumns()) {
            ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)column, tableEntity);
            entity.setColAlias(HussarUtils.isBlank((CharSequence)prefix) ? entity.getColAlias() : prefix + entity.getColAlias());
            OrderByEntity orderByEntity = new OrderByEntity();
            orderByEntity.setColumnEntity(entity);
            orderByEntity.setOrderType(OrderByType.ASC);
            orderByEntityList.add(orderByEntity);
        }
        if (HussarUtils.isNotEmpty((Object)model.getSlaveTables())) {
            for (ModelTableMappingDTO slaveTable : model.getSlaveTables()) {
                if (ModelRelation.ONE_ONE.equals((Object)slaveTable.getRelation())) {
                    DmlEntityUtil.getSlaveModelOrder(slaveTable, orderByEntityList, null);
                    continue;
                }
                DmlEntityUtil.getSlaveModelOrder(slaveTable, orderByEntityList, slaveTable.getParamName() + ".");
            }
        }
    }

    public static void getColumnAgg(ModelTableMappingDTO model, List<ColumnExpression> selectColumnsList, Map<String, String> aggMap) {
        ArrayList<ColumnEntity> columnEntityList = new ArrayList<ColumnEntity>();
        DmlEntityUtil.getSlaveColumn(model, columnEntityList);
        HashMap<String, ColumnEntity> columnEntityMap = new HashMap<String, ColumnEntity>();
        for (ColumnEntity columnEntity : columnEntityList) {
            columnEntityMap.putIfAbsent(String.valueOf(columnEntity.getColumnId()), columnEntity);
            columnEntityMap.putIfAbsent(columnEntity.getColAlias(), columnEntity);
        }
        DbType dbType = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName()).getDbType();
        ICustomExpressionService customExpressionService = CustomExpressionFactory.getCustomExpression((String)dbType.getDb());
        for (Map.Entry<String, String> entry : aggMap.entrySet()) {
            HashMap<String, ColumnEntity> columnMap = new HashMap<String, ColumnEntity>();
            String express = entry.getKey();
            String alias = entry.getValue();
            CustomExpressionEntity expressionEntity = new CustomExpressionEntity(express, null);
            expressionEntity.setColAlias(customExpressionService.buildColumnWithSymbol(alias));
            List<String> columnAliasList = expressionEntity.getColumnKeys();
            boolean discard = false;
            if (!columnAliasList.isEmpty()) {
                for (String columnAlias : columnAliasList) {
                    ColumnEntity value = (ColumnEntity)columnEntityMap.get(columnAlias);
                    if (HussarUtils.isNotEmpty((Object)value)) {
                        columnMap.put(columnAlias, value);
                        continue;
                    }
                    discard = true;
                    break;
                }
            }
            if (discard) continue;
            expressionEntity.setColumns(columnMap);
            selectColumnsList.add(expressionEntity);
        }
    }

    private static void getSlaveColumn(ModelTableMappingDTO model, List<ColumnEntity> columnEntityList) {
        TableEntity tableEntity = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName());
        for (ModelColumnDto column : model.getColumns()) {
            columnEntityList.add(DmlEntityUtil.getColumnEntity((MetadataColumnDto)column, tableEntity));
        }
        if (HussarUtils.isNotEmpty((Object)model.getSlaveTables())) {
            for (ModelTableMappingDTO slaveTable : model.getSlaveTables()) {
                if (!ModelRelation.ONE_ONE.equals((Object)slaveTable.getRelation())) continue;
                DmlEntityUtil.getSlaveColumn(slaveTable, columnEntityList);
            }
        }
    }

    private static void getSlaveModelGroup(ModelTableMappingDTO model, List<GroupEntity> groupEntityList) {
        TableEntity tableEntity = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName());
        for (ModelColumnDto column : model.getColumns()) {
            ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)column, tableEntity);
            GroupEntity orderByEntity = new GroupEntity();
            orderByEntity.setColumnEntity(entity);
            groupEntityList.add(orderByEntity);
        }
        if (HussarUtils.isNotEmpty((Object)model.getSlaveTables())) {
            for (ModelTableMappingDTO slaveTable : model.getSlaveTables()) {
                if (!ModelRelation.ONE_ONE.equals((Object)slaveTable.getRelation())) continue;
                DmlEntityUtil.getSlaveModelGroup(slaveTable, groupEntityList);
            }
        }
    }

    public static EngineBackVerifyContent getEngineBackVerifyContent(Map<String, Object> param, NodeBusinessVo businessVo) {
        EngineBackVerifyContent content = new EngineBackVerifyContent();
        content.setInparams(JsonUtil.readList((String)JSON.toJSONString((Object)param.get("value")), EngineBackVerifyDto.class));
        content.setColumnList(businessVo.getJsonParams());
        ModelTableMappingDTO modelTable = DmlEntityUtil.getModelTable(businessVo);
        content.setDmlServiceEntity(new DmlServiceEntity(modelTable));
        content.setModel(modelTable);
        return content;
    }

    public static ResultMap getResultMapByModels(ModelTableMappingDTO master, ModelTableMappingDTO ... slaves) {
        try {
            Configuration configuration = ((SqlSessionFactory)SpringContextUtil.getBean(SqlSessionFactory.class)).getConfiguration();
            ArrayList resultMappings = new ArrayList();
            for (ModelTableMappingDTO slave : slaves) {
                resultMappings.addAll(ModelResultMapUtil.getResultMappings((ModelTableMappingDTO)slave, (Boolean)false, (Configuration)configuration));
            }
            resultMappings.addAll(ModelResultMapUtil.getResultMappings((ModelTableMappingDTO)master, (Boolean)true, (Configuration)configuration));
            return ModelResultMapUtil.getResultMap((String)String.format("ms_rev.%s", master.getRelatedId()), resultMappings, (Configuration)configuration);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static void reduceRedundantSlave(ModelTableMappingDTO modelTableMappingDTO) {
        for (ModelTableMappingDTO slaveTable : modelTableMappingDTO.getSlaveTables()) {
            for (ModelTableMappingDTO table : slaveTable.getSlaveTables()) {
                table.setSlaveTables(new ArrayList());
            }
        }
    }

    static {
        userDetailDeptName = "deptName";
        userDetailDeptId = "deptId";
        userDetailStaffId = "staffId";
        userDetailPostId = "postId";
        userDetailPostName = "postName";
    }

    public static class DmlServiceEntity {
        private ModelTableMappingDTO model;
        private TableEntity tableEntity;
        private List<MetadataColumnDto> columnDtoList;
        private Map<Long, MetadataColumnDto> columnDtoMap;
        private MetadataColumnDto delFlagColumn;
        private MetadataColumnDto pkColumn;
        private MetadataColumnDto fkColumn;

        public DmlServiceEntity(ModelTableMappingDTO model) {
            this.model = model;
            this.columnDtoList = new ArrayList<MetadataColumnDto>();
            this.tableEntity = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName());
            for (ModelColumnDto column : model.getColumns()) {
                this.columnDtoList.add((MetadataColumnDto)column);
                if (HussarUtils.isNotEmpty((Object)column.getPrimarys())) {
                    this.pkColumn = column;
                    this.tableEntity.setKeyProperty(column.getTableAlias());
                }
                if (!PurposeEnum.DEL_FLAG.getValue().equals(column.getPurpose())) continue;
                this.delFlagColumn = column;
            }
        }

        public DmlServiceEntity(ModelTableMappingDTO model, MetadataColumnDto fkColumn) {
            this(model);
            this.fkColumn = fkColumn;
        }

        public ModelTableMappingDTO getModel() {
            return this.model;
        }

        public UpdateEntity updateById() {
            UpdateEntity entity = this.getUpdateBuilder();
            ArrayList<SetEntity> list = new ArrayList<SetEntity>();
            for (MetadataColumnDto columnDto : this.columnDtoList) {
                SetEntity setEntity = this.getSetEntity(columnDto);
                list.add(setEntity);
            }
            entity.setSetEntityList(list);
            entity.setWhereEntityList(this.getWhere(this.pkColumn, OperatorType.EQ));
            return entity;
        }

        private SetEntity getSetEntity(MetadataColumnDto columnDto) {
            SetEntity setEntity = new SetEntity();
            setEntity.setColumnEntity(DmlEntityUtil.getColumnEntity(columnDto, this.tableEntity));
            setEntity.setParamColumnAlias(columnDto.getColumnAlias());
            setEntity.setOperatorType(OperatorType.EQ);
            return setEntity;
        }

        private UpdateEntity getUpdateBuilder() {
            UpdateEntity builder = new UpdateEntity().builder();
            builder.setModel(this.model);
            return builder;
        }

        public InsertEntity insert() {
            InsertEntity entity = this.getInsertBuilder();
            ArrayList<ValueEntity> list = new ArrayList<ValueEntity>();
            for (MetadataColumnDto columnDto : this.columnDtoList) {
                ValueEntity setEntity = new ValueEntity();
                setEntity.setColumnEntity(DmlEntityUtil.getColumnEntity(columnDto, this.tableEntity));
                setEntity.setParamColumnAlias(columnDto.getColumnAlias());
                list.add(setEntity);
            }
            entity.setValueEntityList(list);
            return entity;
        }

        private InsertEntity getInsertBuilder() {
            InsertEntity builder = new InsertEntity().builder();
            builder.setModel(this.model);
            return builder;
        }

        public SelectEntity selectById(Object id) {
            SelectEntity entity = this.getSelectBuilder();
            entity.setUnIntuition(true);
            List<ColumnEntity> list = this.getColumns();
            entity.setSelectColumnsList(list);
            entity.setWhereEntityList(this.getWhere(this.pkColumn, OperatorType.EQ));
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(this.pkColumn.getColumnAlias(), id);
            entity.init(param);
            return entity;
        }

        public SelectEntity selectAll() {
            SelectEntity entity = this.getSelectBuilder();
            List<ColumnEntity> list = this.getColumns();
            entity.setSelectColumnsList(list);
            return entity;
        }

        public SelectEntity selectByIds() {
            SelectEntity entity = this.getSelectBuilder();
            List<ColumnEntity> list = this.getColumns();
            entity.setSelectColumnsList(list);
            entity.setWhereEntityList(this.getWhere(this.pkColumn, OperatorType.IN));
            return entity;
        }

        private SelectEntity getSelectBuilder() {
            SelectEntity builder = new SelectEntity().builder();
            builder.setModel(this.model);
            builder.setResultMapId("single." + this.model.getRelatedId());
            return builder;
        }

        public SelectEntity selectByFkId() {
            HussarException.throwByNull((Object)this.fkColumn, (String)"\u5916\u952e\u5217\u4e0d\u80fd\u4e3a\u7a7a");
            SelectEntity entity = this.getSelectBuilder();
            List<ColumnEntity> list = this.getColumns();
            entity.setSelectColumnsList(list);
            entity.setWhereEntityList(this.getWhere(this.fkColumn, OperatorType.EQ));
            return entity;
        }

        public SelectEntity selectByFkId(Object id) {
            HussarException.throwByNull((Object)this.fkColumn, (String)"\u5916\u952e\u5217\u4e0d\u80fd\u4e3a\u7a7a");
            SelectEntity entity = this.getSelectBuilder();
            List<ColumnEntity> list = this.getColumns();
            entity.setSelectColumnsList(list);
            entity.setWhereEntityList(this.getWhere(this.fkColumn, OperatorType.EQ));
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(this.fkColumn.getColumnAlias(), id);
            entity.init(param);
            return entity;
        }

        public SelectEntity selectByFkIds() {
            if (HussarUtils.isEmpty((Object)this.fkColumn)) {
                return null;
            }
            SelectEntity entity = this.getSelectBuilder();
            List<ColumnEntity> list = this.getColumns();
            entity.setSelectColumnsList(list);
            entity.setWhereEntityList(this.getWhere(this.fkColumn, OperatorType.IN));
            return entity;
        }

        public SelectEntity selectByColumns(Map<Long, Object> columnId2Value) {
            return this.selectByColumns(columnId2Value, MatchTypeEnum.AND);
        }

        public SelectEntity selectByColumns(Map<Long, Object> columnId2Value, MatchTypeEnum matchTypeEnum) {
            if (HussarUtils.isEmpty(columnId2Value)) {
                return null;
            }
            Map<Long, MetadataColumnDto> id2Column = this.getColumnDtoMap();
            ArrayList<WhereEntity> whereList = new ArrayList<WhereEntity>();
            HashMap params = new HashMap();
            columnId2Value.forEach((columnId, value) -> {
                if (id2Column.containsKey(columnId)) {
                    if (value == null) {
                        whereList.addAll(this.getWhere((MetadataColumnDto)id2Column.get(columnId), OperatorType.IS_NULL, matchTypeEnum));
                    } else {
                        whereList.addAll(this.getWhere((MetadataColumnDto)id2Column.get(columnId), OperatorType.EQ, matchTypeEnum));
                    }
                    params.put(((MetadataColumnDto)id2Column.get(columnId)).getColumnAlias(), value);
                }
            });
            if (HussarUtils.isNotEmpty(whereList)) {
                Long newParentId = EngineUtil.getId();
                WhereEntity parentWhere = new WhereEntity();
                parentWhere.setId(newParentId);
                parentWhere.setMatchType(MatchTypeEnum.AND);
                whereList.forEach(w -> {
                    if (w.getParentId() == null) {
                        w.setParentId(newParentId);
                    }
                });
                whereList.add(parentWhere);
                SelectEntity entity = this.getSelectBuilder();
                List<ColumnEntity> list = this.getColumns();
                entity.setSelectColumnsList(list);
                entity.setModel(this.model);
                entity.setWhereEntityList(whereList);
                entity.init((Map)params);
                return entity;
            }
            return null;
        }

        public SelectEntity selectMsTableByColumns(ModelTableMappingDTO modelTable, Map<Long, Object> columnId2Value) {
            return this.selectMsTableByColumns(modelTable, columnId2Value, MatchTypeEnum.AND);
        }

        public SelectEntity selectMsTableByColumns(ModelTableMappingDTO modelTable, Map<Long, Object> columnId2Value, MatchTypeEnum matchTypeEnum) {
            if (HussarUtils.isEmpty(columnId2Value)) {
                return null;
            }
            Map<Long, MetadataColumnDto> id2Column = this.getMsTableColumnDtoMap();
            ArrayList<WhereEntity> whereList = new ArrayList<WhereEntity>();
            HashMap params = new HashMap();
            columnId2Value.forEach((columnId, value) -> {
                if (id2Column.containsKey(columnId)) {
                    if (value == null) {
                        whereList.addAll(this.getWhere((MetadataColumnDto)id2Column.get(columnId), OperatorType.IS_NULL, matchTypeEnum));
                    } else {
                        whereList.addAll(this.getWhere((MetadataColumnDto)id2Column.get(columnId), OperatorType.EQ, matchTypeEnum));
                    }
                    params.put(((MetadataColumnDto)id2Column.get(columnId)).getColumnAlias(), value);
                }
            });
            HashMap columnMap = new HashMap(DmlEntityUtil.getColumnMap(modelTable.getColumns()));
            HashMap<Long, TableEntity> tableEntityMap = new HashMap<Long, TableEntity>();
            TableEntity tableEntity = DmlEntityUtil.getTableEntity(modelTable.getPollName(), modelTable.getTableName());
            tableEntityMap.put(modelTable.getTableId(), tableEntity);
            List joinEntityList = DmlEntityUtil.getJoinEntity(modelTable, columnMap, tableEntityMap);
            SelectEntity entity = this.getSelectBuilder();
            List<ColumnEntity> list = this.getMsTableColumns();
            entity.setSelectColumnsList(list);
            entity.setModel(this.model);
            entity.setJoinEntityList(joinEntityList);
            if (HussarUtils.isNotEmpty(whereList)) {
                entity.setWhereEntityList(whereList);
            }
            entity.init((Map)params);
            return entity;
        }

        public Map<Long, MetadataColumnDto> getMsTableColumnDtoMap() {
            List allColumns = this.model.getAllColumns();
            if (HussarUtils.isNotEmpty((Object)allColumns)) {
                this.columnDtoMap = allColumns.stream().collect(Collectors.toMap(MetadataColumn::getColumnId, Function.identity()));
            }
            return this.columnDtoMap;
        }

        public Map<Long, MetadataColumnDto> getColumnDtoMap() {
            if (this.columnDtoMap == null) {
                this.columnDtoMap = this.columnDtoList.stream().collect(Collectors.toMap(MetadataColumn::getColumnId, Function.identity()));
            }
            return this.columnDtoMap;
        }

        private List<ColumnEntity> getColumns() {
            ArrayList<ColumnEntity> list = new ArrayList<ColumnEntity>();
            for (MetadataColumnDto columnDto : this.columnDtoList) {
                ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, this.tableEntity);
                list.add(columnEntity);
            }
            return list;
        }

        private List<ColumnEntity> getMsTableColumns() {
            ArrayList<ColumnEntity> list = new ArrayList<ColumnEntity>();
            for (MetadataColumnDto columnDto : this.model.getAllColumns()) {
                TableEntity tableEntity = DmlEntityUtil.getTableEntity(columnDto.getPollName(), columnDto.getTableName());
                ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
                list.add(columnEntity);
            }
            return list;
        }

        public InsertEntity save() {
            InsertEntity entity = this.getInsertBuilder();
            ArrayList<ValueEntity> list = new ArrayList<ValueEntity>();
            for (MetadataColumnDto columnDto : this.columnDtoList) {
                ValueEntity valueEntity = new ValueEntity();
                valueEntity.setColumnEntity(DmlEntityUtil.getColumnEntity(columnDto, this.tableEntity));
                valueEntity.setParamColumnAlias(columnDto.getColumnAlias());
                list.add(valueEntity);
            }
            entity.setValueEntityList(list);
            return entity;
        }

        public DeleteEntity removeByIds() {
            DeleteEntity entity = this.getDelBuilder();
            entity.setWhereEntityList(this.getWhere(this.pkColumn, OperatorType.IN));
            return entity;
        }

        public DeleteEntity removeIn(MetadataColumnDto columnDto, ModelTableMappingDTO model) {
            DeleteEntity entity = this.getDelBuilder();
            entity.setRelationship(model);
            entity.setWhereEntityList(this.getWhere(columnDto, OperatorType.IN));
            return entity;
        }

        public DeleteEntity removeByFkIds() {
            if (HussarUtils.isEmpty((Object)this.fkColumn)) {
                return null;
            }
            DeleteEntity entity = this.getDelBuilder();
            entity.setWhereEntityList(this.getWhere(this.fkColumn, OperatorType.IN));
            return entity;
        }

        public DeleteEntity removeByFkIds(final List<Object> ids) {
            DeleteEntity entity = this.removeByFkIds();
            return entity.init(new HashMap<String, Object>(){
                {
                    this.put(fkColumn.getColumnAlias(), ids);
                }
            });
        }

        private DeleteEntity getDelBuilder() {
            return new DeleteEntity().builder();
        }

        private List<WhereEntity> getWhere(MetadataColumnDto columnDto, OperatorType operatorType) {
            return this.getWhere(columnDto, operatorType, MatchTypeEnum.AND);
        }

        private List<WhereEntity> getWhere(MetadataColumnDto columnDto, OperatorType operatorType, MatchTypeEnum matchTypeEnum) {
            if (columnDto == null || operatorType == null) {
                return new ArrayList<WhereEntity>();
            }
            TableEntity tableEntity = DmlEntityUtil.getTableEntity(columnDto.getPollName(), columnDto.getTableName());
            final WhereEntity whereEntity = new WhereEntity();
            ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
            whereEntity.setColumnEntity(columnEntity);
            whereEntity.setOperatorType(operatorType);
            whereEntity.setMatchType(matchTypeEnum);
            whereEntity.setParamColumnAlias(columnDto.getColumnAlias());
            return new ArrayList<WhereEntity>(){
                {
                    this.add(whereEntity);
                }
            };
        }

        public MetadataColumnDto getPkColumn() {
            return this.pkColumn;
        }

        public MetadataColumnDto getFkColumn() {
            return this.fkColumn;
        }

        public DeleteEntity removeByIds(final List<Object> ids) {
            DeleteEntity entity = this.removeByIds();
            return entity.init(new HashMap<String, Object>(){
                {
                    this.put(pkColumn.getColumnAlias(), ids);
                }
            });
        }

        public UpdateEntity flagRemoveByIds(final List<Object> ids) {
            UpdateEntity entity = this.getUpdateBuilder();
            SetEntity setEntity = this.getSetEntity(this.delFlagColumn);
            entity.setSetEntityList(new ArrayList<SetEntity>(Collections.singletonList(setEntity)));
            entity.setWhereEntityList(this.getWhere(this.pkColumn, OperatorType.IN));
            return entity.init(new HashMap<String, Object>(){
                {
                    this.put(pkColumn.getColumnAlias(), ids);
                }
            });
        }

        public SelectEntity selectByFkIds(final List<Object> ids) {
            SelectEntity entity = this.selectByFkIds();
            return entity.init(new HashMap<String, Object>(){
                {
                    this.put(fkColumn.getColumnAlias(), ids);
                }
            });
        }

        public UpdateEntity flagRemoveFkIds(final List<Object> ids) {
            if (HussarUtils.isEmpty((Object)this.fkColumn)) {
                return null;
            }
            UpdateEntity entity = this.getUpdateBuilder();
            SetEntity setEntity = this.getSetEntity(this.delFlagColumn);
            entity.setSetEntityList(new ArrayList<SetEntity>(Collections.singletonList(setEntity)));
            entity.setWhereEntityList(this.getWhere(this.fkColumn, OperatorType.IN));
            return entity.init(new HashMap<String, Object>(){
                {
                    this.put(fkColumn.getColumnAlias(), ids);
                }
            });
        }

        public boolean hasDelFlag() {
            return HussarUtils.isNotEmpty((Object)this.delFlagColumn);
        }
    }
}

