/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.intercepts;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomResultMap;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IModelResultMapService;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.springframework.context.annotation.Lazy;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class EngineResultIntercept
implements Interceptor {
    private static final String MAPPED_STATEMENT = "mappedStatement";
    private static List<String> includeEngineMappers = new ArrayList<String>();
    @Resource
    @Lazy
    private IModelResultMapService modelResultMapService;

    private static <T> T findParameter(Object parameterObject, Class<T> clazz) {
        if (parameterObject != null) {
            if (parameterObject instanceof Map) {
                for (Object entry : ((Map)parameterObject).values()) {
                    if (entry == null || !clazz.isAssignableFrom(entry.getClass())) continue;
                    return (T)entry;
                }
            } else if (clazz.isAssignableFrom(parameterObject.getClass())) {
                return (T)parameterObject;
            }
        }
        return null;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        ResultMap resultMap;
        ResultSetHandler target = (ResultSetHandler)invocation.getTarget();
        this.initResultSetHandler(target, invocation);
        List results = (List)invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }
        ResultSetHandler resultSetHandler = (ResultSetHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)resultSetHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPED_STATEMENT);
        ResultMap resultMap2 = resultMap = mappedStatement.getResultMaps().isEmpty() ? null : (ResultMap)mappedStatement.getResultMaps().get(0);
        if (HussarUtils.isEmpty(resultMap) || !includeEngineMappers.contains(mappedStatement.getId()) && !resultMap.getId().startsWith("ms.")) {
            return results;
        }
        this.handleColumnMapping(mappedStatement, resultMap, results);
        return results;
    }

    private void initResultSetHandler(ResultSetHandler target, Invocation invocation) {
        MetaObject rh = SystemMetaObject.forObject((Object)(target = (ResultSetHandler)PluginUtils.realTarget((Object)target)));
        ParameterHandler parameterHandler = (ParameterHandler)rh.getValue("parameterHandler");
        if (HussarUtils.isEmpty((Object)parameterHandler.getParameterObject())) {
            return;
        }
        CustomResultMap customSql = EngineResultIntercept.findParameter(parameterHandler.getParameterObject(), CustomResultMap.class);
        if (customSql != null) {
            ResultMap resultMap = customSql.getResultMap();
            this.updateMappedStatement(rh, resultMap, customSql, invocation);
        }
    }

    private void updateMappedStatement(MetaObject rh, ResultMap customResultMap, CustomResultMap customSql, Invocation invocation) {
        ResultMap resultMap;
        MappedStatement ms = (MappedStatement)rh.getValue(MAPPED_STATEMENT);
        if (this.isPageCountSelect(ms)) {
            return;
        }
        Configuration configuration = ms.getConfiguration();
        configuration.setCallSettersOnNulls(true);
        if (customResultMap == null) {
            ModelTableMappingDTO model;
            String resultMapId;
            MetaObject selectEntity = configuration.newMetaObject((Object)customSql);
            if (!selectEntity.hasGetter("resultMapId") || (resultMapId = (String)selectEntity.getValue("resultMapId")) == null) {
                return;
            }
            if (selectEntity.hasGetter("model") && (model = (ModelTableMappingDTO)selectEntity.getValue("model")) != null) {
                this.modelResultMapService.createResultMap(model);
            }
            customResultMap = configuration.getResultMap(resultMapId);
        }
        if ((resultMap = customResultMap) == null) {
            return;
        }
        MappedStatement.Builder builder = new MappedStatement.Builder(configuration, ms.getId(), ms.getSqlSource(), ms.getSqlCommandType());
        builder.resultMaps(Collections.singletonList(resultMap));
        MappedStatement mappedStatement = builder.build();
        rh.setValue(MAPPED_STATEMENT, (Object)mappedStatement);
        try {
            customSql.callback(rh, mappedStatement, (Statement)invocation.getArgs()[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isPageCountSelect(MappedStatement ms) {
        return ((ResultMap)ms.getResultMaps().get(0)).getId().equals("mybatis-plus");
    }

    private void handleColumnMapping(MappedStatement mappedStatement, ResultMap resultMap, List<Object> results) {
        List propertyResultMappings = resultMap.getPropertyResultMappings();
        if (HussarUtils.isEmpty((Object)propertyResultMappings)) {
            return;
        }
        Map propertyResultMappingMap = propertyResultMappings.stream().collect(Collectors.toMap(ResultMapping::getProperty, Function.identity(), (k1, k2) -> k1));
        for (Object obj : results) {
            String[] getterNames;
            if (obj == null) continue;
            MetaObject objMetaObject = mappedStatement.getConfiguration().newMetaObject(obj);
            for (String getterName : getterNames = objMetaObject.getGetterNames()) {
                Object value = objMetaObject.getValue(getterName);
                if (value instanceof List) {
                    String nestedResultMapId = ((ResultMapping)propertyResultMappingMap.get(getterName)).getNestedResultMapId();
                    ResultMap singleResultMap = mappedStatement.getConfiguration().getResultMap(nestedResultMapId);
                    this.handleColumnMapping(mappedStatement, singleResultMap, (List)value);
                    continue;
                }
                if (propertyResultMappingMap.containsKey(getterName)) continue;
                objMetaObject.setValue(getterName.substring(2), value);
            }
        }
    }

    static {
        includeEngineMappers.add("com.jxdinfo.hussar.support.engine.plugin.dml.dao.DmlMapper.selectList");
        includeEngineMappers.add("com.jxdinfo.hussar.support.engine.plugin.dml.dao.DmlMapper.selectPage");
    }
}

