/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.dto;

import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.plugin.dml.dto.EngineBackVerifyDto;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import java.util.List;
import java.util.stream.Collectors;

public class EngineBackVerifyContent {
    private List<EngineBackVerifyDto> inparams;
    private List<ColumnRule> columnList;
    private DmlEntityUtil.DmlServiceEntity dmlServiceEntity;
    private ModelTableMappingDTO model;

    public List<EngineBackVerifyDto> getInparams() {
        return this.inparams;
    }

    public void setInparams(List<EngineBackVerifyDto> inparams) {
        this.inparams = inparams;
    }

    public List<ColumnRule> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String columnList) {
        this.columnList = JsonUtil.readList((String)columnList, ColumnRule.class);
    }

    public DmlEntityUtil.DmlServiceEntity getDmlServiceEntity() {
        return this.dmlServiceEntity;
    }

    public void setDmlServiceEntity(DmlEntityUtil.DmlServiceEntity dmlServiceEntity) {
        this.dmlServiceEntity = dmlServiceEntity;
    }

    public ModelTableMappingDTO getModel() {
        return this.model;
    }

    public void setModel(ModelTableMappingDTO model) {
        this.model = model;
    }

    public DmlEntityUtil.DmlServiceEntity getDmlServiceEntity(Long modelId) {
        if (modelId == null || this.model.getRelatedId().equals(modelId)) {
            return this.dmlServiceEntity;
        }
        for (ModelTableMappingDTO slaveTable : this.model.getSlaveTables()) {
            if (!slaveTable.getRelatedId().equals(modelId)) continue;
            return new DmlEntityUtil.DmlServiceEntity(slaveTable);
        }
        return this.dmlServiceEntity;
    }

    public static class Rule {
        private String type;
        private Long columnId;
        private Long modelId;
        private String errorMsg;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Long getColumnId() {
            return this.columnId;
        }

        public void setColumnId(Long columnId) {
            this.columnId = columnId;
        }

        public Long getModelId() {
            return this.modelId;
        }

        public void setModelId(Long modelId) {
            this.modelId = modelId;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }
    }

    public static class ColumnRule {
        private String columnName;
        private List<Rule> rules;

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public List<Rule> getRules() {
            return this.rules;
        }

        public void setRules(List<Rule> rules) {
            this.rules = rules;
        }

        public List<Rule> getRulesByType(String type) {
            return this.rules.stream().filter(rule -> rule.getType().equals(type)).collect(Collectors.toList());
        }
    }
}

