/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.select.ColumnExpression;
import java.util.List;

public class ExpressionColumnEntity
implements ColumnExpression {
    private String functionName;
    private List<ColumnExpression> parameters;
    private boolean distinct;
    private String colAlias;
    private String colJavaType;

    public ExpressionColumnEntity(String functionName, List<ColumnExpression> parameters, boolean distinct, String colAlias, String colJavaType) {
        this.functionName = functionName;
        this.parameters = parameters;
        this.distinct = distinct;
        this.colAlias = colAlias;
        this.colJavaType = colJavaType;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public List<ColumnExpression> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ColumnExpression> parameters) {
        this.parameters = parameters;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public String getColAlias() {
        return this.colAlias;
    }

    public void setColAlias(String colAlias) {
        this.colAlias = colAlias;
    }

    public String getColJavaType() {
        return this.colJavaType;
    }

    public void setColJavaType(String colJavaType) {
        this.colJavaType = colJavaType;
    }

    @Override
    public String getColumnSql(boolean tableAlias) {
        return this.getColumnSqlNoAs(tableAlias) + " " + this.colAlias;
    }

    @Override
    public String getColumnSqlNoAs(boolean tableAlias) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.functionName).append("(");
        if (this.distinct) {
            sql.append("DISTINCT ");
        }
        if (HussarUtils.isNotEmpty(this.parameters)) {
            for (ColumnExpression parameter : this.parameters) {
                sql.append(parameter.getColumnSqlNoAs(tableAlias)).append(",").append(" ");
            }
            sql.delete(sql.length() - 2, sql.length());
        }
        sql.append(")");
        return sql.toString();
    }
}

