/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.sql;

import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.support.engine.api.enums.ConditionType;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.SetEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlParamUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhereEntity
extends SetEntity {
    private Long id;
    private Long parentId;
    private MatchTypeEnum matchType;
    private List<WhereEntity> children;
    private ConditionType conditionType;
    private String defaultValue;
    private String setSql;

    @Override
    public void processingParam() {
        this.operatorSql();
    }

    private void operatorSql() {
        String sql;
        if (this.getOperatorType() == null) {
            return;
        }
        Object val = this.getVal();
        switch (this.getOperatorType()) {
            case BOOLEAN_FALSE: {
                this.setSql = "1 " + OperatorType.BOOLEAN_FALSE.getKeyword().getSqlSegment() + " 1";
                return;
            }
            case IN: 
            case NOT_IN: 
            case USER_IN: 
            case USER_NOT_IN: {
                if (this.isNoll()) {
                    return;
                }
                Map<String, Object> map = this.getEnableCollectionValue(val);
                StringBuilder valueSql = new StringBuilder();
                valueSql.append("(");
                int i = 0;
                for (String colAlias : map.keySet()) {
                    if (i != 0) {
                        valueSql.append(",");
                    }
                    valueSql.append("#{").append(this.getValueAlias()).append(".").append(colAlias).append("}");
                    ++i;
                }
                valueSql.append(")");
                sql = valueSql.toString();
                break;
            }
            case LIKE: 
            case NOT_LIKE: 
            case LEFT_LIKE: 
            case RIGHT_LIKE: 
            case NOT_RIGHT_LIKE: 
            case NOT_LEFT_LIKE: {
                if (this.isNoll()) {
                    return;
                }
                this.getColumnEntity().setColJavaType(String.class.getName());
                if (!this.getParamColumnAlias().endsWith(this.getOperatorType().getValue())) {
                    this.setVal(DmlSqlUtil.concatLike(DmlParamUtil.resolveParameter(this.getVal()), this.getOperatorType()));
                    this.setParamColumnAlias(this.getParamColumnAlias() + this.getOperatorType().getValue());
                }
                sql = this.sql() + " ESCAPE '|'";
                break;
            }
            case USER_MULTI_LIKE: 
            case MULTI_LIKE: {
                if (this.isNoll()) {
                    return;
                }
                Map<String, Object> map = this.getEnableCollectionValue(val);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    entry.setValue(SqlUtils.concatLike((Object)("," + entry.getValue() + ","), (SqlLike)SqlLike.DEFAULT));
                }
                StringBuilder valueSql = new StringBuilder();
                valueSql.append("(");
                String colName = String.format("CONCAT(',', CONCAT(%s, ','))", this.getColumnEntity().getTableAliasAndColName());
                int i = 0;
                for (String colAlias : map.keySet()) {
                    if (i != 0) {
                        valueSql.append(" OR ");
                    }
                    valueSql.append(" ").append(colName).append(" ").append(this.getOperatorType().getKeyword().getSqlSegment()).append(" ");
                    valueSql.append("#{").append(this.getValueAlias()).append(".").append(colAlias).append("}");
                    ++i;
                }
                valueSql.append(")");
                this.setSql = valueSql.toString();
                return;
            }
            case NOT_BETWEEN: 
            case BETWEEN: 
            case DATE_ENUM: {
                if (this.isNoll()) {
                    return;
                }
                sql = this.getBetweenSql();
                break;
            }
            case IS_NOT_NULL: 
            case IS_NULL: {
                sql = "";
                break;
            }
            default: {
                sql = this.sql();
            }
        }
        this.setSql = String.format(" %s %s %s ", this.getColumnEntity().getColNameEnableEscape(), this.getOperatorType().getKeyword().getSqlSegment(), sql);
    }

    private String getBetweenSql() {
        this.getEnableCollectionValue(this.getVal());
        StringBuilder valueSql = new StringBuilder();
        valueSql.append("#{").append(this.getValueAlias()).append(".").append("v0").append("}");
        valueSql.append(" AND ");
        valueSql.append("#{").append(this.getValueAlias()).append(".").append("v1").append("}");
        return valueSql.toString();
    }

    private Map<String, Object> getEnableCollectionValue(Object val) {
        HashMap map;
        if (val instanceof Map) {
            map = (HashMap)val;
        } else {
            Class<?> name = DmlSqlUtil.getColumnClass(this.getColumnEntity());
            map = new HashMap();
            List inValues = (List)val;
            for (int i = 0; i < inValues.size(); ++i) {
                String colAlias = "v" + i;
                Object item = inValues.get(i);
                map.put(colAlias, name != null && name != item.getClass() ? HussarConverter.convert(name, item) : item);
            }
            this.setParamColumnAlias(this.getParamColumnAlias() + this.getOperatorType().getValue());
            this.setVal(map);
        }
        return map;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public MatchTypeEnum getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchTypeEnum matchType) {
        this.matchType = matchType;
    }

    public List<WhereEntity> getChildren() {
        return this.children;
    }

    public void setChildren(List<WhereEntity> children) {
        this.children = children;
    }

    public ConditionType getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(ConditionType conditionType) {
        this.conditionType = conditionType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isNoll() {
        if (OperatorType.IS_NULL.equals((Object)this.getOperatorType()) || OperatorType.IS_NOT_NULL.equals((Object)this.getOperatorType()) || OperatorType.BOOLEAN_FALSE.equals((Object)this.getOperatorType())) {
            return false;
        }
        return super.isNoll();
    }

    @Override
    public String getSetSql() {
        return this.setSql;
    }
}

