/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.sql;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.platform.core.utils.date.DateUtil;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.UserEnum;
import com.jxdinfo.hussar.support.engine.core.service.EngineUserDetails;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.select.CustomExpressionEntity;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

public class ValueEntity {
    private ColumnEntity columnEntity;
    private String paramColumnAlias;
    private Object val;
    private CustomExpressionEntity expressionEntity;
    private String expressionValue;
    private boolean enableCollection;
    private boolean enableUser;

    private static boolean handlerUserListVal(List list, EngineUserDetails user) {
        if (user == null) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            UserEnum userEnum;
            Object item = list.get(i);
            if (!(item instanceof String) || (userEnum = UserEnum.getByValue((String)((String)item))) == null) continue;
            item = userEnum.getAction().apply(user);
            if (item instanceof List) {
                if (HussarUtils.isNotEmpty(item)) {
                    list.addAll((List)item);
                }
            } else if (item != null) {
                list.add(item);
            }
            list.remove(i);
            return true;
        }
        return false;
    }

    public boolean isNoll() {
        return HussarUtils.isEmpty((Object)this.val);
    }

    String getValueAlias() {
        return "et.param." + this.paramColumnAlias;
    }

    public ColumnEntity getColumnEntity() {
        return this.columnEntity;
    }

    public void setColumnEntity(ColumnEntity columnEntity) {
        this.columnEntity = columnEntity;
    }

    public CustomExpressionEntity getExpressionEntity() {
        return this.expressionEntity;
    }

    public void setExpressionEntity(CustomExpressionEntity expressionEntity) {
        this.expressionEntity = expressionEntity;
    }

    public boolean isEnableCollection() {
        return this.enableCollection;
    }

    public void setEnableCollection(boolean enableCollection) {
        this.enableCollection = enableCollection;
    }

    public boolean isEnableUser() {
        return this.enableUser;
    }

    public void setEnableUser(boolean enableUser) {
        this.enableUser = enableUser;
    }

    public void initVal(Map<String, Object> param) {
        if (this.expressionEntity != null) {
            param.putIfAbsent(this.paramColumnAlias, 1);
            this.processingParam();
        } else {
            this.setVal(param.get(this.paramColumnAlias));
            this.processingParam();
            param.put(this.paramColumnAlias, this.getVal());
        }
    }

    public void processingParam() {
    }

    public void resetOperatorType(OperatorType operatorType) {
    }

    public String getParamColumnAlias() {
        return this.paramColumnAlias;
    }

    public void setParamColumnAlias(String paramColumnAlias) {
        this.paramColumnAlias = paramColumnAlias;
    }

    public Object getVal() {
        return this.val;
    }

    public void setVal(Object val) {
        if (val == null || "".equals(val)) {
            this.val = null;
            return;
        }
        if (this.enableCollection) {
            if (val instanceof Map) {
                this.val = val;
            } else {
                this.val = val instanceof List ? val : (StringUtil.startsWithIgnoreCase((String)val.toString(), (String)"[") ? JSON.parseObject((String)val.toString(), List.class) : HussarConverter.convert(List.class, (Object)val));
                if (this.enableUser) {
                    List list = (List)this.val;
                    EngineUserDetails user = EngineUtil.getEngineUser();
                    boolean userHandle = ValueEntity.handlerUserListVal(list, user);
                    if (userHandle && HussarUtils.isEmpty((Object)list)) {
                        this.resetOperatorType(OperatorType.BOOLEAN_FALSE);
                        return;
                    }
                    if (HussarUtils.isEmpty((Object)list)) {
                        this.val = null;
                    }
                }
            }
        } else {
            UserValue userValue = this.userValTrans(val);
            if (userValue.isUserVal() && userValue.getValue() == null) {
                this.resetOperatorType(OperatorType.BOOLEAN_FALSE);
                return;
            }
            val = userValue.getValue();
            if (this.columnEntity.getColJavaType() != null && !this.columnEntity.getColJavaType().equals(val.getClass().getName())) {
                if (val instanceof Map) {
                    this.val = val;
                } else {
                    try {
                        Class<?> type = Class.forName(this.columnEntity.getColJavaType());
                        if (LocalDateTime.class.equals(type)) {
                            String dateStr = String.valueOf(val);
                            if ("yyyy".length() == dateStr.length()) {
                                this.val = DateUtil.parseLocalDateTime((CharSequence)dateStr, (String)"yyyy");
                                return;
                            }
                            if ("yyyy-MM".length() == dateStr.length()) {
                                this.val = DateUtil.parseLocalDateTime((CharSequence)dateStr, (String)"yyyy-MM");
                                return;
                            }
                            if ("yyyy-M".length() == dateStr.length()) {
                                this.val = DateUtil.parseLocalDateTime((CharSequence)dateStr, (String)"yyyy-M");
                                return;
                            }
                        }
                        this.val = HussarConverter.convert(type, (Object)val);
                    }
                    catch (ClassNotFoundException ignore) {
                        this.val = null;
                    }
                }
            } else {
                this.val = val;
            }
        }
    }

    private UserValue userValTrans(Object val) {
        if (this.enableUser && val instanceof String) {
            UserEnum userEnum = UserEnum.getByValue((String)((String)val));
            EngineUserDetails user = EngineUtil.getEngineUser();
            if (user != null && userEnum != null) {
                return new UserValue(userEnum.getAction().apply(user), true);
            }
        }
        return new UserValue(val, false);
    }

    public String sql() {
        if (this.expressionEntity != null) {
            return this.getExpressionValue();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("#{").append(this.getValueAlias());
        if (HussarUtils.isNotBlank((CharSequence)this.columnEntity.getColJavaType())) {
            sql.append(",").append("javaType=").append(this.columnEntity.getColJavaType());
        }
        if (this.columnEntity.getColJdbcType() != null) {
            sql.append(",").append("jdbcType=").append(this.columnEntity.getColJdbcType());
        }
        sql.append("}");
        return sql.toString();
    }

    private String getExpressionValue() {
        if (this.expressionValue == null) {
            this.expressionValue = this.expressionEntity.getColumnSqlNoAs(false);
        }
        return this.expressionValue;
    }

    private static class UserValue {
        private Object value;
        private boolean userVal;

        public UserValue(Object value, boolean userVal) {
            this.value = value;
            this.userVal = userVal;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isUserVal() {
            return this.userVal;
        }

        public void setUserVal(boolean userVal) {
            this.userVal = userVal;
        }
    }
}

