/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.dml;

import com.jxdinfo.hussar.datasource.manager.api.model.CustomResultMap;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.ConditionType;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.JoinEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OrderByEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlParamUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlWhereEntityUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.ResultMap;

public class SelectEntity
extends CustomResultMap
implements DmlEntity {
    private String resultMapId;
    private ResultMap resultMap;
    private List<ColumnEntity> selectColumnsList;
    private ModelTableMappingDTO model;
    private List<JoinEntity> joinEntityList;
    private List<WhereEntity> whereEntityList;
    private List<OrderByEntity> orderByEntityList;
    private String columnSql;
    private String whereSql;
    private String orderBySql;
    private Map<String, Object> param;
    private boolean msPage;
    private String sqlFirst;
    private String sqlComment;
    private boolean unIntuition = false;
    private String groupSql;

    public void setUnIntuition(boolean unIntuition) {
        this.unIntuition = unIntuition;
    }

    @Override
    public SelectEntity builder() {
        this.selectColumnsList = new ArrayList<ColumnEntity>();
        this.joinEntityList = new ArrayList<JoinEntity>();
        this.whereEntityList = new ArrayList<WhereEntity>();
        this.orderByEntityList = new ArrayList<OrderByEntity>();
        return this;
    }

    @Override
    public SelectEntity init(Map<String, Object> param) {
        Map<Boolean, List<WhereEntity>> pre2List;
        this.param = param;
        if (!this.unIntuition) {
            List salveTableNames = this.model.getSlaveTables().stream().map(ModelTableMappingDTO::getTableName).collect(Collectors.toList());
            for (ColumnEntity selectColumn : this.selectColumnsList) {
                if ((HussarUtils.isEmpty(this.joinEntityList) || this.model.getTableName().equals(selectColumn.getTableName())) && PurposeEnum.DEL_FLAG.getValue().equals(selectColumn.getPurpose())) {
                    DmlSqlUtil.addDelFlagWhere(selectColumn, param, this.whereEntityList);
                    break;
                }
                if (!salveTableNames.contains(selectColumn.getTableName()) || !PurposeEnum.DEL_FLAG.getValue().equals(selectColumn.getPurpose())) continue;
                DmlSqlUtil.addDelFlagWhere(selectColumn, param, this.whereEntityList);
                break;
            }
        }
        if (HussarUtils.isNotEmpty((pre2List = this.whereEntityList.stream().collect(Collectors.groupingBy(x -> x.getConditionType() != null && x.getConditionType() == ConditionType.PRE))).get(true))) {
            for (WhereEntity whereEntity : pre2List.get(true)) {
                if (HussarUtils.isNotBlank((CharSequence)whereEntity.getDefaultValue())) {
                    DmlWhereEntityUtil.resetWhereEntity(whereEntity);
                    param.put(whereEntity.getParamColumnAlias(), DmlParamUtil.getDefaultValue(whereEntity.getDefaultValue(), whereEntity.getOperatorType()));
                }
                whereEntity.initVal(param);
            }
        }
        if (HussarUtils.isNotEmpty(pre2List.get(false))) {
            for (WhereEntity whereEntity : pre2List.get(false)) {
                whereEntity.initVal(param);
            }
        }
        DmlSqlUtil.globalQuery(param, this.whereEntityList, this.model);
        DmlSqlUtil.globalOrder(param, this.orderByEntityList, this.model);
        if (!this.unIntuition) {
            this.whereEntityList = DmlWhereEntityUtil.whereIntuitionRebuild(this.whereEntityList);
            this.unIntuition = true;
        }
        this.initSql();
        return this;
    }

    private void initSql() {
        this.whereSql = "";
        this.orderBySql = "";
        boolean tableAlias = HussarUtils.isNotEmpty(this.joinEntityList);
        this.columnSql = this.getColumnSql(tableAlias);
        this.whereSql = this.getWhereSql(tableAlias);
        this.orderBySql = this.getOrderSql(tableAlias);
    }

    private String getWhereSql(boolean tableAlias) {
        String whereSqlStr;
        if (HussarUtils.isNotEmpty(this.whereEntityList) && HussarUtils.isNotEmpty((Object)(whereSqlStr = DmlSqlUtil.getWhereSql(DmlEntityUtil.getWhereTree(this.whereEntityList), tableAlias)))) {
            return whereSqlStr;
        }
        return null;
    }

    private String getOrderSql(boolean tableAlias) {
        if (HussarUtils.isEmpty(this.orderByEntityList)) {
            return null;
        }
        return this.orderByEntityList.stream().map(e -> e.getOrderSql(tableAlias)).collect(Collectors.joining(","));
    }

    private String getColumnSql(boolean tableAlias) {
        return this.selectColumnsList.stream().map(c -> c.getColumnSql(tableAlias)).collect(Collectors.joining(","));
    }

    public String getTableName() {
        if (HussarUtils.isNotEmpty(this.joinEntityList)) {
            JoinEntity firstJoinEntity = this.joinEntityList.get(0);
            if (this.joinEntityList.size() == 1) {
                return firstJoinEntity.getFirstJoinSql(this.msPage);
            }
            return firstJoinEntity.getLeftTable().getTableNameAndAlias() + this.joinEntityList.stream().map(j -> j.getJoinSql(this.msPage)).collect(Collectors.joining("\n"));
        }
        return this.entity().getTableEntity().getTableNameAndAlias();
    }

    public String getKeyProperty() {
        return this.entity().getKeyProperty();
    }

    public String getResultMapId() {
        return this.resultMapId;
    }

    public void setResultMapId(String resultMapId) {
        this.resultMapId = resultMapId;
    }

    public String getSqlFirst() {
        return Optional.ofNullable(this.sqlFirst).orElse("");
    }

    public void setSqlFirst(String sqlFirst) {
        this.sqlFirst = sqlFirst;
    }

    public String getColumnSql() {
        return this.columnSql;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public List<ColumnEntity> getSelectColumnsList() {
        return this.selectColumnsList;
    }

    public void setSelectColumnsList(List<ColumnEntity> selectColumnsList) {
        this.selectColumnsList = selectColumnsList;
    }

    public List<WhereEntity> getWhereEntityList() {
        return this.whereEntityList;
    }

    public void setWhereEntityList(List<WhereEntity> whereEntityList) {
        this.whereEntityList = whereEntityList;
    }

    public List<OrderByEntity> getOrderByEntityList() {
        return this.orderByEntityList;
    }

    public void setOrderByEntityList(List<OrderByEntity> orderByEntityList) {
        this.orderByEntityList = orderByEntityList;
    }

    public ModelTableMappingDTO getModel() {
        return this.model;
    }

    public void setModel(ModelTableMappingDTO model) {
        this.model = model;
    }

    public String getWhereSql() {
        return this.whereSql;
    }

    public ColumnEntity entity() {
        this.isNotEmptySelect();
        return this.selectColumnsList.get(0);
    }

    private void isNotEmptySelect() {
        HussarException.throwBy((boolean)HussarUtils.isEmpty(this.selectColumnsList), (Integer)EngineExceptionEnum.SELECT_COLUMNS_FAIL.getExceptionCode(), (String)EngineExceptionEnum.SELECT_COLUMNS_FAIL.getMessage());
    }

    public String getSqlComment() {
        return Optional.ofNullable(this.sqlComment).orElse("");
    }

    public void setSqlComment(String sqlComment) {
        this.sqlComment = sqlComment;
    }

    public String getOrderBySql() {
        return this.orderBySql;
    }

    public List<JoinEntity> getJoinEntityList() {
        return this.joinEntityList;
    }

    public void setJoinEntityList(List<JoinEntity> joinEntityList) {
        this.joinEntityList = joinEntityList;
    }

    @Override
    public String getSql() {
        SQL sql = (SQL)((SQL)new SQL().SELECT(this.columnSql)).FROM(this.getTableName());
        if (HussarUtils.isNotEmpty((Object)this.whereSql)) {
            sql.WHERE(this.whereSql);
        }
        if (HussarUtils.isNotEmpty((Object)this.orderBySql)) {
            sql.ORDER_BY(this.orderBySql);
        }
        return this.getSqlFirst() + sql.toString() + this.getSqlComment();
    }

    @Override
    public String getPoolName() {
        return this.entity().getPoolName();
    }

    public void setMsPage(boolean msPage) {
        this.msPage = msPage;
        if (!msPage) {
            return;
        }
        ArrayList excludeModels = new ArrayList();
        this.model.getToNModel(excludeModels);
        if (HussarUtils.isEmpty(excludeModels)) {
            return;
        }
        excludeModels.forEach(excludeModel -> {
            if (HussarUtils.isNotEmpty(this.joinEntityList)) {
                this.joinEntityList = this.joinEntityList.stream().filter(join -> !excludeModel.getTableName().equals(join.getLeftTable().getTableName()) && !excludeModel.getTableName().equals(join.getRightTable().getTableName())).collect(Collectors.toList());
            }
            if (HussarUtils.isNotEmpty(this.selectColumnsList)) {
                this.selectColumnsList = this.selectColumnsList.stream().filter(columnEntity -> !excludeModel.getTableId().equals(columnEntity.getTableId())).collect(Collectors.toList());
            }
            if (HussarUtils.isNotEmpty(this.orderByEntityList)) {
                this.orderByEntityList = this.orderByEntityList.stream().filter(order -> order.getColumnEntity() == null || !excludeModel.getTableId().equals(order.getColumnEntity().getTableId())).collect(Collectors.toList());
            }
        });
        this.columnSql = this.getColumnSql(HussarUtils.isNotEmpty(this.joinEntityList));
        this.resetOrderBy(this.orderByEntityList);
    }

    public SelectEntity appendWhere(String conditions) {
        return this.appendWhere(conditions, false);
    }

    public SelectEntity appendWhere(String conditions, boolean juxtaposed) {
        if (HussarUtils.isEmpty((Object)conditions)) {
            return this;
        }
        if (HussarUtils.isNotEmpty((Object)this.whereSql)) {
            StringBuilder whereSqlBuilder = new StringBuilder();
            if (juxtaposed) {
                whereSqlBuilder.append("(");
            }
            whereSqlBuilder.append(this.whereSql);
            if (juxtaposed) {
                whereSqlBuilder.append(")");
            }
            whereSqlBuilder.append(" AND ").append(conditions);
            this.whereSql = whereSqlBuilder.toString();
        } else {
            this.whereSql = conditions;
        }
        return this;
    }

    public void resetColumnSql(Consumer<List<ColumnEntity>> consumer) {
        consumer.accept(this.selectColumnsList);
        this.columnSql = this.getColumnSql(HussarUtils.isNotEmpty(this.joinEntityList));
    }

    public void resetColumnSql(String columnSql) {
        this.columnSql = columnSql;
        this.resultMapId = "engine_map";
    }

    public void resetOrderBy(List<OrderByEntity> orders) {
        this.orderByEntityList = orders;
        this.orderBySql = this.getOrderSql(HussarUtils.isNotEmpty(this.joinEntityList));
    }

    public void resetWhere(List<WhereEntity> whereEntityList) {
        this.whereEntityList = whereEntityList;
        boolean tableAlias = HussarUtils.isNotEmpty(this.joinEntityList);
        this.whereSql = this.getWhereSql(tableAlias);
    }

    public String getGroupSql() {
        return this.groupSql;
    }

    public String getHavingSql() {
        return null;
    }

    public void setGroupSql(String groupSql) {
        this.groupSql = groupSql;
    }

    public void setResultMap(ResultMap resultMap) {
        this.resultMap = resultMap;
    }

    public ResultMap getResultMap() {
        return this.resultMap;
    }
}

