/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.dml;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.ValueEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.factory.CustomExpressionFactory;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ICustomExpressionService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;

public class InsertEntity
implements DmlEntity {
    private boolean checkUnique = true;
    private List<ValueEntity> valueEntityList;
    private Map<String, Object> param;
    private String columnSql;
    private String valueSql;
    private ModelTableMappingDTO model;

    @Override
    public InsertEntity builder() {
        this.valueEntityList = new ArrayList<ValueEntity>();
        return this;
    }

    @Override
    public InsertEntity init(Map<String, Object> param) {
        ColumnEntity columnEntity;
        this.param = param;
        this.isNotEmptyValues();
        for (ValueEntity valueEntity : this.valueEntityList) {
            columnEntity = valueEntity.getColumnEntity();
            if (HussarUtils.isNotBlank((CharSequence)columnEntity.getPurpose())) {
                DmlEntityUtil.value(param, columnEntity.getColAlias(), columnEntity.getPurpose(), columnEntity.getPurposeRule(), ParameterType.values, this.model == null ? null : this.model.getColumns());
            }
            valueEntity.initVal(param);
        }
        for (ValueEntity valueEntity : this.valueEntityList) {
            columnEntity = valueEntity.getColumnEntity();
            if (!DmlEntityUtil.additionalValue(param, columnEntity.getColAlias(), this.model)) continue;
            valueEntity.initVal(param);
        }
        this.initSql();
        HussarException.throwBy((boolean)HussarUtils.isBlank((CharSequence)this.valueSql), (Integer)EngineExceptionEnum.VALUES_FAIL.getExceptionCode(), (String)EngineExceptionEnum.VALUES_FAIL.getMessage());
        return this;
    }

    private void initSql() {
        ArrayList<String> colName = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (ValueEntity valueEntity : this.valueEntityList) {
            if (valueEntity.isNoll()) continue;
            values.add(valueEntity.sql());
            colName.add(valueEntity.getColumnEntity().getColName());
        }
        DbType dbType = DmlEntityUtil.getTableEntity(this.model.getPollName(), this.model.getTableName()).getDbType();
        ICustomExpressionService customExpressionService = CustomExpressionFactory.getCustomExpression((String)dbType.getDb());
        this.columnSql = customExpressionService.buildColumnSqlWithSymbol(colName);
        this.valueSql = HussarUtils.join(values);
    }

    public String getTableName() {
        return this.entity().getTableName();
    }

    public String getKeyProperty() {
        return this.entity().getKeyProperty();
    }

    public String getColumnSql() {
        return this.columnSql;
    }

    public String getValueSql() {
        return this.valueSql;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    private ColumnEntity entity() {
        this.isNotEmptyValues();
        return this.valueEntityList.get(0).getColumnEntity();
    }

    private void isNotEmptyValues() {
        HussarException.throwBy((boolean)HussarUtils.isEmpty(this.valueEntityList), (Integer)EngineExceptionEnum.VALUES_FAIL.getExceptionCode(), (String)EngineExceptionEnum.VALUES_FAIL.getMessage());
    }

    public List<ValueEntity> getValueEntityList() {
        return this.valueEntityList;
    }

    public void setValueEntityList(List<ValueEntity> valueEntityList) {
        this.valueEntityList = valueEntityList;
    }

    @Override
    public String getSql() {
        return ((SQL)((SQL)new SQL().INSERT_INTO(this.getTableName())).VALUES(this.getColumnSql(), this.getValueSql())).toString();
    }

    @Override
    public String getPoolName() {
        return this.entity().getPoolName();
    }

    public ModelTableMappingDTO getModel() {
        return this.model;
    }

    public void setModel(ModelTableMappingDTO model) {
        this.model = model;
    }

    public boolean isCheckUnique() {
        return this.checkUnique;
    }

    public void setCheckUnique(boolean checkUnique) {
        this.checkUnique = checkUnique;
    }
}

