/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.support.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.map.MapUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.ColumnRuleType;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.core.enums.ExceptionCode;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineResult;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.engine.plugin.dml.dto.EngineBackVerifyContent;
import com.jxdinfo.hussar.support.engine.plugin.dml.dto.EngineBackVerifyDto;
import com.jxdinfo.hussar.support.engine.plugin.dml.dto.EngineBackVerifyVo;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectCustomEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.SetEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.ValueEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.DmlService;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.SingleTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@EngineService(value="com.jxdinfo.hussar.support.engine.plugin.dml.service.impl.engineSingleTable", type=DataServiceType.PERMANENT, des="\u5355\u8868\u56fa\u5316service")
public class SingleTableServiceImpl
implements SingleTableService,
UnderlyingService {
    private static final String INSERT_AND_UPDATE = "insertAndUpdate";
    private static final String EDT_DEL = "del";
    @Autowired
    private DmlService dmlService;

    @Override
    @EngineMethod(des="\u5355\u8868\u65b0\u589e", paramDes={"\u65b0\u589e\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public ApiResponse save(InsertEntity entity) {
        try {
            ApiResponse<Object> check = this.checkUnique(entity.getModel(), entity.getParam(), false, entity.isCheckUnique());
            if (!check.isSuccess()) {
                return check;
            }
            this.dmlService.insert(entity, entity.getPoolName());
            return ApiResponse.success((Object)entity.getParam().get(entity.getKeyProperty()), (String)"");
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u66f4\u65b0", paramDes={"\u66f4\u65b0\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public ApiResponse update(UpdateEntity entity) {
        try {
            ApiResponse<Object> check = this.checkUnique(entity.getModel(), entity.getParam(), true, true);
            if (!check.isSuccess()) {
                return check;
            }
            this.dmlService.update(entity, entity.getPoolName());
            return ApiResponse.success((Object)entity.getParam().get(entity.getKeyProperty()), (String)"");
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u65b0\u589e\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public ApiResponse saveOrUpdate(UpdateEntity entity) {
        try {
            boolean isUpdate = false;
            String keyProperty = entity.getKeyProperty();
            Object id = entity.getParam().get(keyProperty);
            if (HussarUtils.isNotEmpty((Object)id)) {
                SelectEntity selectById = new DmlEntityUtil.DmlServiceEntity(entity.getModel()).selectById(id);
                isUpdate = HussarUtils.isNotEmpty((Object)this.selectOne(selectById));
            }
            if (isUpdate) {
                return this.update(entity);
            }
            InsertEntity insert = this.getInsertByUpdate(entity);
            return this.save((InsertEntity)insert.init((Map)entity.getParam()));
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    private ApiResponse<Object> checkUnique(ModelTableMappingDTO model, Map<String, Object> param, boolean isUpdate, boolean check) {
        ArrayList rules;
        ApiResponse success = ApiResponse.success();
        if (HussarUtils.isEmpty((Object)model) || !check) {
            return success;
        }
        List<Object> list = rules = HussarUtils.isEmpty((Object)model.getRules()) ? new ArrayList() : model.getRules().stream().filter(r -> ColumnRuleType.UNIQUE.getValue().equals(r.getRuleType())).collect(Collectors.toList());
        if (HussarUtils.isEmpty(rules)) {
            return success;
        }
        HashMap<Long, Object> columnValue = new HashMap<Long, Object>();
        Map<Long, Long> columnIdMap = model.getColumns().stream().collect(Collectors.toMap(ModelColumnDto::getModelColumnId, MetadataColumn::getColumnId));
        for (ModelColumnsRules rule : rules) {
            Long columnId = columnIdMap.get(rule.getModelColumnId());
            if (!HussarUtils.isNotEmpty((Object)columnId)) continue;
            columnValue.put(columnId, param.get(rule.getColumnAlias()));
        }
        DmlEntityUtil.DmlServiceEntity dmlServiceEntity = new DmlEntityUtil.DmlServiceEntity(model);
        SelectEntity selectEntity = dmlServiceEntity.selectByColumns(columnValue, MatchTypeEnum.OR);
        if (selectEntity != null && HussarUtils.isNotEmpty((Object)selectEntity.getWhereSql())) {
            List<EngineResult> list2;
            if (isUpdate) {
                MetadataColumnDto pkColumn = dmlServiceEntity.getPkColumn();
                selectEntity.appendWhere(String.format("%s <> #{et.param.%s,javaType=%s,jdbcType=%s}", pkColumn.getColumnName(), pkColumn.getColumnAlias(), pkColumn.getJavaType(), pkColumn.getJdbcType()), true);
                selectEntity.getParam().put(pkColumn.getColumnAlias(), param.get(pkColumn.getColumnAlias()));
            }
            return HussarUtils.isNotEmpty(list2 = this.dmlService.selectList(selectEntity, selectEntity.getPoolName())) ? ApiResponse.fail((String)this.getFailMsg(columnValue, dmlServiceEntity.getColumnDtoMap(), list2)) : success;
        }
        return success;
    }

    private String getFailMsg(Map<Long, Object> columnValue, Map<Long, MetadataColumnDto> columnMap, List<EngineResult> list) {
        ArrayList<String> columnCommentSet = new ArrayList<String>();
        block0: for (Map.Entry<Long, Object> entry : columnValue.entrySet()) {
            MetadataColumnDto columnDto = columnMap.get(entry.getKey());
            Object value = entry.getValue();
            if (HussarUtils.isEmpty((Object)columnDto) || HussarUtils.isEmpty((Object)value)) continue;
            String comment = String.format("'%s'", columnDto.getColumnComment());
            String columnAlias = columnDto.getColumnAlias();
            for (EngineResult engineResult : list) {
                Object resultValue = ((Map)engineResult).get(columnAlias);
                if (!HussarUtils.equals((Object)HussarUtils.toStr((Object)value), (Object)HussarUtils.toStr(resultValue))) continue;
                columnCommentSet.add(comment);
                continue block0;
            }
        }
        return String.format("%s\u91cd\u590d\u8f93\u5165\uff01", HussarUtils.join(columnCommentSet, (String)"\uff0c"));
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6279\u91cf\u65b0\u589e\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public boolean saveOrUpdateBatch(List<UpdateEntity> entityList) {
        try {
            if (HussarUtils.isEmpty(entityList)) {
                return true;
            }
            ArrayList<Boolean> existList = new ArrayList<Boolean>(entityList.size());
            InsertEntity insert = this.getDataTest(entityList, existList, entityList.get(0));
            return this.executeBatch(entityList, insert, existList);
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6279\u91cf\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public boolean updateBatch(List<UpdateEntity> entityList) {
        try {
            if (HussarUtils.isEmpty(entityList)) {
                return true;
            }
            ArrayList<Boolean> existList = new ArrayList<Boolean>(entityList.size());
            entityList.forEach(e -> existList.add(true));
            return this.executeBatch(entityList, null, existList);
        }
        catch (Exception e2) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e2);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u53ef\u7f16\u8f91\u8868\u683c\u6279\u91cf\u65b0\u589e\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public boolean editSaveOrUpdateBatch(Map<String, Object> dmlEntityMap) {
        try {
            if (HussarUtils.isNotEmpty(dmlEntityMap)) {
                List delList;
                List list = (List)dmlEntityMap.get(INSERT_AND_UPDATE);
                if (HussarUtils.isNotEmpty((Object)list)) {
                    this.saveOrUpdateBatch(list);
                }
                if (HussarUtils.isNotEmpty((Object)(delList = (List)dmlEntityMap.get(EDT_DEL)))) {
                    for (DeleteEntity dmlEntity : delList) {
                        this.remove(dmlEntity);
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6279\u91cf\u4fdd\u5b58\uff08\u62a5\u9519\u7ee7\u7eed\u6267\u884c\uff09", paramDes={"\u65b0\u589e\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u6210\u529f\u5e8f\u5217\u53f7")
    public List<Integer> saveBatchMore(List<InsertEntity> entity) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (HussarUtils.isEmpty(entity)) {
            return result;
        }
        for (int i = 0; i < entity.size(); ++i) {
            try {
                InsertEntity insertEntity = entity.get(i);
                if (insertEntity == null) continue;
                this.dmlService.insert(insertEntity, insertEntity.getPoolName());
                result.add(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private InsertEntity getDataTest(List<UpdateEntity> entityList, List<Boolean> existList, UpdateEntity updateEntity) {
        InsertEntity insert = this.getInsertByUpdate(updateEntity);
        String keyProperty = updateEntity.getKeyProperty();
        SelectEntity select = this.getSelectByUpdate(updateEntity);
        for (UpdateEntity entity : entityList) {
            boolean exist = false;
            Map<String, Object> param = entity.getParam();
            if (HussarUtils.isNotEmpty((Object)keyProperty) && HussarUtils.isNotEmpty((Object)param.get(keyProperty))) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(keyProperty, param.get(keyProperty));
                exist = CollectionUtils.isNotEmpty((Collection)this.selectList((SelectEntity)select.init(map)).getData());
            }
            existList.add(exist);
        }
        return insert;
    }

    private boolean executeBatch(List<UpdateEntity> entityList, InsertEntity insert, List<Boolean> existList) {
        return this.dmlService.saveOrUpdateBatch(entityList, insert, existList, insert.getPoolName());
    }

    private InsertEntity getInsertByUpdate(UpdateEntity entity) {
        InsertEntity insertEntity = new InsertEntity();
        insertEntity.setValueEntityList(BeanUtil.copy(entity.getSetEntityList(), ValueEntity.class));
        insertEntity.setModel(entity.getModel());
        return insertEntity;
    }

    private SelectEntity getSelectByUpdate(UpdateEntity entity) {
        SelectEntity selectEntity = new SelectEntity();
        selectEntity.setSelectColumnsList(entity.getSetEntityList().stream().map(ValueEntity::getColumnEntity).collect(Collectors.toList()));
        selectEntity.setWhereEntityList(entity.getWhereEntityList());
        return selectEntity;
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u5220\u9664", paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public boolean remove(DeleteEntity entity) {
        try {
            return SqlHelper.retBool((Integer)this.dmlService.delete(entity, entity.getPoolName()));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u903b\u8f91\u5220\u9664", paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public boolean flagRemove(UpdateEntity entity) {
        try {
            if (HussarUtils.isEmpty(entity.getSetEntityList())) {
                DeleteEntity deleteEntity = new DeleteEntity().builder();
                deleteEntity.setWhereEntityList(entity.getWhereEntityList());
                deleteEntity.init((Map)entity.getParam());
                return this.remove(deleteEntity);
            }
            for (SetEntity setEntity : entity.getSetEntityList()) {
                if (!PurposeEnum.DEL_FLAG.getValue().equals(setEntity.getColumnEntity().getPurpose())) continue;
                setEntity.setVal("1");
                entity.getParam().put(setEntity.getParamColumnAlias(), setEntity.getVal());
            }
            return SqlHelper.retBool((Integer)this.dmlService.update(entity, entity.getPoolName()));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2\u96c6\u5408", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectList(SelectEntity entity) {
        try {
            List<EngineResult> list = this.dmlService.selectList(entity, entity.getPoolName());
            return new PageVo(list, Long.valueOf(HussarUtils.toLong((Object)list.size())));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u81ea\u5b9a\u4e49sql\u67e5\u8be2", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectCustom(SelectCustomEntity entity) {
        try {
            List<EngineResult> list = this.dmlService.selectCustom(entity, entity.getPoolName());
            return new PageVo(list, Long.valueOf(HussarUtils.toLong((Object)list.size())));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u81ea\u5b9a\u4e49sql\u67e5\u8be2\u5206\u9875", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectCustomPage(IPage<EngineResult> page, SelectCustomEntity entity) {
        try {
            this.dmlService.selectCustomPage(page, entity, entity.getPoolName());
            return new PageVo(page.getRecords(), Long.valueOf(page.getTotal()));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2\u96c6\u5408", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectExpressionList(SelectExpressionEntity entity) {
        try {
            List<EngineResult> list = this.dmlService.selectList(entity, entity.getPoolName());
            return new PageVo(list, Long.valueOf(HussarUtils.toLong((Object)list.size())));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2\u5206\u9875", paramDes={"\u5206\u9875\u5bf9\u8c61", "\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectPage(IPage<EngineResult> page, SelectEntity entity) {
        try {
            this.dmlService.selectPage(page, entity, entity.getPoolName());
            return new PageVo(page.getRecords(), Long.valueOf(page.getTotal()));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2\u5206\u9875", paramDes={"\u5206\u9875\u5bf9\u8c61", "\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectExpressionPage(IPage<EngineResult> page, SelectExpressionEntity entity) {
        try {
            this.dmlService.selectPage(page, entity, entity.getPoolName());
            return new PageVo(page.getRecords(), Long.valueOf(page.getTotal()));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2one", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public EngineResult selectOne(SelectEntity entity) {
        try {
            return this.dmlService.selectOne(entity, entity.getPoolName());
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u8868\u5355\u6821\u9a8c", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public ApiResponse formCheck(SelectEntity entity) {
        List<WhereEntity> whereEntityList = entity.getWhereEntityList();
        if (HussarUtils.isEmpty(whereEntityList)) {
            return ApiResponse.fail((int)ExceptionCode.PARAM_ERROR.getCode(), (String)ExceptionCode.PARAM_ERROR.getMessage());
        }
        EngineResult engineResult = this.dmlService.selectOne(entity, entity.getPoolName());
        if (HussarUtils.isNotEmpty((Object)engineResult)) {
            return ApiResponse.success((Object)engineResult);
        }
        if (whereEntityList.size() == 1) {
            return ApiResponse.fail((int)ExceptionCode.DELETED.getCode(), (String)ExceptionCode.DELETED.getMessage());
        }
        WhereEntity primaryWhere = null;
        for (WhereEntity whereEntity : whereEntityList) {
            ColumnEntity columnEntity = whereEntity.getColumnEntity();
            if (!PurposeEnum.PRIMARY.getValue().equals(columnEntity.getPurpose())) continue;
            primaryWhere = whereEntity;
            break;
        }
        if (primaryWhere == null) {
            return ApiResponse.fail((int)ExceptionCode.PARAM_ERROR.getCode(), (String)ExceptionCode.PARAM_ERROR.getMessage());
        }
        entity.resetWhere(Lists.newArrayList((Object[])new WhereEntity[]{primaryWhere}));
        engineResult = this.dmlService.selectOne(entity, entity.getPoolName());
        if (engineResult != null) {
            return ApiResponse.fail((int)ExceptionCode.NO_AUTH.getCode(), (String)ExceptionCode.NO_AUTH.getMessage());
        }
        return ApiResponse.fail((int)ExceptionCode.DELETED.getCode(), (String)ExceptionCode.DELETED.getMessage());
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2obj", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public Object selectObj(SelectExpressionEntity entity) {
        try {
            entity.setMsPage(true);
            Object result = this.dmlService.selectObj(entity, entity.getPoolName());
            return new PageVo(result);
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2objs", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public Object selectObjs(SelectExpressionEntity entity) {
        return this.dmlService.selectObj(entity, entity.getPoolName());
    }

    @Override
    @EngineMethod(des="\u5f02\u6b65\u6821\u9a8c", paramDes={"\u6821\u9a8c\u53c2\u6570"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public List<EngineBackVerifyVo> asyncverify(EngineBackVerifyContent content) {
        try {
            ArrayList<EngineBackVerifyVo> outParams = new ArrayList<EngineBackVerifyVo>();
            List<EngineBackVerifyDto> inParams = content.getInparams();
            List<EngineBackVerifyContent.ColumnRule> columnList = content.getColumnList();
            if (HussarUtils.isEmpty(inParams) || HussarUtils.isEmpty(columnList)) {
                return outParams;
            }
            block2: for (EngineBackVerifyDto inParam : inParams) {
                Optional<String> crOpt = Optional.ofNullable(inParam).map(EngineBackVerifyDto::getColumn);
                if (!crOpt.isPresent()) continue;
                for (EngineBackVerifyContent.ColumnRule column : columnList) {
                    boolean check;
                    List<EngineBackVerifyContent.Rule> rules;
                    if (!column.getColumnName().equals(crOpt.get()) || !HussarUtils.isNotEmpty(column.getRules()) || (rules = column.getRulesByType("unique")).isEmpty()) continue;
                    EngineBackVerifyContent.Rule rule = rules.get(0);
                    SelectEntity entity = content.getDmlServiceEntity().selectByColumns(MapUtil.of((Object)rule.getColumnId(), (Object)inParam.getValue()));
                    List list = this.selectList(entity).getData();
                    if (!HussarUtils.isNotEmpty((Object)list) || !(check = HussarUtils.isEmpty((Object)inParam.getBusinessValue()) || list.stream().anyMatch(o -> !HussarUtils.equals(o.get(entity.getKeyProperty()), (Object)inParam.getBusinessValue())))) continue;
                    EngineBackVerifyVo outParam = new EngineBackVerifyVo();
                    outParam.setField(inParam.getColumn());
                    outParam.setResult(false);
                    outParam.setErrorMsg(rule.getErrorMsg());
                    outParams.add(outParam);
                    continue block2;
                }
            }
            return outParams;
        }
        catch (Exception e) {
            throw new HussarException("\u540e\u7aef\u5f02\u6b65\u6821\u9a8c\u5931\u8d25");
        }
    }
}

