/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.select;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.select.ColumnExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomExpressionEntity
implements ColumnExpression {
    private final Pattern p = Pattern.compile("\\$\\{[^}(?!{)]*\\}");
    private String expression;
    private Map<String, ColumnEntity> columns;
    private String colAlias;
    private String colJavaType;

    public CustomExpressionEntity(String expression, String colJavaType) {
        this.expression = expression;
        this.colJavaType = colJavaType;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getColAlias() {
        return this.colAlias;
    }

    public void setColAlias(String colAlias) {
        this.colAlias = colAlias;
    }

    public String getColJavaType() {
        return this.colJavaType;
    }

    public void setColJavaType(String colJavaType) {
        this.colJavaType = colJavaType;
    }

    public Map<String, ColumnEntity> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, ColumnEntity> columns) {
        this.columns = columns;
    }

    public List<String> getColumnKeys() {
        if (HussarUtils.isEmpty((Object)this.expression)) {
            return new ArrayList<String>();
        }
        ArrayList<String> columnIds = new ArrayList<String>();
        Matcher m = this.p.matcher(this.expression);
        while (m.find()) {
            String id = m.group(0);
            String columnKey = id.substring(2, id.length() - 1);
            columnIds.add(columnKey);
        }
        return columnIds;
    }

    @Override
    public String getColumnSql(boolean tableAlias) {
        return this.getColumnSqlNoAs(tableAlias) + " " + this.colAlias;
    }

    @Override
    public String getColumnSqlNoAs(boolean tableAlias) {
        Matcher m = this.p.matcher(this.expression);
        StringBuffer buffer = new StringBuffer("(");
        while (m.find()) {
            String id = m.group(0);
            String columnSql = this.columns.get(id.substring(2, id.length() - 1)).getColumnSqlNoAs(tableAlias);
            m.appendReplacement(buffer, columnSql);
        }
        m.appendTail(buffer);
        buffer.append(")");
        return buffer.toString();
    }
}

