/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.dml;

import com.jxdinfo.hussar.datasource.manager.api.model.CustomResultMap;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.EngineDdlSqlUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.TableEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.select.ColumnExpression;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.GroupEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.JoinEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OrderByEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlParamUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlWhereEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.util.ModelResultMapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.jdbc.SQL;

public class SelectExpressionEntity
extends CustomResultMap
implements DmlEntity {
    private String resultMapId;
    private List<ColumnExpression> selectColumnsList;
    private ModelTableMappingDTO model;
    private List<JoinEntity> joinEntityList;
    private List<WhereEntity> whereEntityList;
    private List<OrderByEntity> orderByEntityList;
    private List<GroupEntity> groupEntityList;
    private List<WhereEntity> havingEntityList;
    private String columnSql;
    private String whereSql;
    private String orderBySql;
    private String groupSql;
    private String havingSql;
    private Map<String, Object> param;
    private boolean msPage;
    private String sqlFirst;
    private String sqlComment;
    private String customSql;
    private boolean initCustomSql;

    @Override
    public SelectExpressionEntity builder() {
        this.selectColumnsList = new ArrayList<ColumnExpression>();
        this.joinEntityList = new ArrayList<JoinEntity>();
        this.whereEntityList = new ArrayList<WhereEntity>();
        this.orderByEntityList = new ArrayList<OrderByEntity>();
        this.groupEntityList = new ArrayList<GroupEntity>();
        this.havingEntityList = new ArrayList<WhereEntity>();
        return this;
    }

    @Override
    public SelectExpressionEntity init(Map<String, Object> param) {
        this.param = param;
        DmlSqlUtil.globalGroupAgg(param, this.selectColumnsList, this.groupEntityList, this.havingEntityList, this.model);
        for (ColumnExpression selectColumn : this.selectColumnsList) {
            if (!this.isColumnEntity(selectColumn)) continue;
            ColumnEntity columnEntity = (ColumnEntity)selectColumn;
            if (!HussarUtils.isEmpty(this.joinEntityList) && !this.model.getTableName().equals(columnEntity.getTableName()) || !PurposeEnum.DEL_FLAG.getValue().equals(columnEntity.getPurpose())) continue;
            DmlSqlUtil.addDelFlagWhere(columnEntity, param, this.whereEntityList);
            break;
        }
        DmlSqlUtil.globalQuery(param, this.whereEntityList, this.model);
        if (HussarUtils.isNotEmpty(this.whereEntityList)) {
            for (WhereEntity whereEntity : this.whereEntityList) {
                if (HussarUtils.isNotBlank((CharSequence)whereEntity.getDefaultValue())) {
                    DmlWhereEntityUtil.resetWhereEntity(whereEntity);
                    param.put(whereEntity.getParamColumnAlias(), DmlParamUtil.getDefaultValue(whereEntity.getDefaultValue(), whereEntity.getOperatorType()));
                }
                whereEntity.initVal(param);
            }
        }
        DmlSqlUtil.globalOrder(param, this.orderByEntityList, this.model);
        this.whereEntityList = DmlWhereEntityUtil.whereIntuitionRebuild(this.whereEntityList);
        this.initSql();
        return this;
    }

    private void initSql() {
        this.whereSql = "";
        this.orderBySql = "";
        boolean tableAlias = HussarUtils.isNotEmpty(this.joinEntityList);
        this.columnSql = this.getColumnSql(tableAlias);
        this.whereSql = this.getWhereSql(tableAlias);
        this.orderBySql = this.getOrderSql(tableAlias);
        this.groupSql = this.getGroupSql(tableAlias);
        this.havingSql = this.getHavingAql(tableAlias);
    }

    private String getHavingAql(boolean tableAlias) {
        String havingSqlStr;
        if (HussarUtils.isNotEmpty(this.havingEntityList) && HussarUtils.isNotEmpty((Object)(havingSqlStr = DmlSqlUtil.getWhereSql(DmlEntityUtil.getWhereTree(this.havingEntityList), tableAlias)))) {
            return havingSqlStr;
        }
        return null;
    }

    private String getGroupSql(boolean tableAlias) {
        if (HussarUtils.isEmpty(this.groupEntityList)) {
            return null;
        }
        return this.groupEntityList.stream().map(e -> e.getGroupSql(tableAlias)).collect(Collectors.joining(","));
    }

    private String getWhereSql(boolean tableAlias) {
        String whereSqlStr;
        if (HussarUtils.isNotEmpty(this.whereEntityList) && HussarUtils.isNotEmpty((Object)(whereSqlStr = DmlSqlUtil.getWhereSql(DmlEntityUtil.getWhereTree(this.whereEntityList), tableAlias)))) {
            return whereSqlStr;
        }
        return null;
    }

    private String getOrderSql(boolean tableAlias) {
        if (HussarUtils.isEmpty(this.orderByEntityList)) {
            return null;
        }
        return this.orderByEntityList.stream().map(e -> e.getOrderSql(tableAlias)).collect(Collectors.joining(","));
    }

    private String getColumnSql(boolean tableAlias) {
        Object columnFields = this.param.get("columnFields");
        if (HussarUtils.isNotEmpty((Object)columnFields)) {
            this.resultMapId = "engine_map";
            return DmlSqlUtil.totalsQuery((Map)columnFields, this.model);
        }
        if (!this.containsSelectColumn()) {
            this.resultMapId = "engine_map";
            return this.selectColumnsList.stream().map(c -> c.getColumnSql(tableAlias)).collect(Collectors.joining(","));
        }
        return this.selectColumnsList.stream().map(c -> c.getColumnSql(tableAlias)).collect(Collectors.joining(","));
    }

    private boolean containsSelectColumn() {
        return this.selectColumnsList.stream().anyMatch(x -> x instanceof ColumnEntity);
    }

    private boolean isColumnEntity(ColumnExpression c) {
        return c instanceof ColumnEntity;
    }

    public String getTableName() {
        if (HussarUtils.isNotEmpty((Object)this.customSql)) {
            if (!this.initCustomSql) {
                this.customSql = EngineDdlSqlUtil.getDynamicSqlSource((String)this.customSql, this.getParam(), (String)"et.param").getSql();
                this.initCustomSql = true;
            }
            String tableAlias = Optional.ofNullable(this.model.getTableName()).map(tableName -> ModelResultMapUtil.getTableShortName((String)tableName.toLowerCase())).orElse("t");
            return String.format("(%s) %s", this.customSql, tableAlias);
        }
        if (HussarUtils.isNotEmpty(this.joinEntityList)) {
            JoinEntity firstJoinEntity = this.joinEntityList.get(0);
            if (this.joinEntityList.size() == 1) {
                return firstJoinEntity.getFirstJoinSql(this.msPage);
            }
            return firstJoinEntity.getLeftTable().getTableNameAndAlias() + this.joinEntityList.stream().map(j -> j.getJoinSql(this.msPage)).collect(Collectors.joining("\n"));
        }
        return TableEntity.getTableAlias(this.model.getTableName());
    }

    public String getResultMapId() {
        return this.resultMapId;
    }

    public void setResultMapId(String resultMapId) {
        this.resultMapId = resultMapId;
    }

    public String getSqlFirst() {
        return Optional.ofNullable(this.sqlFirst).orElse("");
    }

    public void setSqlFirst(String sqlFirst) {
        this.sqlFirst = sqlFirst;
    }

    public String getColumnSql() {
        return this.columnSql;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public List<ColumnExpression> getSelectColumnsList() {
        return this.selectColumnsList;
    }

    public void setSelectColumnsList(List<ColumnExpression> selectColumnsList) {
        this.selectColumnsList = selectColumnsList;
    }

    public List<WhereEntity> getWhereEntityList() {
        return this.whereEntityList;
    }

    public void setWhereEntityList(List<WhereEntity> whereEntityList) {
        this.whereEntityList = whereEntityList;
    }

    public List<GroupEntity> getGroupEntityList() {
        return this.groupEntityList;
    }

    public void setGroupEntityList(List<GroupEntity> groupEntityList) {
        this.groupEntityList = groupEntityList;
    }

    public List<WhereEntity> getHavingEntityList() {
        return this.havingEntityList;
    }

    public void setHavingEntityList(List<WhereEntity> havingEntityList) {
        this.havingEntityList = havingEntityList;
    }

    public List<OrderByEntity> getOrderByEntityList() {
        return this.orderByEntityList;
    }

    public void setOrderByEntityList(List<OrderByEntity> orderByEntityList) {
        this.orderByEntityList = orderByEntityList;
    }

    public ModelTableMappingDTO getModel() {
        return this.model;
    }

    public void setModel(ModelTableMappingDTO model) {
        this.model = model;
    }

    public String getWhereSql() {
        return this.whereSql;
    }

    public String getSqlComment() {
        return Optional.ofNullable(this.sqlComment).orElse("");
    }

    public void setSqlComment(String sqlComment) {
        this.sqlComment = sqlComment;
    }

    public String getGroupSql() {
        return this.groupSql;
    }

    public String getHavingSql() {
        return this.havingSql;
    }

    public String getOrderBySql() {
        return this.orderBySql;
    }

    public List<JoinEntity> getJoinEntityList() {
        return this.joinEntityList;
    }

    public void setJoinEntityList(List<JoinEntity> joinEntityList) {
        this.joinEntityList = joinEntityList;
    }

    @Override
    public String getSql() {
        SQL sql = (SQL)((SQL)new SQL().SELECT(this.columnSql)).FROM(this.getTableName());
        if (HussarUtils.isNotEmpty((Object)this.whereSql)) {
            sql.WHERE(this.whereSql);
        }
        if (HussarUtils.isNotEmpty((Object)this.groupSql)) {
            sql.GROUP_BY(this.groupSql);
        }
        if (HussarUtils.isNotEmpty((Object)this.havingSql)) {
            sql.HAVING(this.havingSql);
        }
        if (HussarUtils.isNotEmpty((Object)this.orderBySql)) {
            sql.ORDER_BY(this.orderBySql);
        }
        return this.getSqlFirst() + sql.toString() + this.getSqlComment();
    }

    @Override
    public String getPoolName() {
        return this.model.getPollName();
    }

    public void setMsPage(boolean msPage) {
        this.msPage = msPage && HussarUtils.isNotEmpty(this.joinEntityList);
    }

    public void setCustomSql(String customSql) {
        this.customSql = customSql;
    }
}

