/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.intercepts;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomResultMap;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IModelResultMapService;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.springframework.context.annotation.Lazy;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class EngineResultIntercept
implements Interceptor {
    @Resource
    @Lazy
    private IModelResultMapService modelResultMapService;

    private static <T> T findParameter(Object parameterObject, Class<T> clazz) {
        if (parameterObject != null) {
            if (parameterObject instanceof Map) {
                for (Object entry : ((Map)parameterObject).values()) {
                    if (entry == null || !clazz.isAssignableFrom(entry.getClass())) continue;
                    return (T)entry;
                }
            } else if (clazz.isAssignableFrom(parameterObject.getClass())) {
                return (T)parameterObject;
            }
        }
        return null;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        ResultSetHandler target = (ResultSetHandler)invocation.getTarget();
        this.initResultSetHandler(target, invocation);
        return invocation.proceed();
    }

    private void initResultSetHandler(ResultSetHandler target, Invocation invocation) {
        MetaObject rh = SystemMetaObject.forObject((Object)(target = (ResultSetHandler)PluginUtils.realTarget((Object)target)));
        ParameterHandler parameterHandler = (ParameterHandler)rh.getValue("parameterHandler");
        if (HussarUtils.isEmpty((Object)parameterHandler.getParameterObject())) {
            return;
        }
        CustomResultMap customSql = EngineResultIntercept.findParameter(parameterHandler.getParameterObject(), CustomResultMap.class);
        if (customSql != null) {
            ResultMap resultMap = customSql.getResultMap();
            this.updateMappedStatement(rh, resultMap, customSql, invocation);
        }
    }

    private void updateMappedStatement(MetaObject rh, ResultMap customResultMap, CustomResultMap customSql, Invocation invocation) {
        ResultMap resultMap;
        MappedStatement ms = (MappedStatement)rh.getValue("mappedStatement");
        if (this.isPageCountSelect(ms)) {
            return;
        }
        Configuration configuration = ms.getConfiguration();
        configuration.setCallSettersOnNulls(true);
        if (customResultMap == null) {
            ModelTableMappingDTO model;
            String resultMapId;
            MetaObject selectEntity = configuration.newMetaObject((Object)customSql);
            if (!selectEntity.hasGetter("resultMapId") || (resultMapId = (String)selectEntity.getValue("resultMapId")) == null) {
                return;
            }
            if (!configuration.hasResultMap(resultMapId) && selectEntity.hasGetter("model") && (model = (ModelTableMappingDTO)selectEntity.getValue("model")) != null) {
                this.modelResultMapService.createResultMap(model);
            }
            customResultMap = configuration.getResultMap(resultMapId);
        }
        if ((resultMap = customResultMap) == null) {
            return;
        }
        MappedStatement.Builder builder = new MappedStatement.Builder(configuration, ms.getId(), ms.getSqlSource(), ms.getSqlCommandType());
        builder.resultMaps(Collections.singletonList(resultMap));
        MappedStatement mappedStatement = builder.build();
        rh.setValue("mappedStatement", (Object)mappedStatement);
        try {
            customSql.callback(rh, mappedStatement, (Statement)invocation.getArgs()[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isPageCountSelect(MappedStatement ms) {
        return ((ResultMap)ms.getResultMaps().get(0)).getId().equals("mybatis-plus");
    }
}

