/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.api.entity.Dataservice;
import com.jxdinfo.hussar.support.engine.api.entity.DataserviceInout;
import com.jxdinfo.hussar.support.engine.api.enums.InoutType;
import com.jxdinfo.hussar.support.engine.api.model.DataserviceDto;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.dml.dao.DataserviceMapper;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.DataserviceInoutService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class DataserviceServiceImpl
extends HussarServiceImpl<DataserviceMapper, Dataservice>
implements DataserviceService {
    @Resource
    private DataserviceInoutService inoutService;

    public DataserviceDto getDataserviceDto(String uniqueCode) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)uniqueCode), (Integer)EngineExceptionEnum.PARAM_FAIL.getExceptionCode(), (String)EngineExceptionEnum.PARAM_FAIL.getMessage());
        return this.getDto(uniqueCode);
    }

    public Map<String, DataserviceDto> mapDataServiceDto() {
        ArrayList<DataserviceDto> dtoList = new ArrayList<DataserviceDto>();
        HashMap<Long, DataserviceDto> idMap = new HashMap<Long, DataserviceDto>();
        for (Dataservice dataservice : this.list()) {
            DataserviceDto copy = (DataserviceDto)BeanUtil.copy((Object)dataservice, DataserviceDto.class);
            if (!Optional.ofNullable(copy).map(Dataservice::getUniqueCode).isPresent()) continue;
            dtoList.add(copy);
            idMap.put(copy.getDataserviceId(), copy);
        }
        for (DataserviceInout inout : this.inoutService.list()) {
            DataserviceDto dto = (DataserviceDto)idMap.get(inout.getDataServiceId());
            if (dto == null) continue;
            if (InoutType.IN.getValue().equals(inout.getInoutType())) {
                dto.addIns(inout);
                continue;
            }
            if (!InoutType.OUT.getValue().equals(inout.getInoutType())) continue;
            dto.addOuts(inout);
        }
        return dtoList.stream().collect(Collectors.toMap(Dataservice::getUniqueCode, Function.identity(), (k1, k2) -> k1));
    }

    private DataserviceDto getDto(String uniqueCode) {
        List dataServices = ((DataserviceMapper)this.baseMapper).selectList((Wrapper)Wrappers.lambdaQuery(Dataservice.class).eq(Dataservice::getUniqueCode, (Object)uniqueCode));
        if (HussarUtils.isEmpty((Object)dataServices)) {
            return null;
        }
        DataserviceDto copy = (DataserviceDto)BeanUtil.copy(dataServices.get(0), DataserviceDto.class);
        HussarException.throwByNull((Object)this.addInOut(copy), (Integer)EngineExceptionEnum.GAIN_CODE_FAIL.getExceptionCode(), (String)EngineExceptionEnum.GAIN_CODE_FAIL.getMessage());
        return copy;
    }

    private DataserviceDto addInOut(DataserviceDto copy) {
        if (copy != null) {
            List list = this.inoutService.list((Wrapper)Wrappers.lambdaQuery(DataserviceInout.class).eq(DataserviceInout::getDataServiceId, (Object)copy.getDataserviceId()));
            for (DataserviceInout dataserviceInout : list) {
                if (InoutType.IN.getValue().equals(dataserviceInout.getInoutType())) {
                    copy.addIns(dataserviceInout);
                    continue;
                }
                if (!InoutType.OUT.getValue().equals(dataserviceInout.getInoutType())) continue;
                copy.addOuts(dataserviceInout);
            }
        }
        return copy;
    }
}

