/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.util;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.enums.DateEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.UserEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineResult;
import com.jxdinfo.hussar.support.engine.core.service.EngineUserDetails;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.EngineDateUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DmlParamUtil {
    private static final Pattern SPECIAL_WORD_PATTERN = Pattern.compile("[%_]", 2);
    private static final Pattern ALREADY_RESOLVE = Pattern.compile("(\\\\%|\\\\_)+", 2);
    private static final List<Character> SYMBOLS = CollectionUtil.ofImmutableList((Object[])new Character[]{Character.valueOf('%'), Character.valueOf('_')});
    private static final Character ESCAPE_SYMBOL = Character.valueOf('|');

    private DmlParamUtil() {
    }

    public static Page<EngineResult> getPage(Map<String, Object> param) {
        if (HussarUtils.isNotEmpty((Object)param.get("current")) && HussarUtils.isNotEmpty((Object)param.get("size"))) {
            return Page.of((long)Long.valueOf(String.valueOf(param.get("current"))), (long)Long.valueOf(String.valueOf(param.get("size"))));
        }
        return Page.of((long)1L, (long)10L);
    }

    public static Object getDefaultValue(String defaultValue, OperatorType operatorType) {
        if (operatorType == OperatorType.DATE_ENUM) {
            DateEnum dateEnum = DateEnum.getByValue((String)defaultValue);
            if (dateEnum != null) {
                return EngineDateUtil.timeBetween(dateEnum, true);
            }
            return null;
        }
        if (OperatorType.USER_ENUM == operatorType) {
            UserEnum userEnum = UserEnum.getByValue((String)defaultValue);
            EngineUserDetails user = EngineUtil.getEngineUser();
            if (user != null && userEnum != null) {
                return userEnum.getAction().apply(user);
            }
            return null;
        }
        return defaultValue;
    }

    public static String resolveParameter(Object valObj) {
        String parameter = valObj.toString();
        if (SPECIAL_WORD_PATTERN.matcher(parameter).find() && !ALREADY_RESOLVE.matcher(parameter).find()) {
            char[] var4;
            StringBuilder sb = new StringBuilder();
            char[] cArray = var4 = parameter.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character cur = Character.valueOf(cArray[i]);
                if (SYMBOLS.contains(cur)) {
                    sb.append(ESCAPE_SYMBOL);
                }
                sb.append(cur);
            }
            return sb.toString();
        }
        return parameter;
    }
}

