/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.OrderByType;
import com.jxdinfo.hussar.support.engine.core.model.EngineQueryConditionDto;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.EngineEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ExpressionColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OrderByEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class DmlSqlUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(DmlSqlUtil.class);

    private DmlSqlUtil() {
    }

    public static String getWhereSql(@Nullable List<WhereEntity> whereEntityList) {
        return DmlSqlUtil.getWhereSql(whereEntityList, false);
    }

    public static String getWhereSql(@Nullable List<WhereEntity> whereEntityList, boolean tableAlias) {
        if (HussarUtils.isEmpty(whereEntityList)) {
            return "";
        }
        StringBuilder where = new StringBuilder();
        DmlSqlUtil.renderWhere(where, whereEntityList, tableAlias);
        return where.toString();
    }

    private static void renderWhere(StringBuilder sql, List<WhereEntity> whereEntityList, boolean tableAlias) {
        int typeLength;
        int length;
        MatchTypeEnum end = null;
        for (WhereEntity whereEntity : whereEntityList) {
            MatchTypeEnum matchType = whereEntity.getMatchType();
            if (HussarUtils.isNotEmpty(whereEntity.getChildren())) {
                StringBuilder childSql = new StringBuilder();
                DmlSqlUtil.renderWhere(childSql, whereEntity.getChildren(), tableAlias);
                if (childSql.length() == 0) continue;
                sql.append("(").append((CharSequence)childSql).append(")");
                if (matchType == null) continue;
                sql.append(matchType);
                end = matchType;
                continue;
            }
            if (whereEntity.isNoll() || whereEntity.getOperatorType() == null) continue;
            sql.append(" ");
            if (tableAlias && !whereEntity.getSetSql().startsWith("(")) {
                sql.append(whereEntity.getColumnEntity().getTableAlias()).append(".");
            }
            sql.append(whereEntity.getSetSql());
            sql.append(" ");
            if (matchType == null) continue;
            sql.append(matchType);
            end = matchType;
        }
        if (end != null && (length = sql.length()) > (typeLength = end.getValue().length())) {
            sql.delete(length - typeLength, length);
        }
    }

    public static void addDelFlagWhere(ColumnEntity selectColumn, Map<String, Object> param, List<WhereEntity> whereEntityList) {
        Long parentId = EngineUtil.getId();
        ArrayList<WhereEntity> delWheres = new ArrayList<WhereEntity>();
        WhereEntity parentWhere = new WhereEntity();
        parentWhere.setMatchType(MatchTypeEnum.AND);
        parentWhere.setId(parentId);
        delWheres.add(parentWhere);
        WhereEntity delFlagWhere = new WhereEntity();
        delFlagWhere.setId(EngineUtil.getId());
        delFlagWhere.setColumnEntity(selectColumn);
        delFlagWhere.setOperatorType(OperatorType.NE);
        delFlagWhere.setMatchType(MatchTypeEnum.OR);
        String colAlias = selectColumn.getColAlias();
        delFlagWhere.setParamColumnAlias(colAlias);
        delFlagWhere.setParentId(parentId);
        param.put(colAlias, "1");
        delWheres.add(delFlagWhere);
        WhereEntity isNullWhere = new WhereEntity();
        isNullWhere.setId(EngineUtil.getId());
        isNullWhere.setColumnEntity(selectColumn);
        isNullWhere.setOperatorType(OperatorType.IS_NULL);
        isNullWhere.setMatchType(MatchTypeEnum.AND);
        isNullWhere.setParentId(parentId);
        delWheres.add(isNullWhere);
        whereEntityList.addAll(0, delWheres);
    }

    public static String totalsQuery(String columnFields, ModelTableMappingDTO model) {
        boolean isMs = HussarUtils.isNotEmpty((Object)model.getSlaveTables());
        Map map = (Map)JSON.parseObject((String)columnFields, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        StringBuilder columnSqlBuilder = new StringBuilder();
        HashMap<String, ColumnEntity> columnEntityMap = new HashMap<String, ColumnEntity>();
        DmlEntityUtil.getModelColumnEntityMap(model, columnEntityMap, 2);
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            ColumnEntity columnEntity = (ColumnEntity)columnEntityMap.get(entry.getKey());
            if (HussarUtils.isEmpty((Object)columnEntity)) continue;
            columnSqlBuilder.append("SUM").append("(");
            columnSqlBuilder.append(isMs ? columnEntity.getTableAliasAndColName() : columnEntity.getColNameEnableEscape());
            columnSqlBuilder.append(")").append(" ").append((String)entry.getValue());
            if (i != map.size() - 1) {
                columnSqlBuilder.append(",");
            }
            ++i;
        }
        return columnSqlBuilder.toString();
    }

    public static ColumnEntity getColumnEntityByExpression(ExpressionColumnEntity entity) {
        List<EngineEntity> parameters = entity.getParameters();
        for (EngineEntity parameter : parameters) {
            if (parameter instanceof ColumnEntity) {
                return (ColumnEntity)parameter;
            }
            if (!(parameter instanceof ExpressionColumnEntity)) continue;
            return DmlSqlUtil.getColumnEntityByExpression((ExpressionColumnEntity)parameter);
        }
        return null;
    }

    public static void globalOrder(Map<String, Object> param, List<OrderByEntity> orderByEntityList, ModelTableMappingDTO model) {
        List orderItems;
        if (HussarUtils.isEmpty(param) || HussarUtils.isEmpty((Object)param.get("orders"))) {
            return;
        }
        Object orders = param.get("orders");
        try {
            orderItems = (List)JSON.parseObject((String)JSON.toJSONString((Object)orders), (TypeReference)new TypeReference<List<OrderItem>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception ignore) {
            return;
        }
        Map<String, OrderByEntity> allOrderMap = DmlSqlUtil.getOrderMapByList(DmlEntityUtil.getColumnOrder(model));
        ArrayList<OrderByEntity> newOrderList = new ArrayList<OrderByEntity>();
        for (OrderItem item : orderItems) {
            OrderByEntity value = allOrderMap.get(item.getColumn().toUpperCase());
            if (!HussarUtils.isNotEmpty((Object)value)) continue;
            value.setOrderType(item.isAsc() ? OrderByType.ASC : OrderByType.DESC);
            newOrderList.add(value);
        }
        if (HussarUtils.isNotEmpty(newOrderList)) {
            orderByEntityList.addAll(0, newOrderList);
        }
    }

    public static void globalQuery(Map<String, Object> param, List<WhereEntity> whereEntityList, ModelTableMappingDTO model) {
        WhereEntity parentWhere;
        Object superQueryObj = param.get("superQueryConditionDto");
        if (superQueryObj == null) {
            return;
        }
        List conditions = null;
        try {
            conditions = JsonUtil.readList((String)JSON.toJSONString((Object)superQueryObj), EngineQueryConditionDto.class);
        }
        catch (Exception e) {
            LOGGER.error("\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return;
        }
        List<WhereEntity> conditionWhere = DmlEntityUtil.getConditionWhere(conditions, model, param);
        if (HussarUtils.isNotEmpty(conditionWhere)) {
            Long parentId = EngineUtil.getId();
            conditionWhere.forEach(x -> {
                x.initVal(param);
                x.setParentId(parentId);
            });
            parentWhere = new WhereEntity();
            parentWhere.setId(parentId);
            parentWhere.setMatchType(MatchTypeEnum.AND);
            conditionWhere.add(parentWhere);
        }
        if (HussarUtils.isNotEmpty(whereEntityList)) {
            Long newParentId = EngineUtil.getId();
            parentWhere = new WhereEntity();
            parentWhere.setId(newParentId);
            parentWhere.setMatchType(MatchTypeEnum.AND);
            whereEntityList.forEach(w -> w.setParentId(newParentId));
            whereEntityList.add(parentWhere);
        }
        whereEntityList.addAll(conditionWhere);
    }

    private static Map<String, OrderByEntity> getOrderMapByList(List<OrderByEntity> orderByEntityList) {
        return orderByEntityList.stream().collect(Collectors.toMap(o -> o.getColumnEntity().getColAlias().toUpperCase(), Function.identity()));
    }

    public static Class<?> getColumnClass(ColumnEntity columnEntity) {
        Class<?> name = null;
        try {
            name = Class.forName(columnEntity.getColJavaType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return name;
    }

    public static String concatLike(Object str, OperatorType type) {
        switch (type) {
            case NOT_LEFT_LIKE: 
            case LEFT_LIKE: {
                return str + "%";
            }
            case NOT_RIGHT_LIKE: 
            case RIGHT_LIKE: {
                return "%" + str;
            }
        }
        return "%" + str + "%";
    }
}

