/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.util;

import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.date.DateUtil;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.EngineDateUtil;
import java.time.LocalDateTime;
import java.util.List;

public class DmlWhereEntityUtil {
    public static void resetWhereEntity(WhereEntity whereEntity) {
        if (HussarUtils.isNotBlank((CharSequence)whereEntity.getDefaultValue()) && LocalDateTime.class.getName().equals(whereEntity.getColumnEntity().getColJavaType()) && (whereEntity.getOperatorType() == OperatorType.EQ || whereEntity.getOperatorType() == OperatorType.NE || whereEntity.getOperatorType() == OperatorType.GE || whereEntity.getOperatorType() == OperatorType.GT || whereEntity.getOperatorType() == OperatorType.LE || whereEntity.getOperatorType() == OperatorType.LT)) {
            List<LocalDateTime> startEnd = EngineDateUtil.getStartEnd(whereEntity.getDefaultValue());
            if (HussarUtils.isEmpty(startEnd)) {
                return;
            }
            switch (whereEntity.getOperatorType()) {
                case EQ: {
                    whereEntity.setOperatorType(OperatorType.BETWEEN);
                    whereEntity.setDefaultValue(CollectionUtil.join(startEnd, (CharSequence)",", DateUtil::formatLocalDateTime));
                    break;
                }
                case NE: {
                    whereEntity.setOperatorType(OperatorType.NOT_BETWEEN);
                    whereEntity.setDefaultValue(CollectionUtil.join(startEnd, (CharSequence)",", DateUtil::formatLocalDateTime));
                    break;
                }
                case GT: 
                case LE: {
                    whereEntity.setDefaultValue(DateUtil.formatLocalDateTime((LocalDateTime)startEnd.get(1)));
                    break;
                }
                case GE: 
                case LT: {
                    whereEntity.setDefaultValue(DateUtil.formatLocalDateTime((LocalDateTime)startEnd.get(0)));
                    break;
                }
            }
        }
    }
}

