/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.dml;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.JoinEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OrderByEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.jdbc.SQL;

public class SelectEntity
implements DmlEntity {
    private String resultMapId;
    private List<ColumnEntity> selectColumnsList;
    private ModelTableMappingDTO model;
    private List<JoinEntity> joinEntityList;
    private List<WhereEntity> whereEntityList;
    private List<OrderByEntity> orderByEntityList;
    private String columnSql;
    private String whereSql;
    private String orderBySql;
    private Map<String, Object> param;
    private boolean msPage;

    @Override
    public SelectEntity builder() {
        this.selectColumnsList = new ArrayList<ColumnEntity>();
        this.joinEntityList = new ArrayList<JoinEntity>();
        this.whereEntityList = new ArrayList<WhereEntity>();
        this.orderByEntityList = new ArrayList<OrderByEntity>();
        return this;
    }

    @Override
    public SelectEntity init(Map<String, Object> param) {
        this.param = param;
        for (ColumnEntity selectColumn : this.selectColumnsList) {
            if (!HussarUtils.isEmpty(this.joinEntityList) && !this.model.getTableName().equals(selectColumn.getTableName()) || !PurposeEnum.DEL_FLAG.getValue().equals(selectColumn.getPurpose())) continue;
            DmlSqlUtil.addDelFlagWhere(selectColumn, param, this.whereEntityList);
            break;
        }
        DmlSqlUtil.globalQuery(param, this.whereEntityList, this.model);
        if (HussarUtils.isNotEmpty(this.whereEntityList)) {
            for (WhereEntity whereEntity : this.whereEntityList) {
                whereEntity.initVal(param);
            }
        }
        DmlSqlUtil.globalOrder(param, this.orderByEntityList, this.model);
        this.initSql();
        return this;
    }

    private void initSql() {
        String whereSqlStr;
        this.whereSql = "";
        this.orderBySql = "";
        boolean tableAlias = HussarUtils.isNotEmpty(this.joinEntityList);
        this.columnSql = this.getColumnSql(tableAlias);
        if (HussarUtils.isNotEmpty(this.whereEntityList) && HussarUtils.isNotEmpty((Object)(whereSqlStr = DmlSqlUtil.getWhereSql(DmlEntityUtil.getWhereTree(this.whereEntityList), tableAlias)))) {
            this.whereSql = whereSqlStr;
        }
        if (HussarUtils.isNotEmpty(this.orderByEntityList)) {
            this.orderBySql = this.orderByEntityList.stream().map(e -> e.getOrderSql(tableAlias)).collect(Collectors.joining(","));
        }
    }

    private String getColumnSql(boolean tableAlias) {
        if (this.msPage && tableAlias) {
            HashSet<String> tables = new HashSet<String>();
            for (ModelTableMappingDTO joinDto : this.model.getSlaveTables()) {
                if (joinDto.getRelation() != ModelRelation.ONE_N && joinDto.getRelation() != ModelRelation.N_N) continue;
                tables.add(joinDto.getTableName());
            }
            return "DISTINCT " + this.selectColumnsList.stream().filter(c -> !tables.contains(c.getTableName())).map(c -> c.getColumnSql(true)).collect(Collectors.joining(","));
        }
        return this.selectColumnsList.stream().map(c -> c.getColumnSql(tableAlias)).collect(Collectors.joining(","));
    }

    public String getTableName() {
        if (HussarUtils.isNotEmpty(this.joinEntityList)) {
            JoinEntity firstJoinEntity = this.joinEntityList.get(0);
            if (this.joinEntityList.size() == 1) {
                return firstJoinEntity.getFirstJoinSql();
            }
            return firstJoinEntity.getLeftTable().getTableNameAndAlias() + this.joinEntityList.stream().map(JoinEntity::getJoinSql).collect(Collectors.joining("\n"));
        }
        return this.entity().getTableName();
    }

    public String getKeyProperty() {
        return this.entity().getKeyProperty();
    }

    public String getResultMapId() {
        return this.resultMapId;
    }

    public void setResultMapId(String resultMapId) {
        this.resultMapId = resultMapId;
    }

    public String getSqlFirst() {
        return "";
    }

    public String getColumnSql() {
        return this.columnSql;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public List<ColumnEntity> getSelectColumnsList() {
        return this.selectColumnsList;
    }

    public void setSelectColumnsList(List<ColumnEntity> selectColumnsList) {
        this.selectColumnsList = selectColumnsList;
    }

    public List<WhereEntity> getWhereEntityList() {
        return this.whereEntityList;
    }

    public void setWhereEntityList(List<WhereEntity> whereEntityList) {
        this.whereEntityList = whereEntityList;
    }

    public List<OrderByEntity> getOrderByEntityList() {
        return this.orderByEntityList;
    }

    public void setOrderByEntityList(List<OrderByEntity> orderByEntityList) {
        this.orderByEntityList = orderByEntityList;
    }

    public void setModel(ModelTableMappingDTO model) {
        this.model = model;
    }

    public ModelTableMappingDTO getModel() {
        return this.model;
    }

    public String getWhereSql() {
        return this.whereSql;
    }

    public ColumnEntity entity() {
        this.isNotEmptySelect();
        return this.selectColumnsList.get(0);
    }

    private void isNotEmptySelect() {
        HussarException.throwBy((boolean)HussarUtils.isEmpty(this.selectColumnsList), (Integer)EngineExceptionEnum.SELECT_COLUMNS_FAIL.getExceptionCode(), (String)EngineExceptionEnum.SELECT_COLUMNS_FAIL.getMessage());
    }

    public String getSqlComment() {
        return "";
    }

    public String getOrderBySql() {
        return this.orderBySql;
    }

    public List<JoinEntity> getJoinEntityList() {
        return this.joinEntityList;
    }

    public void setJoinEntityList(List<JoinEntity> joinEntityList) {
        this.joinEntityList = joinEntityList;
    }

    @Override
    public String getSql() {
        SQL sql = (SQL)((SQL)new SQL().SELECT(this.getColumnSql())).FROM(this.getTableName());
        if (HussarUtils.isNotEmpty((Object)this.whereSql)) {
            sql.WHERE(this.whereSql);
        }
        if (HussarUtils.isNotEmpty((Object)this.orderBySql)) {
            sql.ORDER_BY(this.getOrderBySql());
        }
        return this.getSqlFirst() + sql.toString() + this.getSqlComment();
    }

    @Override
    public String getPoolName() {
        return this.entity().getPoolName();
    }

    public void setMsPage(boolean msPage) {
        this.msPage = msPage;
        this.columnSql = this.getColumnSql(HussarUtils.isNotEmpty(this.joinEntityList));
    }

    public SelectEntity WHERE(String conditions) {
        if (HussarUtils.isNotEmpty((Object)conditions)) {
            this.whereSql = HussarUtils.isNotEmpty((Object)this.whereSql) ? this.whereSql + " AND " + conditions : conditions;
        }
        return this;
    }
}

