/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.support.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.entity.BpmPm;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.api.service.BpmPmService;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineResult;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.MsTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.SingleTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@EngineService(value="com.jxdinfo.hussar.support.engine.plugin.dml.service.impl.engineMsTable", type=DataServiceType.PERMANENT, des="\u591a\u8868\u56fa\u5316service")
public class MsTableServiceImpl
implements MsTableService,
UnderlyingService {
    private final SingleTableService singleTableService;
    private final BpmPmService bpmPmService;
    private static final String MASTER = "master";
    private static final String CHILD = "child";

    @Autowired
    public MsTableServiceImpl(SingleTableService singleTableService, BpmPmService bpmPmService) {
        this.singleTableService = singleTableService;
        this.bpmPmService = bpmPmService;
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u4fdd\u5b58\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public Object saveOrUpdate(Map<String, Object> updateEntity) {
        if (HussarUtils.isEmpty(updateEntity)) {
            throw new HussarException(EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getExceptionCode(), EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getMessage());
        }
        Object result = new Object();
        if (updateEntity.containsKey(MASTER)) {
            DmlEntity dmlEntity = (DmlEntity)updateEntity.get(MASTER);
            result = dmlEntity instanceof UpdateEntity ? this.singleTableService.saveOrUpdate((UpdateEntity)dmlEntity) : this.singleTableService.save((InsertEntity)dmlEntity);
            if (updateEntity.containsKey(CHILD) && HussarUtils.isNotEmpty((Object)updateEntity.get(CHILD))) {
                List dmlEntityList = (List)updateEntity.get(CHILD);
                for (DmlEntity dmlItem : dmlEntityList) {
                    if (!(dmlItem instanceof DeleteEntity)) continue;
                    this.singleTableService.remove((DeleteEntity)dmlItem);
                }
                for (DmlEntity dmlItem : dmlEntityList) {
                    if (!(dmlItem instanceof InsertEntity)) continue;
                    this.singleTableService.save((InsertEntity)dmlItem);
                }
            }
        }
        return result;
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u5220\u9664", paramAlias={"entity"}, paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public boolean remove(DeleteEntity entity) {
        if (HussarUtils.isEmpty((Object)entity)) {
            throw new HussarException(EngineExceptionEnum.DELETE_ENTITY_EMPTY.getExceptionCode(), EngineExceptionEnum.DELETE_ENTITY_EMPTY.getMessage());
        }
        boolean result = this.singleTableService.remove(entity);
        if (result) {
            try {
                this.removeSlaveTable(entity.getRelationship(), entity.getWhereEntityList());
            }
            catch (Exception e) {
                throw new HussarException("\u5220\u9664\u5931\u8d25");
            }
        }
        return result;
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u903b\u8f91\u5220\u9664", paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public boolean flagRemove(UpdateEntity entity) {
        if (HussarUtils.isEmpty((Object)entity)) {
            throw new HussarException(EngineExceptionEnum.DELETE_ENTITY_EMPTY.getExceptionCode(), EngineExceptionEnum.DELETE_ENTITY_EMPTY.getMessage());
        }
        boolean result = this.singleTableService.flagRemove(entity);
        if (result) {
            try {
                this.flagRemoveSlaveTable(entity.getModel(), entity.getWhereEntityList());
            }
            catch (Exception e) {
                throw new HussarException("\u5220\u9664\u5931\u8d25");
            }
        }
        return result;
    }

    private void flagRemoveSlaveTable(ModelTableMappingDTO model, List<WhereEntity> whereEntityList) {
        HussarException.throwBy((HussarUtils.isEmpty((Object)model) || HussarUtils.isEmpty((Object)model.getSlaveTables()) ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5173\u8054\u5173\u7cfb\u5f02\u5e38");
        for (ModelTableMappingDTO joinDto : model.getSlaveTables()) {
            boolean flagRemove = false;
            DeleteEntity deleteEntity = this.getDeleteByOn(joinDto.getColumnOns(), whereEntityList);
            for (ModelColumnDto column : joinDto.getColumns()) {
                if (!HussarUtils.isNotEmpty((Object)column.getPurpose()) || !PurposeEnum.DEL_FLAG.getValue().equals(column.getPurpose())) continue;
                UpdateEntity updateEntity = DmlEntityUtil.getFlagRemoveByDel(model, column, deleteEntity);
                this.singleTableService.flagRemove(updateEntity);
                flagRemove = true;
            }
            if (flagRemove) continue;
            this.singleTableService.remove(deleteEntity);
        }
    }

    private void removeSlaveTable(ModelTableMappingDTO model, List<WhereEntity> whereEntityList) {
        HussarException.throwBy((HussarUtils.isEmpty((Object)model) || HussarUtils.isEmpty((Object)model.getSlaveTables()) ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5173\u8054\u5173\u7cfb\u5f02\u5e38");
        for (ModelTableMappingDTO joinDto : model.getSlaveTables()) {
            DeleteEntity deleteEntity = this.getDeleteByOn(joinDto.getColumnOns(), whereEntityList);
            this.singleTableService.remove(deleteEntity);
        }
    }

    private DeleteEntity getDeleteByOn(List<RelationshipOnDto> onDtoList, List<WhereEntity> masterTableWhere) {
        return DmlEntityUtil.getWhereByOn(masterTableWhere, onDtoList);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u67e5\u8be2", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public PageVo selectList(SelectEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getMessage());
        return this.singleTableService.selectList(entity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u5206\u9875\u67e5\u8be2", paramDes={"\u5206\u9875\u5bf9\u8c61", "\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5206\u9875vo")
    public PageVo selectPage(IPage<EngineResult> page, SelectEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getMessage());
        entity.setMsPage(true);
        return this.singleTableService.selectPage(page, entity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u67e5\u8be2\u5355\u6761", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public EngineResult selectOne(SelectEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getMessage());
        return this.singleTableService.selectOne(entity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u5de5\u4f5c\u6d41\u67e5\u8be2", paramDes={"\u67e5\u8be2\u5bf9\u8c61", "node\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public EngineResult bpmSelect(SelectEntity entity, NodeBusinessVo businessVo) {
        EngineResult engineResult = this.selectOne(entity);
        Long nodeId = businessVo.getNodeId();
        List bpmPmList = this.bpmPmService.list((Wrapper)Wrappers.lambdaQuery(BpmPm.class).eq(BpmPm::getNodeId, (Object)nodeId));
        Long slaveTableId = null;
        for (BpmPm bpmPm : bpmPmList) {
            if (!HussarUtils.equals((Object)"slaveTableId", (Object)bpmPm.getBpmPmKey())) continue;
            slaveTableId = HussarConverter.toLong((Object)bpmPm.getBpmPmValue());
        }
        if (HussarUtils.isEmpty((Object)engineResult) || HussarUtils.isEmpty(slaveTableId)) {
            return engineResult;
        }
        Map param = (Map)engineResult;
        JSONArray jsonArray = new JSONArray();
        List slaveTables = entity.getModel().getSlaveTables();
        HussarException.throwByNull((Object)slaveTables, (String)EngineExceptionEnum.RELATION_SHIP_ERROR.getMessage());
        for (ModelTableMappingDTO joinDto : slaveTables) {
            Long rightTableId = joinDto.getTableId();
            if (!HussarUtils.equals((Object)rightTableId, (Object)slaveTableId)) continue;
            String slaveBusinessIdKey = null;
            for (ColumnEntity columnEntity : entity.getSelectColumnsList()) {
                if (!rightTableId.equals(columnEntity.getTableId()) || !PurposeEnum.PRIMARY.getValue().equals(columnEntity.getPurpose())) continue;
                slaveBusinessIdKey = columnEntity.getColAlias();
            }
            if (joinDto.getRelation() == ModelRelation.ONE_N || joinDto.getRelation() == ModelRelation.N_N) {
                if (!HussarUtils.isNotEmpty(slaveBusinessIdKey)) continue;
                List resultMulti = (List)param.get(joinDto.getParamName());
                for (Map salve : resultMulti) {
                    this.addBpmVariable(jsonArray, slaveBusinessIdKey, salve);
                }
                continue;
            }
            if (!HussarUtils.isNotEmpty(slaveBusinessIdKey)) continue;
            HashMap<String, Object> slave = new HashMap<String, Object>();
            BeanUtil.copy((Object)param, slave);
            this.addBpmVariable(jsonArray, slaveBusinessIdKey, slave);
        }
        param.put("call_activity_info", jsonArray);
        return engineResult;
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u67e5\u8be2obj", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public Object selectObj(SelectExpressionEntity entity) {
        return this.singleTableService.selectObj(entity);
    }

    private void addBpmVariable(JSONArray jsonArray, String slaveBusinessIdKey, Map<String, Object> salve) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("businessId", salve.get(slaveBusinessIdKey));
        jsonObject.put("variable", salve);
        jsonArray.add((Object)jsonObject);
    }
}

