/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.dynamic.datasource.hussar.extend.AbstractHussarDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessInoutVo;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessPmDto;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.enums.JoinTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.OrderByType;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ConstantColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.EngineEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ExpressionColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.TableEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.query.EngineQueryConditionDto;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.JoinEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OnCondition;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OrderByEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.SetEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.ValueEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DmlEntityUtil {
    private static final IEnginePluginModelApp metadataService = (IEnginePluginModelApp)SpringContextUtil.getBean(IEnginePluginModelApp.class);
    private static final DynamicDatasourceService datasourceService = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);

    private DmlEntityUtil() {
    }

    public static Object getEntity(String javaType, Map<String, Object> param, NodeBusinessVo businessVo, boolean haveJoin) {
        DmlEntity dmlEntity = DmlEntityUtil.getEntityPm(javaType, businessVo, haveJoin);
        HussarException.throwByNull((Object)dmlEntity, (String)"\u83b7\u53d6\u56fa\u5316\u5b9e\u4f53\u5f02\u5e38");
        return dmlEntity.init(param);
    }

    public static DmlEntity getEntityPm(String javaType, NodeBusinessVo businessVo, boolean haveJoin) {
        if (haveJoin) {
            return DmlEntityUtil.getRelationEntityPm(javaType, businessVo);
        }
        return DmlEntityUtil.getSingleTableEntity(javaType, businessVo);
    }

    private static void builderEntity(Map<Long, ModelColumnDto> columnMap, Map<Long, TableEntity> tableEntityMap, List<NodeBusinessPm> pmList, List<ColumnEntity> columnEntityList, List<WhereEntity> whereEntityList, List<OrderByEntity> orderEntityList, List<SetEntity> setEntityList, List<ValueEntity> valueEntityList) {
        HussarException.throwByNull(pmList, (String)"\u53c2\u6570\u5f02\u5e38");
        for (NodeBusinessPm pm : pmList) {
            ModelColumnDto columnDto;
            boolean check = false;
            if (HussarUtils.isEmpty((Object)pm.getColumnId()) && ParameterType.where.equals((Object)pm.getParameterType())) {
                WhereEntity whereEntity = new WhereEntity();
                whereEntity.setId(pm.getParameterId());
                whereEntity.setParentId(pm.getParentId());
                whereEntity.setMatchType(pm.getMatchType());
                whereEntityList.add(whereEntity);
                check = true;
            }
            if ((columnDto = columnMap.get(pm.getColumnId())) == null || check) continue;
            TableEntity tableEntity = tableEntityMap.get(columnDto.getTableId());
            if (tableEntity == null) {
                tableEntity = DmlEntityUtil.getTableEntity(columnDto.getPollName(), columnDto.getTableName());
                tableEntityMap.put(columnDto.getTableId(), tableEntity);
            }
            if (columnEntityList != null && ParameterType.column.equals((Object)pm.getParameterType())) {
                ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)columnDto, tableEntity);
                entity.setColAlias(pm.getParameterAlias());
                columnEntityList.add(entity);
            }
            if (setEntityList != null && ParameterType.set.equals((Object)pm.getParameterType())) {
                setEntityList.add(DmlEntityUtil.getSetEntity(pm, (MetadataColumnDto)columnDto, tableEntity));
            }
            if (valueEntityList != null && ParameterType.values.equals((Object)pm.getParameterType())) {
                valueEntityList.add(DmlEntityUtil.getValueEntity(pm, (MetadataColumnDto)columnDto, tableEntity));
            }
            if (whereEntityList != null && ParameterType.where.equals((Object)pm.getParameterType())) {
                whereEntityList.add(DmlEntityUtil.getWhereEntity(pm, (MetadataColumnDto)columnDto, tableEntity));
            }
            if (orderEntityList == null || !ParameterType.order.equals((Object)pm.getParameterType())) continue;
            orderEntityList.add(DmlEntityUtil.getOrderEntity(pm, (MetadataColumnDto)columnDto, tableEntity));
        }
    }

    private static TableEntity getTableEntity(String pollName, String tableName) {
        DbType dbType = DmlEntityUtil.getDbType(pollName);
        return new TableEntity(dbType, tableName);
    }

    private static WhereEntity newWhereEntity(Long parentId, MatchTypeEnum matchType, OperatorType operatorType, ColumnEntity columnEntity, String paramAlias) {
        WhereEntity entity = new WhereEntity();
        entity.setId(EngineUtil.getId());
        entity.setColumnEntity(columnEntity);
        entity.setOperatorType(operatorType == null ? OperatorType.EQ : operatorType);
        entity.setMatchType(matchType == null ? MatchTypeEnum.AND : matchType);
        entity.setParamColumnAlias(paramAlias == null ? columnEntity.getColAlias() : paramAlias);
        entity.setParentId(parentId);
        return entity;
    }

    public static DeleteEntity getWhereByOn(List<WhereEntity> masterWhere, List<RelationshipOnDto> onDtoList) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DeleteEntity deleteEntity = new DeleteEntity().builder();
        ArrayList<WhereEntity> whereEntityList = new ArrayList<WhereEntity>();
        deleteEntity.setWhereEntityList(whereEntityList);
        WhereEntity whereEntity = masterWhere.get(0);
        String paramColumnAlias = whereEntity.getParamColumnAlias();
        MetadataColumnDto columnDto = onDtoList.get(0).getRightColumn();
        TableEntity tableEntity = DmlEntityUtil.getTableEntity(columnDto.getPollName(), columnDto.getTableName());
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        WhereEntity slaveWhere = DmlEntityUtil.newWhereEntity(null, null, whereEntity.getOperatorType(), columnEntity, paramColumnAlias);
        whereEntityList.add(slaveWhere);
        param.put(whereEntity.getParamColumnAlias(), whereEntity.getVal());
        deleteEntity.setWhereEntityList(whereEntityList);
        return deleteEntity.init(param);
    }

    public static DmlEntity getSingleTableEntity(String javaType, NodeBusinessVo businessVo, ModelTableMappingDTO modelTable) {
        List<NodeBusinessPm> pmList = DmlEntityUtil.getPm(businessVo);
        Map<Long, ModelColumnDto> columnMap = DmlEntityUtil.getColumnMap(modelTable.getColumns());
        if (SelectEntity.class.getName().equals(javaType)) {
            SelectEntity selectEntity = DmlEntityUtil.getSelectEntity(columnMap, pmList);
            selectEntity.setModel(modelTable);
            selectEntity.setResultMapId(String.format("single.%s", businessVo.getModelId()));
            return selectEntity;
        }
        if (InsertEntity.class.getName().equals(javaType)) {
            return DmlEntityUtil.getInsertEntity(columnMap, pmList);
        }
        if (UpdateEntity.class.getName().equals(javaType)) {
            return DmlEntityUtil.getUpdateEntity(columnMap, pmList);
        }
        if (DeleteEntity.class.getName().equals(javaType)) {
            return DmlEntityUtil.getDeleteEntity(columnMap, pmList);
        }
        if (SelectExpressionEntity.class.getName().equals(javaType)) {
            SelectExpressionEntity selectEntity = DmlEntityUtil.getSelectExpressionEntity(columnMap, pmList, businessVo);
            selectEntity.setModel(modelTable);
            selectEntity.setResultMapId(String.format("single.%s", businessVo.getModelId()));
            return selectEntity;
        }
        return null;
    }

    private static SelectExpressionEntity getSelectExpressionEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPm> pmList, NodeBusinessVo businessVo) {
        SelectExpressionEntity entity = new SelectExpressionEntity().builder();
        HashMap<Long, TableEntity> tableEntityMap = new HashMap<Long, TableEntity>();
        DmlEntityUtil.builderEntity(columnMap, tableEntityMap, pmList, null, entity.getWhereEntityList(), entity.getOrderByEntityList(), null, null);
        JSONObject dto = JSON.parseObject((String)businessVo.getJsonParams());
        ArrayList<NodeBusinessPmDto> list = new ArrayList<NodeBusinessPmDto>();
        if (HussarUtils.isNotEmpty((Object)dto.get((Object)"pmList"))) {
            list.addAll((Collection)JSON.parseObject((String)JSON.toJSONString((Object)dto.get((Object)"pmList")), (TypeReference)new TypeReference<List<NodeBusinessPmDto>>(){}, (Feature[])new Feature[0]));
        }
        DmlEntityUtil.builderExpressionEntity(columnMap, tableEntityMap, list, entity.getSelectColumnsList());
        return entity;
    }

    private static void builderExpressionEntity(Map<Long, ModelColumnDto> columnMap, HashMap<Long, TableEntity> tableEntityMap, List<NodeBusinessPmDto> pmList, List<EngineEntity> selectColumnsList) {
        if (HussarUtils.isEmpty(pmList)) {
            return;
        }
        for (NodeBusinessPmDto pm : pmList) {
            if (selectColumnsList != null && ParameterType.column.equals((Object)pm.getParameterType())) {
                ModelColumnDto columnDto = columnMap.get(pm.getColumnId());
                TableEntity tableEntity = tableEntityMap.get(columnDto.getTableId());
                if (tableEntity == null) {
                    tableEntity = DmlEntityUtil.getTableEntity(columnDto.getPollName(), columnDto.getTableName());
                    tableEntityMap.put(columnDto.getTableId(), tableEntity);
                }
                ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)columnDto, tableEntity);
                entity.setColAlias(pm.getParameterAlias());
                selectColumnsList.add(entity);
            }
            if (selectColumnsList != null && ParameterType.cons.equals((Object)pm.getParameterType())) {
                ConstantColumnEntity entity = new ConstantColumnEntity(pm.getValueType(), pm.getConstValue());
                selectColumnsList.add(entity);
            }
            if (selectColumnsList == null || !ParameterType.fun.equals((Object)pm.getParameterType())) continue;
            ArrayList<EngineEntity> parameters = new ArrayList<EngineEntity>();
            ExpressionColumnEntity entity = new ExpressionColumnEntity(pm.getFunctionName(), parameters, Boolean.TRUE.equals(pm.getDistinct()), pm.getParameterAlias(), pm.getFunctionJavaType());
            DmlEntityUtil.builderExpressionEntity(columnMap, tableEntityMap, pm.getParameters(), parameters);
            selectColumnsList.add(entity);
        }
    }

    private static DmlEntity getSingleTableEntity(String javaType, NodeBusinessVo businessVo) {
        return DmlEntityUtil.getSingleTableEntity(javaType, businessVo, DmlEntityUtil.getModelTable(businessVo));
    }

    private static DeleteEntity getDeleteEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPm> pmList) {
        DeleteEntity entity = new DeleteEntity().builder();
        DmlEntityUtil.builderEntity(columnMap, new HashMap<Long, TableEntity>(), pmList, null, entity.getWhereEntityList(), null, null, null);
        return entity;
    }

    private static UpdateEntity getUpdateEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPm> pmList) {
        UpdateEntity entity = new UpdateEntity().builder();
        DmlEntityUtil.builderEntity(columnMap, new HashMap<Long, TableEntity>(), pmList, null, entity.getWhereEntityList(), null, entity.getSetEntityList(), null);
        return entity;
    }

    private static SelectEntity getSelectEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPm> pmList) {
        SelectEntity entity = new SelectEntity().builder();
        DmlEntityUtil.builderEntity(columnMap, new HashMap<Long, TableEntity>(), pmList, entity.getSelectColumnsList(), entity.getWhereEntityList(), entity.getOrderByEntityList(), null, null);
        return entity;
    }

    private static InsertEntity getInsertEntity(Map<Long, ModelColumnDto> columnMap, List<NodeBusinessPm> pmList) {
        InsertEntity entity = new InsertEntity().builder();
        DmlEntityUtil.builderEntity(columnMap, new HashMap<Long, TableEntity>(), pmList, null, null, null, null, entity.getValueEntityList());
        return entity;
    }

    private static ValueEntity getValueEntity(NodeBusinessPm pm, MetadataColumnDto columnDto, TableEntity tableEntity) {
        ValueEntity valueEntity = new ValueEntity();
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        valueEntity.setColumnEntity(columnEntity);
        valueEntity.setParamColumnAlias(pm.getParameterAlias());
        return valueEntity;
    }

    private static SetEntity getSetEntity(NodeBusinessPm pm, MetadataColumnDto columnDto, TableEntity tableEntity) {
        SetEntity setEntity = new SetEntity();
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        setEntity.setColumnEntity(columnEntity);
        setEntity.setOperatorType(pm.getOperatorType());
        setEntity.setParamColumnAlias(pm.getParameterAlias());
        return setEntity;
    }

    private static WhereEntity getWhereEntity(NodeBusinessPm pm, MetadataColumnDto columnDto, TableEntity tableEntity) {
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        return DmlEntityUtil.newWhereEntity(pm.getParentId(), pm.getMatchType(), pm.getOperatorType(), columnEntity, pm.getParameterAlias());
    }

    private static OrderByEntity getOrderEntity(NodeBusinessPm pm, MetadataColumnDto columnDto, TableEntity tableEntity) {
        OrderByEntity orderByEntity = new OrderByEntity();
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity(columnDto, tableEntity);
        orderByEntity.setColumnEntity(columnEntity);
        orderByEntity.setOrderType(pm.getOrderType());
        return orderByEntity;
    }

    private static ColumnEntity getColumnEntity(MetadataColumnDto columnDto, TableEntity tableEntity) {
        if (HussarUtils.isNotBlank((CharSequence)columnDto.getPrimarys())) {
            tableEntity.setKeyProperty(columnDto.getColumnAlias());
        }
        return new ColumnEntity(columnDto.getTableId(), columnDto.getColumnId(), columnDto.getColumnName(), columnDto.getColumnAlias(), columnDto.getJavaType(), columnDto.getJdbcType(), tableEntity.getDbType() != null, tableEntity, columnDto.getPurpose(), columnDto.getPollName());
    }

    private static ModelTableMappingDTO getModelTable(NodeBusinessVo node) {
        return metadataService.getModelTableMapping(node.getModelId(), node.getNodeType());
    }

    private static Map<Long, ModelColumnDto> getColumnMap(List<ModelColumnDto> columns) {
        return columns.stream().collect(Collectors.toMap(MetadataColumn::getColumnId, Function.identity(), (k1, k2) -> k1));
    }

    private static List<NodeBusinessPm> getPm(NodeBusinessVo businessVo) {
        ArrayList<NodeBusinessPm> list = new ArrayList<NodeBusinessPm>();
        if (HussarUtils.isNotEmpty((Object)businessVo.getJsonParams())) {
            JSONObject dto = JSON.parseObject((String)businessVo.getJsonParams());
            if (HussarUtils.isNotEmpty((Object)dto.get((Object)"pmList"))) {
                list.addAll(DmlEntityUtil.getPmListByJson(dto.get((Object)"pmList")));
            }
            if (HussarUtils.isNotEmpty((Object)dto.get((Object)"whereList"))) {
                list.addAll(DmlEntityUtil.getPmListByJson(dto.get((Object)"whereList")));
            }
            if (HussarUtils.isNotEmpty((Object)dto.get((Object)"sortVOList"))) {
                list.addAll(DmlEntityUtil.getPmListByJson(dto.get((Object)"sortVOList")));
            }
            return list;
        }
        for (NodeBusinessInoutVo in : businessVo.getIns()) {
            if (!HussarUtils.isNotEmpty((Object)in.getParameters())) continue;
            list.addAll(in.getParameters());
        }
        return list;
    }

    private static List<NodeBusinessPm> getPmListByJson(Object json) {
        return (List)JSON.parseObject((String)JSON.toJSONString((Object)json), (TypeReference)new TypeReference<List<NodeBusinessPm>>(){}, (Feature[])new Feature[0]);
    }

    private static DmlEntity getRelationEntityPm(String javaType, NodeBusinessVo businessVo) {
        List<NodeBusinessPm> pmList = DmlEntityUtil.getPm(businessVo);
        Long modelId = businessVo.getModelId();
        ModelTableMappingDTO modelTable = DmlEntityUtil.getModelTable(businessVo);
        HashMap<Long, TableEntity> tableEntityMap = new HashMap<Long, TableEntity>();
        HashMap<Long, ModelColumnDto> columnMap = new HashMap<Long, ModelColumnDto>(DmlEntityUtil.getColumnMap(modelTable.getColumns()));
        if (HussarUtils.equals((Object)SelectEntity.class.getName(), (Object)javaType)) {
            TableEntity tableEntity = DmlEntityUtil.getTableEntity(modelTable.getPollName(), modelTable.getTableName());
            tableEntityMap.put(modelTable.getTableId(), tableEntity);
            List<JoinEntity> joinEntityList = DmlEntityUtil.getJoinEntity(modelTable, columnMap, tableEntityMap);
            SelectEntity entity = DmlEntityUtil.getSelectEntity(columnMap, pmList);
            entity.setModel(modelTable);
            entity.setJoinEntityList(joinEntityList);
            entity.setResultMapId(String.format("ms.%s", modelId));
            return entity;
        }
        if (HussarUtils.equals((Object)DeleteEntity.class.getName(), (Object)javaType)) {
            DeleteEntity entity = DmlEntityUtil.getDeleteEntity(columnMap, pmList);
            entity.setRelationship(modelTable);
            return entity;
        }
        if (HussarUtils.equals((Object)UpdateEntity.class.getName(), (Object)javaType)) {
            UpdateEntity entity = DmlEntityUtil.getUpdateEntity(columnMap, pmList);
            entity.setRelationship(modelTable);
            return entity;
        }
        if (HussarUtils.equals((Object)SelectExpressionEntity.class.getName(), (Object)javaType)) {
            TableEntity tableEntity = DmlEntityUtil.getTableEntity(modelTable.getPollName(), modelTable.getTableName());
            tableEntityMap.put(modelTable.getTableId(), tableEntity);
            List<JoinEntity> joinEntityList = DmlEntityUtil.getJoinEntity(modelTable, columnMap, tableEntityMap);
            SelectExpressionEntity entity = DmlEntityUtil.getSelectExpressionEntity(columnMap, pmList, businessVo);
            entity.setModel(modelTable);
            entity.setJoinEntityList(joinEntityList);
            entity.setResultMapId(String.format("ms.%s", modelId));
            return entity;
        }
        return null;
    }

    private static List<JoinEntity> getJoinEntity(ModelTableMappingDTO relationship, Map<Long, ModelColumnDto> columnMap, Map<Long, TableEntity> tableEntityMap) {
        ArrayList<JoinEntity> joinEntityList = new ArrayList<JoinEntity>();
        DbType dbType = null;
        for (ModelTableMappingDTO joinDto : relationship.getSlaveTables()) {
            if (HussarUtils.isNotEmpty((Object)joinDto.getSlaveTables())) {
                DmlEntityUtil.getJoinEntity(joinDto, columnMap, tableEntityMap);
                continue;
            }
            JoinEntity joinEntity = new JoinEntity();
            joinEntity.setOneToN(HussarUtils.equals((Object)joinDto.getRelation(), (Object)ModelRelation.ONE_N) || HussarUtils.equals((Object)joinDto.getRelation(), (Object)ModelRelation.N_N));
            ArrayList<OnCondition> onConditions = new ArrayList<OnCondition>();
            columnMap.putAll(DmlEntityUtil.getColumnMap(joinDto.getColumns()));
            if (dbType == null) {
                dbType = DmlEntityUtil.getDbType(joinDto.getPollName());
            }
            tableEntityMap.putIfAbsent(joinDto.getTableId(), new TableEntity(dbType, joinDto.getTableName()));
            for (RelationshipOnDto onDto : joinDto.getColumnOns()) {
                OnCondition onCondition = new OnCondition();
                onCondition.setOperatorType(onDto.getOperatorType());
                onCondition.setLeftColumn(DmlEntityUtil.getColumnEntity(onDto.getLeftColumn(), tableEntityMap.get(relationship.getTableId())));
                onCondition.setRightColumn(DmlEntityUtil.getColumnEntity(onDto.getRightColumn(), tableEntityMap.get(joinDto.getTableId())));
                onConditions.add(onCondition);
            }
            joinEntity.setJoinType(JoinTypeEnum.valueOf((String)joinDto.getJoinType()));
            joinEntity.setOnConditionList(onConditions);
            joinEntityList.add(joinEntity);
        }
        return joinEntityList;
    }

    private static DbType getDbType(String pollName) {
        return Optional.ofNullable(pollName).map(arg_0 -> ((DynamicDatasourceService)datasourceService).getDatasourceByPoolName(arg_0)).map(AbstractHussarDataSource::getDbType).orElse(null);
    }

    public static List<WhereEntity> getWhereTree(List<WhereEntity> whereEntities) {
        if (HussarUtils.isEmpty(whereEntities)) {
            return new ArrayList<WhereEntity>();
        }
        if (whereEntities.size() == 1) {
            return whereEntities;
        }
        HashMap<Long, WhereEntity> whereMap = new HashMap<Long, WhereEntity>(whereEntities.size());
        ArrayList<WhereEntity> result = new ArrayList<WhereEntity>();
        boolean isTree = false;
        for (WhereEntity whereEntity : whereEntities) {
            if (HussarUtils.isNotEmpty((Object)whereEntity.getId())) {
                whereMap.put(whereEntity.getId(), whereEntity);
            }
            Long pId = whereEntity.getParentId();
            whereEntity.setChildren(new ArrayList<WhereEntity>());
            if (HussarUtils.isNotEmpty((Object)pId)) {
                isTree = true;
                continue;
            }
            result.add(whereEntity);
        }
        if (isTree) {
            for (WhereEntity entity : whereEntities) {
                if (!HussarUtils.isNotEmpty((Object)entity.getParentId())) continue;
                ((WhereEntity)whereMap.get(entity.getParentId())).getChildren().add(entity);
            }
        }
        return result;
    }

    public static void value(Map<String, Object> param, String propertyName, String purposeStr, ParameterType parameterType) {
        DmlEntityUtil.beforeClear(param, propertyName, purposeStr);
        PurposeEnum purpose = PurposeEnum.getByValue((String)purposeStr);
        if (param != null && propertyName != null && purpose != null) {
            boolean insert = parameterType.equals((Object)ParameterType.values);
            boolean update = parameterType.equals((Object)ParameterType.set);
            if (PurposeEnum.DEL_FLAG.equals((Object)purpose)) {
                param.put(propertyName, "0");
                return;
            }
            if (insert) {
                switch (purpose) {
                    case PRIMARY: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, EngineUtil.getId());
                        break;
                    }
                    case CREATE_TIME: 
                    case UPDATE_TIME: {
                        param.put(propertyName, LocalDateTime.now());
                        break;
                    }
                    case CREATE_USER: 
                    case UPDATE_USER: {
                        param.put(propertyName, EngineUtil.getUserId());
                        break;
                    }
                    case DATA_HOLDER: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, EngineUtil.getUserId());
                        break;
                    }
                    case DATA_ORGAN: {
                        if (!HussarUtils.isEmpty((Object)param.get(propertyName))) break;
                        param.put(propertyName, EngineUtil.getDeptId());
                        break;
                    }
                }
            }
            if (update) {
                switch (purpose) {
                    case UPDATE_TIME: {
                        param.put(propertyName, LocalDateTime.now());
                        break;
                    }
                    case UPDATE_USER: {
                        param.put(propertyName, EngineUtil.getUserId());
                        break;
                    }
                }
            }
        }
    }

    private static void beforeClear(Map<String, Object> param, String propertyName, String purposeStr) {
        PurposeEnum purpose = PurposeEnum.getByValue((String)purposeStr);
        if (param != null && propertyName != null && purpose != null) {
            switch (purpose) {
                case CREATE_TIME: 
                case UPDATE_TIME: 
                case CREATE_USER: 
                case UPDATE_USER: 
                case DATA_HOLDER: 
                case DATA_ORGAN: {
                    if (!HussarUtils.isNotEmpty((Object)param.get(propertyName))) break;
                    param.remove(propertyName);
                    break;
                }
            }
        }
    }

    public static UpdateEntity getFlagRemoveByDel(ModelColumnDto column, DeleteEntity deleteEntity) {
        UpdateEntity updateEntity = new UpdateEntity();
        ColumnEntity columnEntity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)column, DmlEntityUtil.getTableEntity(column.getPollName(), column.getTableName()));
        SetEntity setEntity = new SetEntity();
        setEntity.setColumnEntity(columnEntity);
        setEntity.setOperatorType(OperatorType.EQ);
        setEntity.setParamColumnAlias(column.getColumnAlias());
        updateEntity.setSetEntityList(Collections.singletonList(setEntity));
        updateEntity.setWhereEntityList(deleteEntity.getWhereEntityList());
        updateEntity.init((Map)deleteEntity.getParam());
        return updateEntity;
    }

    public static List<WhereEntity> getColumnWhere(ModelTableMappingDTO model) {
        ArrayList<WhereEntity> whereEntityList = new ArrayList<WhereEntity>();
        TableEntity tableEntity = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName());
        for (ModelColumnDto column : model.getColumns()) {
            ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)column, tableEntity);
            WhereEntity whereEntity = DmlEntityUtil.newWhereEntity(null, MatchTypeEnum.AND, OperatorType.EQ, entity, entity.getColAlias());
            whereEntityList.add(whereEntity);
        }
        return whereEntityList;
    }

    public static List<WhereEntity> getConditionWhere(List<EngineQueryConditionDto> conditions, ModelTableMappingDTO model, Map<String, Object> param) {
        if (HussarUtils.isEmpty(conditions) || HussarUtils.isEmpty((Object)model)) {
            return new ArrayList<WhereEntity>();
        }
        AtomicInteger paramNameSeq = new AtomicInteger(0);
        HashMap<String, ColumnEntity> columnEntityMap = new HashMap<String, ColumnEntity>();
        DmlEntityUtil.getModelColumnEntityMap(model, columnEntityMap, 1);
        return DmlEntityUtil.getConditionChildWhere(conditions, null, columnEntityMap, param, paramNameSeq);
    }

    public static void getModelColumnEntityMap(ModelTableMappingDTO model, Map<String, ColumnEntity> columnEntityMap, int type) {
        TableEntity tableEntity = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName());
        for (ModelColumnDto column : model.getColumns()) {
            ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)column, tableEntity);
            columnEntityMap.put(type == 1 ? entity.getColAlias() : entity.getColName(), entity);
        }
        if (HussarUtils.isNotEmpty((Object)model.getSlaveTables())) {
            for (ModelTableMappingDTO slaveTable : model.getSlaveTables()) {
                if (!ModelRelation.ONE_ONE.equals((Object)slaveTable.getRelation())) continue;
                DmlEntityUtil.getModelColumnEntityMap(slaveTable, columnEntityMap, type);
            }
        }
    }

    public static List<WhereEntity> getConditionChildWhere(List<EngineQueryConditionDto> conditions, Long parentId, Map<String, ColumnEntity> columnEntityMap, Map<String, Object> param, AtomicInteger paramNameSeq) {
        if (paramNameSeq == null) {
            paramNameSeq = new AtomicInteger(0);
        }
        ArrayList<WhereEntity> whereEntityList = new ArrayList<WhereEntity>();
        for (EngineQueryConditionDto condition : conditions) {
            ColumnEntity columnEntity;
            if (HussarUtils.isNotEmpty(condition.getChildren())) {
                Long newParentId = EngineUtil.getId();
                WhereEntity parentWhere = new WhereEntity();
                parentWhere.setId(newParentId);
                parentWhere.setParentId(parentId);
                parentWhere.setMatchType(MatchTypeEnum.getByValue((String)condition.getMatch()));
                whereEntityList.add(parentWhere);
                whereEntityList.addAll(DmlEntityUtil.getConditionChildWhere(condition.getChildren(), newParentId, columnEntityMap, param, paramNameSeq));
                continue;
            }
            String field = condition.getField();
            if (HussarUtils.isEmpty((Object)condition.getField()) || HussarUtils.isEmpty((Object)(columnEntity = columnEntityMap.get(field))) || HussarUtils.isEmpty((Object)condition.getRule()) || HussarUtils.isEmpty((Object)condition.getVal())) continue;
            String genParamName = "MPGENVAL" + paramNameSeq.incrementAndGet();
            OperatorType operatorType = OperatorType.getByValue((String)condition.getRule());
            MatchTypeEnum matchType = MatchTypeEnum.getByValue((String)condition.getMatch());
            WhereEntity whereEntity = DmlEntityUtil.newWhereEntity(parentId, matchType, operatorType, columnEntity, genParamName);
            whereEntityList.add(whereEntity);
            param.put(genParamName, condition.getVal());
        }
        return whereEntityList;
    }

    public static List<OrderByEntity> getColumnOrder(ModelTableMappingDTO model) {
        ArrayList<OrderByEntity> orderByEntityList = new ArrayList<OrderByEntity>();
        DmlEntityUtil.getSlaveModelOrder(model, orderByEntityList);
        return orderByEntityList;
    }

    private static void getSlaveModelOrder(ModelTableMappingDTO model, List<OrderByEntity> orderByEntityList) {
        TableEntity tableEntity = DmlEntityUtil.getTableEntity(model.getPollName(), model.getTableName());
        for (ModelColumnDto column : model.getColumns()) {
            ColumnEntity entity = DmlEntityUtil.getColumnEntity((MetadataColumnDto)column, tableEntity);
            OrderByEntity orderByEntity = new OrderByEntity();
            orderByEntity.setColumnEntity(entity);
            orderByEntity.setOrderType(OrderByType.ASC);
            orderByEntityList.add(orderByEntity);
        }
        if (HussarUtils.isNotEmpty((Object)model.getSlaveTables())) {
            for (ModelTableMappingDTO slaveTable : model.getSlaveTables()) {
                if (!ModelRelation.ONE_ONE.equals((Object)slaveTable.getRelation())) continue;
                DmlEntityUtil.getSlaveModelOrder(slaveTable, orderByEntityList);
            }
        }
    }
}

